/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.repositories.IndexId;
import org.elasticsearch.snapshots.SnapshotId;

public final class RepositoryData {
    public static final long EMPTY_REPO_GEN = -1L;
    public static final RepositoryData EMPTY = new RepositoryData(-1L, Collections.emptyList(), Collections.emptyMap(), Collections.emptyList());
    private final long genId;
    private final List<SnapshotId> snapshotIds;
    private final Map<String, IndexId> indices;
    private final Map<IndexId, Set<SnapshotId>> indexSnapshots;
    private final List<SnapshotId> incompatibleSnapshotIds;
    private static final String SNAPSHOTS = "snapshots";
    private static final String INCOMPATIBLE_SNAPSHOTS = "incompatible-snapshots";
    private static final String INDICES = "indices";
    private static final String INDEX_ID = "id";

    public RepositoryData(long genId, List<SnapshotId> snapshotIds, Map<IndexId, Set<SnapshotId>> indexSnapshots, List<SnapshotId> incompatibleSnapshotIds) {
        this.genId = genId;
        this.snapshotIds = Collections.unmodifiableList(snapshotIds);
        this.indices = Collections.unmodifiableMap(indexSnapshots.keySet().stream().collect(Collectors.toMap(IndexId::getName, Function.identity())));
        this.indexSnapshots = Collections.unmodifiableMap(indexSnapshots);
        this.incompatibleSnapshotIds = Collections.unmodifiableList(incompatibleSnapshotIds);
    }

    protected RepositoryData copy() {
        return new RepositoryData(this.genId, this.snapshotIds, this.indexSnapshots, this.incompatibleSnapshotIds);
    }

    public long getGenId() {
        return this.genId;
    }

    public List<SnapshotId> getSnapshotIds() {
        return this.snapshotIds;
    }

    public List<SnapshotId> getIncompatibleSnapshotIds() {
        return this.incompatibleSnapshotIds;
    }

    public List<SnapshotId> getAllSnapshotIds() {
        ArrayList<SnapshotId> allSnapshotIds = new ArrayList<SnapshotId>(this.snapshotIds.size() + this.incompatibleSnapshotIds.size());
        allSnapshotIds.addAll(this.snapshotIds);
        allSnapshotIds.addAll(this.incompatibleSnapshotIds);
        return Collections.unmodifiableList(allSnapshotIds);
    }

    public Map<String, IndexId> getIndices() {
        return this.indices;
    }

    public RepositoryData addSnapshot(SnapshotId snapshotId, List<IndexId> snapshottedIndices) {
        if (this.snapshotIds.contains(snapshotId)) {
            return this;
        }
        ArrayList<SnapshotId> snapshots = new ArrayList<SnapshotId>(this.snapshotIds);
        snapshots.add(snapshotId);
        HashMap<IndexId, Set<SnapshotId>> allIndexSnapshots = new HashMap<IndexId, Set<SnapshotId>>(this.indexSnapshots);
        for (IndexId indexId : snapshottedIndices) {
            Set<SnapshotId> ids;
            if (allIndexSnapshots.containsKey(indexId)) {
                ids = (Set)allIndexSnapshots.get(indexId);
                if (ids == null) {
                    ids = new LinkedHashSet();
                    allIndexSnapshots.put(indexId, ids);
                }
                ids.add(snapshotId);
                continue;
            }
            ids = new LinkedHashSet();
            ids.add(snapshotId);
            allIndexSnapshots.put(indexId, ids);
        }
        return new RepositoryData(this.genId, snapshots, allIndexSnapshots, this.incompatibleSnapshotIds);
    }

    public RepositoryData removeSnapshot(SnapshotId snapshotId) {
        List<SnapshotId> newSnapshotIds = this.snapshotIds.stream().filter(id -> !snapshotId.equals(id)).collect(Collectors.toList());
        if (newSnapshotIds.size() == this.snapshotIds.size()) {
            throw new ResourceNotFoundException("Attempting to remove non-existent snapshot [{}] from repository data", snapshotId);
        }
        HashMap<IndexId, Set<SnapshotId>> indexSnapshots = new HashMap<IndexId, Set<SnapshotId>>();
        for (IndexId indexId : this.indices.values()) {
            Set<SnapshotId> set;
            Set<SnapshotId> snapshotIds = this.indexSnapshots.get(indexId);
            assert (snapshotIds != null);
            if (snapshotIds.contains(snapshotId)) {
                if (snapshotIds.size() == 1) continue;
                set = new LinkedHashSet<SnapshotId>(snapshotIds);
                set.remove(snapshotId);
            } else {
                set = snapshotIds;
            }
            indexSnapshots.put(indexId, set);
        }
        return new RepositoryData(this.genId, newSnapshotIds, indexSnapshots, this.incompatibleSnapshotIds);
    }

    public RepositoryData addIncompatibleSnapshots(List<SnapshotId> incompatibleSnapshotIds) {
        ArrayList<SnapshotId> newSnapshotIds = new ArrayList<SnapshotId>(this.snapshotIds);
        ArrayList<SnapshotId> newIncompatibleSnapshotIds = new ArrayList<SnapshotId>(this.incompatibleSnapshotIds);
        for (SnapshotId snapshotId : incompatibleSnapshotIds) {
            newSnapshotIds.remove(snapshotId);
            newIncompatibleSnapshotIds.add(snapshotId);
        }
        return new RepositoryData(this.genId, newSnapshotIds, this.indexSnapshots, newIncompatibleSnapshotIds);
    }

    public Set<SnapshotId> getSnapshots(IndexId indexId) {
        Set<SnapshotId> snapshotIds = this.indexSnapshots.get(indexId);
        if (snapshotIds == null) {
            throw new IllegalArgumentException("unknown snapshot index " + indexId + "");
        }
        return snapshotIds;
    }

    public RepositoryData initIndices(Map<IndexId, Set<SnapshotId>> indexSnapshots) {
        return new RepositoryData(this.genId, this.snapshotIds, indexSnapshots, this.incompatibleSnapshotIds);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RepositoryData that = (RepositoryData)obj;
        return this.snapshotIds.equals(that.snapshotIds) && this.indices.equals(that.indices) && this.indexSnapshots.equals(that.indexSnapshots) && this.incompatibleSnapshotIds.equals(that.incompatibleSnapshotIds);
    }

    public int hashCode() {
        return Objects.hash(this.snapshotIds, this.indices, this.indexSnapshots, this.incompatibleSnapshotIds);
    }

    public IndexId resolveIndexId(String indexName) {
        if (this.indices.containsKey(indexName)) {
            return this.indices.get(indexName);
        }
        return new IndexId(indexName, indexName);
    }

    public List<IndexId> resolveIndices(List<String> indices) {
        ArrayList<IndexId> resolvedIndices = new ArrayList<IndexId>(indices.size());
        for (String indexName : indices) {
            resolvedIndices.add(this.resolveIndexId(indexName));
        }
        return resolvedIndices;
    }

    public List<IndexId> resolveNewIndices(List<String> indicesToResolve) {
        ArrayList<IndexId> snapshotIndices = new ArrayList<IndexId>();
        for (String index : indicesToResolve) {
            IndexId indexId = this.indices.containsKey(index) ? this.indices.get(index) : new IndexId(index, UUIDs.randomBase64UUID());
            snapshotIndices.add(indexId);
        }
        return snapshotIndices;
    }

    public XContentBuilder snapshotsToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startArray(SNAPSHOTS);
        for (SnapshotId snapshot : this.getSnapshotIds()) {
            snapshot.toXContent(builder, params);
        }
        builder.endArray();
        builder.startObject(INDICES);
        for (IndexId indexId : this.getIndices().values()) {
            builder.startObject(indexId.getName());
            builder.field(INDEX_ID, indexId.getId());
            builder.startArray(SNAPSHOTS);
            Set<SnapshotId> snapshotIds = this.indexSnapshots.get(indexId);
            assert (snapshotIds != null);
            for (SnapshotId snapshotId : snapshotIds) {
                snapshotId.toXContent(builder, params);
            }
            builder.endArray();
            builder.endObject();
        }
        builder.endObject();
        builder.endObject();
        return builder;
    }

    public static RepositoryData snapshotsFromXContent(XContentParser parser, long genId) throws IOException {
        ArrayList<SnapshotId> snapshots = new ArrayList<SnapshotId>();
        HashMap<IndexId, Set<SnapshotId>> indexSnapshots = new HashMap<IndexId, Set<SnapshotId>>();
        if (parser.nextToken() == XContentParser.Token.START_OBJECT) {
            while (parser.nextToken() == XContentParser.Token.FIELD_NAME) {
                String currentFieldName = parser.currentName();
                if (SNAPSHOTS.equals(currentFieldName)) {
                    if (parser.nextToken() == XContentParser.Token.START_ARRAY) {
                        while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                            snapshots.add(SnapshotId.fromXContent(parser));
                        }
                        continue;
                    }
                    throw new ElasticsearchParseException("expected array for [" + currentFieldName + "]", new Object[0]);
                }
                if (INDICES.equals(currentFieldName)) {
                    if (parser.nextToken() != XContentParser.Token.START_OBJECT) {
                        throw new ElasticsearchParseException("start object expected [indices]", new Object[0]);
                    }
                    while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                        String indexName = parser.currentName();
                        String indexId = null;
                        LinkedHashSet<SnapshotId> snapshotIds = new LinkedHashSet<SnapshotId>();
                        if (parser.nextToken() != XContentParser.Token.START_OBJECT) {
                            throw new ElasticsearchParseException("start object expected index[" + indexName + "]", new Object[0]);
                        }
                        while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                            String indexMetaFieldName = parser.currentName();
                            parser.nextToken();
                            if (INDEX_ID.equals(indexMetaFieldName)) {
                                indexId = parser.text();
                                continue;
                            }
                            if (!SNAPSHOTS.equals(indexMetaFieldName)) continue;
                            if (parser.currentToken() != XContentParser.Token.START_ARRAY) {
                                throw new ElasticsearchParseException("start array expected [snapshots]", new Object[0]);
                            }
                            while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                                snapshotIds.add(SnapshotId.fromXContent(parser));
                            }
                        }
                        assert (indexId != null);
                        indexSnapshots.put(new IndexId(indexName, indexId), snapshotIds);
                    }
                    continue;
                }
                throw new ElasticsearchParseException("unknown field name  [" + currentFieldName + "]", new Object[0]);
            }
        } else {
            throw new ElasticsearchParseException("start object expected", new Object[0]);
        }
        return new RepositoryData(genId, snapshots, indexSnapshots, Collections.emptyList());
    }

    public XContentBuilder incompatibleSnapshotsToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startArray(INCOMPATIBLE_SNAPSHOTS);
        for (SnapshotId snapshot : this.getIncompatibleSnapshotIds()) {
            snapshot.toXContent(builder, params);
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    public RepositoryData incompatibleSnapshotsFromXContent(XContentParser parser) throws IOException {
        ArrayList<SnapshotId> incompatibleSnapshotIds = new ArrayList<SnapshotId>();
        if (parser.nextToken() == XContentParser.Token.START_OBJECT) {
            while (parser.nextToken() == XContentParser.Token.FIELD_NAME) {
                String currentFieldName = parser.currentName();
                if (INCOMPATIBLE_SNAPSHOTS.equals(currentFieldName)) {
                    if (parser.nextToken() == XContentParser.Token.START_ARRAY) {
                        while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                            incompatibleSnapshotIds.add(SnapshotId.fromXContent(parser));
                        }
                        continue;
                    }
                    throw new ElasticsearchParseException("expected array for [" + currentFieldName + "]", new Object[0]);
                }
                throw new ElasticsearchParseException("unknown field name  [" + currentFieldName + "]", new Object[0]);
            }
        } else {
            throw new ElasticsearchParseException("start object expected", new Object[0]);
        }
        return new RepositoryData(this.genId, this.snapshotIds, this.indexSnapshots, incompatibleSnapshotIds);
    }
}

