/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.analysis;

import java.util.Locale;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.core.KeywordTokenizer;
import org.apache.lucene.analysis.core.LetterTokenizer;
import org.apache.lucene.analysis.core.LowerCaseTokenizer;
import org.apache.lucene.analysis.core.WhitespaceTokenizer;
import org.apache.lucene.analysis.ngram.EdgeNGramTokenizer;
import org.apache.lucene.analysis.ngram.NGramTokenizer;
import org.apache.lucene.analysis.path.PathHierarchyTokenizer;
import org.apache.lucene.analysis.pattern.PatternTokenizer;
import org.apache.lucene.analysis.standard.ClassicTokenizer;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.apache.lucene.analysis.standard.UAX29URLEmailTokenizer;
import org.apache.lucene.analysis.th.ThaiTokenizer;
import org.elasticsearch.Version;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.index.analysis.MultiTermAwareComponent;
import org.elasticsearch.index.analysis.TokenFilterFactory;
import org.elasticsearch.index.analysis.TokenizerFactory;
import org.elasticsearch.indices.analysis.PreBuiltCacheFactory;
import org.elasticsearch.indices.analysis.PreBuiltTokenFilters;

public enum PreBuiltTokenizers {
    STANDARD(PreBuiltCacheFactory.CachingStrategy.LUCENE){

        @Override
        protected Tokenizer create(Version version) {
            return new StandardTokenizer();
        }
    }
    ,
    CLASSIC(PreBuiltCacheFactory.CachingStrategy.LUCENE){

        @Override
        protected Tokenizer create(Version version) {
            return new ClassicTokenizer();
        }
    }
    ,
    UAX_URL_EMAIL(PreBuiltCacheFactory.CachingStrategy.LUCENE){

        @Override
        protected Tokenizer create(Version version) {
            return new UAX29URLEmailTokenizer();
        }
    }
    ,
    PATH_HIERARCHY(PreBuiltCacheFactory.CachingStrategy.ONE){

        @Override
        protected Tokenizer create(Version version) {
            return new PathHierarchyTokenizer();
        }
    }
    ,
    KEYWORD(PreBuiltCacheFactory.CachingStrategy.ONE){

        @Override
        protected Tokenizer create(Version version) {
            return new KeywordTokenizer();
        }
    }
    ,
    LETTER(PreBuiltCacheFactory.CachingStrategy.LUCENE){

        @Override
        protected Tokenizer create(Version version) {
            return new LetterTokenizer();
        }
    }
    ,
    LOWERCASE(PreBuiltCacheFactory.CachingStrategy.LUCENE){

        @Override
        protected Tokenizer create(Version version) {
            return new LowerCaseTokenizer();
        }

        @Override
        protected TokenFilterFactory getMultiTermComponent(Version version) {
            return PreBuiltTokenFilters.LOWERCASE.getTokenFilterFactory(version);
        }
    }
    ,
    WHITESPACE(PreBuiltCacheFactory.CachingStrategy.LUCENE){

        @Override
        protected Tokenizer create(Version version) {
            return new WhitespaceTokenizer();
        }
    }
    ,
    NGRAM(PreBuiltCacheFactory.CachingStrategy.LUCENE){

        @Override
        protected Tokenizer create(Version version) {
            return new NGramTokenizer();
        }
    }
    ,
    EDGE_NGRAM(PreBuiltCacheFactory.CachingStrategy.LUCENE){

        @Override
        protected Tokenizer create(Version version) {
            return new EdgeNGramTokenizer(1, 1);
        }
    }
    ,
    PATTERN(PreBuiltCacheFactory.CachingStrategy.ONE){

        @Override
        protected Tokenizer create(Version version) {
            return new PatternTokenizer(Regex.compile("\\W+", null), -1);
        }
    }
    ,
    THAI(PreBuiltCacheFactory.CachingStrategy.ONE){

        @Override
        protected Tokenizer create(Version version) {
            return new ThaiTokenizer();
        }
    };

    protected final PreBuiltCacheFactory.PreBuiltCache<TokenizerFactory> cache;

    protected abstract Tokenizer create(Version var1);

    protected TokenFilterFactory getMultiTermComponent(Version version) {
        return null;
    }

    private PreBuiltTokenizers(PreBuiltCacheFactory.CachingStrategy cachingStrategy) {
        this.cache = PreBuiltCacheFactory.getCache(cachingStrategy);
    }

    public synchronized TokenizerFactory getTokenizerFactory(final Version version) {
        TokenizerFactory tokenizerFactory = this.cache.get(version);
        if (tokenizerFactory == null) {
            final String finalName = this.name().toLowerCase(Locale.ROOT);
            tokenizerFactory = this.getMultiTermComponent(version) != null ? new MultiTermAwareTokenizerFactory(){

                @Override
                public String name() {
                    return finalName;
                }

                @Override
                public Tokenizer create() {
                    return PreBuiltTokenizers.this.create(version);
                }

                @Override
                public Object getMultiTermComponent() {
                    return PreBuiltTokenizers.this.getMultiTermComponent(version);
                }
            } : new TokenizerFactory(){

                @Override
                public String name() {
                    return finalName;
                }

                @Override
                public Tokenizer create() {
                    return PreBuiltTokenizers.this.create(version);
                }
            };
            this.cache.put(version, tokenizerFactory);
        }
        return tokenizerFactory;
    }

    public static PreBuiltTokenizers getOrDefault(String name, PreBuiltTokenizers defaultTokenizer) {
        try {
            return PreBuiltTokenizers.valueOf(name.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            return defaultTokenizer;
        }
    }

    private static interface MultiTermAwareTokenizerFactory
    extends TokenizerFactory,
    MultiTermAwareComponent {
    }
}

