/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiDocValues;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.join.JoinUtil;
import org.apache.lucene.search.join.ScoreMode;
import org.apache.lucene.search.similarities.Similarity;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.fielddata.IndexParentChildFieldData;
import org.elasticsearch.index.fielddata.plain.ParentChildIndexFieldData;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.ParentFieldMapper;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.InnerHitBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.index.query.QueryShardException;

public class HasChildQueryBuilder
extends AbstractQueryBuilder<HasChildQueryBuilder> {
    public static final String NAME = "has_child";
    public static final int DEFAULT_MAX_CHILDREN = Integer.MAX_VALUE;
    public static final int DEFAULT_MIN_CHILDREN = 0;
    public static final boolean DEFAULT_IGNORE_UNMAPPED = false;
    private static final ParseField QUERY_FIELD = new ParseField("query", "filter");
    private static final ParseField TYPE_FIELD = new ParseField("type", "child_type");
    private static final ParseField MAX_CHILDREN_FIELD = new ParseField("max_children", new String[0]);
    private static final ParseField MIN_CHILDREN_FIELD = new ParseField("min_children", new String[0]);
    private static final ParseField SCORE_MODE_FIELD = new ParseField("score_mode", new String[0]);
    private static final ParseField INNER_HITS_FIELD = new ParseField("inner_hits", new String[0]);
    private static final ParseField IGNORE_UNMAPPED_FIELD = new ParseField("ignore_unmapped", new String[0]);
    private final QueryBuilder query;
    private final String type;
    private final ScoreMode scoreMode;
    private InnerHitBuilder innerHitBuilder;
    private int minChildren = 0;
    private int maxChildren = Integer.MAX_VALUE;
    private boolean ignoreUnmapped = false;

    public HasChildQueryBuilder(String type, QueryBuilder query, ScoreMode scoreMode) {
        this(type, query, 0, Integer.MAX_VALUE, scoreMode, null);
    }

    private HasChildQueryBuilder(String type, QueryBuilder query, int minChildren, int maxChildren, ScoreMode scoreMode, InnerHitBuilder innerHitBuilder) {
        this.type = HasChildQueryBuilder.requireValue(type, "[has_child] requires 'type' field");
        this.query = HasChildQueryBuilder.requireValue(query, "[has_child] requires 'query' field");
        this.scoreMode = HasChildQueryBuilder.requireValue(scoreMode, "[has_child] requires 'score_mode' field");
        this.innerHitBuilder = innerHitBuilder;
        this.minChildren = minChildren;
        this.maxChildren = maxChildren;
    }

    public HasChildQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.type = in.readString();
        this.minChildren = in.readInt();
        this.maxChildren = in.readInt();
        this.scoreMode = ScoreMode.values()[in.readVInt()];
        this.query = in.readNamedWriteable(QueryBuilder.class);
        this.innerHitBuilder = in.readOptionalWriteable(InnerHitBuilder::new);
        this.ignoreUnmapped = in.readBoolean();
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeString(this.type);
        out.writeInt(this.minChildren);
        out.writeInt(this.maxChildren);
        out.writeVInt(this.scoreMode.ordinal());
        out.writeNamedWriteable(this.query);
        out.writeOptionalWriteable(this.innerHitBuilder);
        out.writeBoolean(this.ignoreUnmapped);
    }

    public HasChildQueryBuilder minMaxChildren(int minChildren, int maxChildren) {
        if (minChildren < 0) {
            throw new IllegalArgumentException("[has_child] requires non-negative 'min_children' field");
        }
        if (maxChildren < 0) {
            throw new IllegalArgumentException("[has_child] requires non-negative 'max_children' field");
        }
        if (maxChildren < minChildren) {
            throw new IllegalArgumentException("[has_child] 'max_children' is less than 'min_children'");
        }
        this.minChildren = minChildren;
        this.maxChildren = maxChildren;
        return this;
    }

    public InnerHitBuilder innerHit() {
        return this.innerHitBuilder;
    }

    public HasChildQueryBuilder innerHit(InnerHitBuilder innerHit, boolean ignoreUnmapped) {
        this.innerHitBuilder = new InnerHitBuilder(Objects.requireNonNull(innerHit), this.query, this.type, ignoreUnmapped);
        return this;
    }

    public QueryBuilder query() {
        return this.query;
    }

    public String childType() {
        return this.type;
    }

    public ScoreMode scoreMode() {
        return this.scoreMode;
    }

    public int minChildren() {
        return this.minChildren;
    }

    public int maxChildren() {
        return this.maxChildren;
    }

    public HasChildQueryBuilder ignoreUnmapped(boolean ignoreUnmapped) {
        this.ignoreUnmapped = ignoreUnmapped;
        return this;
    }

    public boolean ignoreUnmapped() {
        return this.ignoreUnmapped;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.field(QUERY_FIELD.getPreferredName());
        this.query.toXContent(builder, params);
        builder.field(TYPE_FIELD.getPreferredName(), this.type);
        builder.field(SCORE_MODE_FIELD.getPreferredName(), HasChildQueryBuilder.scoreModeAsString(this.scoreMode));
        builder.field(MIN_CHILDREN_FIELD.getPreferredName(), this.minChildren);
        builder.field(MAX_CHILDREN_FIELD.getPreferredName(), this.maxChildren);
        builder.field(IGNORE_UNMAPPED_FIELD.getPreferredName(), this.ignoreUnmapped);
        this.printBoostAndQueryName(builder);
        if (this.innerHitBuilder != null) {
            builder.field(INNER_HITS_FIELD.getPreferredName(), this.innerHitBuilder, params);
        }
        builder.endObject();
    }

    public static Optional<HasChildQueryBuilder> fromXContent(QueryParseContext parseContext) throws IOException {
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        float boost = 1.0f;
        String childType = null;
        ScoreMode scoreMode = ScoreMode.None;
        int minChildren = 0;
        int maxChildren = Integer.MAX_VALUE;
        boolean ignoreUnmapped = false;
        String queryName = null;
        InnerHitBuilder innerHitBuilder = null;
        String currentFieldName = null;
        Optional<Object> iqb = Optional.empty();
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (parseContext.isDeprecatedSetting(currentFieldName)) continue;
            if (token == XContentParser.Token.START_OBJECT) {
                if (QUERY_FIELD.match(currentFieldName)) {
                    iqb = parseContext.parseInnerQueryBuilder();
                    continue;
                }
                if (INNER_HITS_FIELD.match(currentFieldName)) {
                    innerHitBuilder = InnerHitBuilder.fromXContent(parseContext);
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "[has_child] query does not support [" + currentFieldName + "]", new Object[0]);
            }
            if (!token.isValue()) continue;
            if (TYPE_FIELD.match(currentFieldName)) {
                childType = parser.text();
                continue;
            }
            if (SCORE_MODE_FIELD.match(currentFieldName)) {
                scoreMode = HasChildQueryBuilder.parseScoreMode(parser.text());
                continue;
            }
            if (AbstractQueryBuilder.BOOST_FIELD.match(currentFieldName)) {
                boost = parser.floatValue();
                continue;
            }
            if (MIN_CHILDREN_FIELD.match(currentFieldName)) {
                minChildren = parser.intValue(true);
                continue;
            }
            if (MAX_CHILDREN_FIELD.match(currentFieldName)) {
                maxChildren = parser.intValue(true);
                continue;
            }
            if (IGNORE_UNMAPPED_FIELD.match(currentFieldName)) {
                ignoreUnmapped = parser.booleanValue();
                continue;
            }
            if (AbstractQueryBuilder.NAME_FIELD.match(currentFieldName)) {
                queryName = parser.text();
                continue;
            }
            throw new ParsingException(parser.getTokenLocation(), "[has_child] query does not support [" + currentFieldName + "]", new Object[0]);
        }
        if (!iqb.isPresent()) {
            return Optional.empty();
        }
        HasChildQueryBuilder hasChildQueryBuilder = new HasChildQueryBuilder(childType, (QueryBuilder)iqb.get(), scoreMode);
        hasChildQueryBuilder.minMaxChildren(minChildren, maxChildren);
        hasChildQueryBuilder.queryName(queryName);
        hasChildQueryBuilder.boost(boost);
        hasChildQueryBuilder.ignoreUnmapped(ignoreUnmapped);
        if (innerHitBuilder != null) {
            hasChildQueryBuilder.innerHit(innerHitBuilder, ignoreUnmapped);
        }
        return Optional.of(hasChildQueryBuilder);
    }

    public static ScoreMode parseScoreMode(String scoreModeString) {
        if ("none".equals(scoreModeString)) {
            return ScoreMode.None;
        }
        if ("min".equals(scoreModeString)) {
            return ScoreMode.Min;
        }
        if ("max".equals(scoreModeString)) {
            return ScoreMode.Max;
        }
        if ("avg".equals(scoreModeString)) {
            return ScoreMode.Avg;
        }
        if ("sum".equals(scoreModeString)) {
            return ScoreMode.Total;
        }
        throw new IllegalArgumentException("No score mode for child query [" + scoreModeString + "] found");
    }

    public static String scoreModeAsString(ScoreMode scoreMode) {
        if (scoreMode == ScoreMode.Total) {
            return "sum";
        }
        return scoreMode.name().toLowerCase(Locale.ROOT);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Query doToQuery(QueryShardContext context) throws IOException {
        Query innerQuery;
        String[] previousTypes = context.getTypes();
        context.setTypes(this.type);
        try {
            innerQuery = this.query.toQuery(context);
        }
        finally {
            context.setTypes(previousTypes);
        }
        DocumentMapper childDocMapper = context.documentMapper(this.type);
        if (childDocMapper == null) {
            if (this.ignoreUnmapped) {
                return new MatchNoDocsQuery();
            }
            throw new QueryShardException(context, "[has_child] no mapping found for type [" + this.type + "]", new Object[0]);
        }
        ParentFieldMapper parentFieldMapper = childDocMapper.parentFieldMapper();
        if (!parentFieldMapper.active()) {
            throw new QueryShardException(context, "[has_child] _parent field has no parent type configured", new Object[0]);
        }
        String parentType = parentFieldMapper.type();
        DocumentMapper parentDocMapper = context.getMapperService().documentMapper(parentType);
        if (parentDocMapper == null) {
            throw new QueryShardException(context, "[has_child] Type [" + this.type + "] points to a non existent parent type [" + parentType + "]", new Object[0]);
        }
        innerQuery = Queries.filtered(innerQuery, childDocMapper.typeFilter());
        ParentChildIndexFieldData parentChildIndexFieldData = (ParentChildIndexFieldData)context.getForField(parentFieldMapper.fieldType());
        return new LateParsingQuery(parentDocMapper.typeFilter(), innerQuery, this.minChildren(), this.maxChildren(), parentType, this.scoreMode, parentChildIndexFieldData, context.getSearchSimilarity());
    }

    @Override
    protected boolean doEquals(HasChildQueryBuilder that) {
        return Objects.equals(this.query, that.query) && Objects.equals(this.type, that.type) && Objects.equals(this.scoreMode, that.scoreMode) && Objects.equals(this.minChildren, that.minChildren) && Objects.equals(this.maxChildren, that.maxChildren) && Objects.equals(this.innerHitBuilder, that.innerHitBuilder) && Objects.equals(this.ignoreUnmapped, that.ignoreUnmapped);
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.query, this.type, this.scoreMode, this.minChildren, this.maxChildren, this.innerHitBuilder, this.ignoreUnmapped);
    }

    @Override
    protected QueryBuilder doRewrite(QueryRewriteContext queryRewriteContext) throws IOException {
        QueryBuilder rewrittenQuery = this.query.rewrite(queryRewriteContext);
        if (rewrittenQuery != this.query) {
            InnerHitBuilder rewrittenInnerHit = InnerHitBuilder.rewrite(this.innerHitBuilder, rewrittenQuery);
            HasChildQueryBuilder hasChildQueryBuilder = new HasChildQueryBuilder(this.type, rewrittenQuery, this.minChildren, this.maxChildren, this.scoreMode, rewrittenInnerHit);
            hasChildQueryBuilder.ignoreUnmapped(this.ignoreUnmapped);
            return hasChildQueryBuilder;
        }
        return this;
    }

    @Override
    protected void extractInnerHitBuilders(Map<String, InnerHitBuilder> innerHits) {
        if (this.innerHitBuilder != null) {
            this.innerHitBuilder.inlineInnerHits(innerHits);
        }
    }

    public static final class LateParsingQuery
    extends Query {
        private final Query toQuery;
        private final Query innerQuery;
        private final int minChildren;
        private final int maxChildren;
        private final String parentType;
        private final ScoreMode scoreMode;
        private final ParentChildIndexFieldData parentChildIndexFieldData;
        private final Similarity similarity;

        LateParsingQuery(Query toQuery, Query innerQuery, int minChildren, int maxChildren, String parentType, ScoreMode scoreMode, ParentChildIndexFieldData parentChildIndexFieldData, Similarity similarity) {
            this.toQuery = toQuery;
            this.innerQuery = innerQuery;
            this.minChildren = minChildren;
            this.maxChildren = maxChildren;
            this.parentType = parentType;
            this.scoreMode = scoreMode;
            this.parentChildIndexFieldData = parentChildIndexFieldData;
            this.similarity = similarity;
        }

        public Query rewrite(IndexReader reader) throws IOException {
            Query rewritten = super.rewrite(reader);
            if (rewritten != this) {
                return rewritten;
            }
            if (reader instanceof DirectoryReader) {
                String joinField = ParentFieldMapper.joinField(this.parentType);
                IndexSearcher indexSearcher = new IndexSearcher(reader);
                indexSearcher.setQueryCache(null);
                indexSearcher.setSimilarity(this.similarity);
                IndexParentChildFieldData indexParentChildFieldData = this.parentChildIndexFieldData.loadGlobal((DirectoryReader)reader);
                MultiDocValues.OrdinalMap ordinalMap = ParentChildIndexFieldData.getOrdinalMap(indexParentChildFieldData, this.parentType);
                return JoinUtil.createJoinQuery((String)joinField, (Query)this.innerQuery, (Query)this.toQuery, (IndexSearcher)indexSearcher, (ScoreMode)this.scoreMode, (MultiDocValues.OrdinalMap)ordinalMap, (int)this.minChildren, (int)this.maxChildren);
            }
            if (reader.leaves().isEmpty() && reader.numDocs() == 0) {
                return new MatchNoDocsQuery();
            }
            throw new IllegalStateException("can't load global ordinals for reader of type: " + reader.getClass() + " must be a DirectoryReader");
        }

        public boolean equals(Object o) {
            if (!this.sameClassAs(o)) {
                return false;
            }
            LateParsingQuery that = (LateParsingQuery)((Object)o);
            if (this.minChildren != that.minChildren) {
                return false;
            }
            if (this.maxChildren != that.maxChildren) {
                return false;
            }
            if (!this.toQuery.equals((Object)that.toQuery)) {
                return false;
            }
            if (!this.innerQuery.equals((Object)that.innerQuery)) {
                return false;
            }
            if (!this.parentType.equals(that.parentType)) {
                return false;
            }
            return this.scoreMode == that.scoreMode;
        }

        public int hashCode() {
            return Objects.hash(this.classHash(), this.toQuery, this.innerQuery, this.minChildren, this.maxChildren, this.parentType, this.scoreMode);
        }

        public String toString(String s) {
            return "LateParsingQuery {parentType=" + this.parentType + "}";
        }

        public int getMinChildren() {
            return this.minChildren;
        }

        public int getMaxChildren() {
            return this.maxChildren;
        }

        public ScoreMode getScoreMode() {
            return this.scoreMode;
        }

        public Query getInnerQuery() {
            return this.innerQuery;
        }

        public Similarity getSimilarity() {
            return this.similarity;
        }
    }
}

