/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.update;

import java.io.IOException;
import java.util.function.BiConsumer;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.support.replication.ReplicationResponse;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.get.GetResult;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.rest.RestStatus;

public class UpdateResponse
extends DocWriteResponse {
    private static final String GET = "get";
    private GetResult getResult;
    private static final ConstructingObjectParser<UpdateResponse, Void> PARSER = new ConstructingObjectParser(UpdateResponse.class.getName(), args -> {
        String index = (String)args[0];
        ShardId shardId = new ShardId(new Index(index, "_na_"), -1);
        String type = (String)args[1];
        String id = (String)args[2];
        long version = (Long)args[3];
        ReplicationResponse.ShardInfo shardInfo = (ReplicationResponse.ShardInfo)args[5];
        DocWriteResponse.Result result = null;
        for (DocWriteResponse.Result r : DocWriteResponse.Result.values()) {
            if (!r.getLowercase().equals(args[4])) continue;
            result = r;
            break;
        }
        UpdateResponse updateResponse = null;
        updateResponse = shardInfo != null ? new UpdateResponse(shardInfo, shardId, type, id, version, result) : new UpdateResponse(shardId, type, id, version, result);
        return updateResponse;
    });

    public UpdateResponse() {
    }

    public UpdateResponse(ShardId shardId, String type, String id, long version, DocWriteResponse.Result result) {
        this(new ReplicationResponse.ShardInfo(0, 0, new ReplicationResponse.ShardInfo.Failure[0]), shardId, type, id, version, result);
    }

    public UpdateResponse(ReplicationResponse.ShardInfo shardInfo, ShardId shardId, String type, String id, long version, DocWriteResponse.Result result) {
        super(shardId, type, id, version, result);
        this.setShardInfo(shardInfo);
    }

    public void setGetResult(GetResult getResult) {
        this.getResult = getResult;
    }

    public GetResult getGetResult() {
        return this.getResult;
    }

    @Override
    public RestStatus status() {
        return this.result == DocWriteResponse.Result.CREATED ? RestStatus.CREATED : super.status();
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        if (in.readBoolean()) {
            this.getResult = GetResult.readGetResult(in);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (this.getResult == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.getResult.writeTo(out);
        }
    }

    @Override
    public XContentBuilder innerToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        super.innerToXContent(builder, params);
        if (this.getGetResult() != null) {
            builder.startObject(GET);
            this.getGetResult().toXContentEmbedded(builder, params);
            builder.endObject();
        }
        return builder;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("UpdateResponse[");
        builder.append("index=").append(this.getIndex());
        builder.append(",type=").append(this.getType());
        builder.append(",id=").append(this.getId());
        builder.append(",version=").append(this.getVersion());
        builder.append(",result=").append(this.getResult().getLowercase());
        builder.append(",shards=").append(this.getShardInfo());
        return builder.append("]").toString();
    }

    public static UpdateResponse fromXContent(XContentParser parser) {
        return PARSER.apply(parser, null);
    }

    static {
        DocWriteResponse.declareParserFields(PARSER);
        BiConsumer<UpdateResponse, GetResult> setGetResult = (update, get) -> update.setGetResult(new GetResult(update.getIndex(), update.getType(), update.getId(), update.getVersion(), get.isExists(), get.internalSourceRef(), get.getFields()));
        PARSER.declareObject(setGetResult, (parser, context) -> GetResult.fromXContentEmbedded(parser), new ParseField(GET, new String[0]));
    }
}

