/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.index;

import java.io.IOException;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.support.replication.ReplicationResponse;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.rest.RestStatus;

public class IndexResponse
extends DocWriteResponse {
    private static final String CREATED = "created";
    private static final ConstructingObjectParser<IndexResponse, Void> PARSER = new ConstructingObjectParser(IndexResponse.class.getName(), args -> {
        ShardId shardId = new ShardId(new Index((String)args[0], "_na_"), -1);
        String type = (String)args[1];
        String id = (String)args[2];
        long version = (Long)args[3];
        ReplicationResponse.ShardInfo shardInfo = (ReplicationResponse.ShardInfo)args[5];
        boolean created = (Boolean)args[6];
        IndexResponse indexResponse = new IndexResponse(shardId, type, id, version, created);
        indexResponse.setShardInfo(shardInfo);
        return indexResponse;
    });

    public IndexResponse() {
    }

    public IndexResponse(ShardId shardId, String type, String id, long version, boolean created) {
        super(shardId, type, id, version, created ? DocWriteResponse.Result.CREATED : DocWriteResponse.Result.UPDATED);
    }

    @Override
    public RestStatus status() {
        return this.result == DocWriteResponse.Result.CREATED ? RestStatus.CREATED : super.status();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("IndexResponse[");
        builder.append("index=").append(this.getIndex());
        builder.append(",type=").append(this.getType());
        builder.append(",id=").append(this.getId());
        builder.append(",version=").append(this.getVersion());
        builder.append(",result=").append(this.getResult().getLowercase());
        builder.append(",shards=").append(Strings.toString(this.getShardInfo()));
        return builder.append("]").toString();
    }

    @Override
    public XContentBuilder innerToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        super.innerToXContent(builder, params);
        builder.field(CREATED, this.result == DocWriteResponse.Result.CREATED);
        return builder;
    }

    public static IndexResponse fromXContent(XContentParser parser) throws IOException {
        return PARSER.apply(parser, null);
    }

    static {
        DocWriteResponse.declareParserFields(PARSER);
        PARSER.declareBoolean(ConstructingObjectParser.constructorArg(), new ParseField(CREATED, new String[0]));
    }
}

