/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.suggest.phrase;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParseFieldMatcher;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.search.suggest.phrase.LinearInterpolatingScorer;
import org.elasticsearch.search.suggest.phrase.SmoothingModel;
import org.elasticsearch.search.suggest.phrase.WordScorer;

public final class LinearInterpolation
extends SmoothingModel {
    public static final String NAME = "linear";
    static final ParseField PARSE_FIELD = new ParseField("linear", new String[0]);
    private static final ParseField TRIGRAM_FIELD = new ParseField("trigram_lambda", new String[0]);
    private static final ParseField BIGRAM_FIELD = new ParseField("bigram_lambda", new String[0]);
    private static final ParseField UNIGRAM_FIELD = new ParseField("unigram_lambda", new String[0]);
    private final double trigramLambda;
    private final double bigramLambda;
    private final double unigramLambda;

    public LinearInterpolation(double trigramLambda, double bigramLambda, double unigramLambda) {
        double sum = trigramLambda + bigramLambda + unigramLambda;
        if (Math.abs(sum - 1.0) > 0.001) {
            throw new IllegalArgumentException("linear smoothing lambdas must sum to 1");
        }
        this.trigramLambda = trigramLambda;
        this.bigramLambda = bigramLambda;
        this.unigramLambda = unigramLambda;
    }

    public LinearInterpolation(StreamInput in) throws IOException {
        this.trigramLambda = in.readDouble();
        this.bigramLambda = in.readDouble();
        this.unigramLambda = in.readDouble();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeDouble(this.trigramLambda);
        out.writeDouble(this.bigramLambda);
        out.writeDouble(this.unigramLambda);
    }

    public double getTrigramLambda() {
        return this.trigramLambda;
    }

    public double getBigramLambda() {
        return this.bigramLambda;
    }

    public double getUnigramLambda() {
        return this.unigramLambda;
    }

    @Override
    protected XContentBuilder innerToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(TRIGRAM_FIELD.getPreferredName(), this.trigramLambda);
        builder.field(BIGRAM_FIELD.getPreferredName(), this.bigramLambda);
        builder.field(UNIGRAM_FIELD.getPreferredName(), this.unigramLambda);
        return builder;
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    protected boolean doEquals(SmoothingModel other) {
        LinearInterpolation otherModel = (LinearInterpolation)other;
        return Objects.equals(this.trigramLambda, otherModel.trigramLambda) && Objects.equals(this.bigramLambda, otherModel.bigramLambda) && Objects.equals(this.unigramLambda, otherModel.unigramLambda);
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.trigramLambda, this.bigramLambda, this.unigramLambda);
    }

    public static LinearInterpolation innerFromXContent(QueryParseContext parseContext) throws IOException {
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        String fieldName = null;
        double trigramLambda = 0.0;
        double bigramLambda = 0.0;
        double unigramLambda = 0.0;
        ParseFieldMatcher matcher = parseContext.getParseFieldMatcher();
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                fieldName = parser.currentName();
                continue;
            }
            if (token.isValue()) {
                if (TRIGRAM_FIELD.match(fieldName)) {
                    trigramLambda = parser.doubleValue();
                    if (!(trigramLambda < 0.0)) continue;
                    throw new IllegalArgumentException("trigram_lambda must be positive");
                }
                if (BIGRAM_FIELD.match(fieldName)) {
                    bigramLambda = parser.doubleValue();
                    if (!(bigramLambda < 0.0)) continue;
                    throw new IllegalArgumentException("bigram_lambda must be positive");
                }
                if (UNIGRAM_FIELD.match(fieldName)) {
                    unigramLambda = parser.doubleValue();
                    if (!(unigramLambda < 0.0)) continue;
                    throw new IllegalArgumentException("unigram_lambda must be positive");
                }
                throw new IllegalArgumentException("suggester[phrase][smoothing][linear] doesn't support field [" + fieldName + "]");
            }
            throw new ParsingException(parser.getTokenLocation(), "[linear] unknown token [" + (Object)((Object)token) + "] after [" + fieldName + "]", new Object[0]);
        }
        return new LinearInterpolation(trigramLambda, bigramLambda, unigramLambda);
    }

    @Override
    public WordScorer.WordScorerFactory buildWordScorerFactory() {
        return (reader, terms, field, realWordLikelyhood, separator) -> new LinearInterpolatingScorer(reader, terms, field, realWordLikelyhood, separator, this.trigramLambda, this.bigramLambda, this.unigramLambda);
    }
}

