/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.internal;

import java.io.IOException;
import java.util.Optional;
import java.util.function.Function;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.cluster.metadata.AliasMetaData;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.AliasFilterParsingException;
import org.elasticsearch.indices.InvalidAliasNameException;
import org.elasticsearch.search.Scroll;
import org.elasticsearch.search.builder.SearchSourceBuilder;

public interface ShardSearchRequest {
    public ShardId shardId();

    public String[] types();

    public SearchSourceBuilder source();

    public void source(SearchSourceBuilder var1);

    public int numberOfShards();

    public SearchType searchType();

    public QueryBuilder filteringAliases();

    public float indexBoost();

    public long nowInMillis();

    public Boolean requestCache();

    public Scroll scroll();

    public void setProfile(boolean var1);

    public boolean isProfile();

    public BytesReference cacheKey() throws IOException;

    public void rewrite(QueryShardContext var1) throws IOException;

    public static QueryBuilder parseAliasFilter(FilterParser filterParser, IndexMetaData metaData, String ... aliasNames) {
        if (aliasNames == null || aliasNames.length == 0) {
            return null;
        }
        Index index = metaData.getIndex();
        ImmutableOpenMap<String, AliasMetaData> aliases = metaData.getAliases();
        Function<AliasMetaData, QueryBuilder> parserFunction = alias -> {
            if (alias.filter() == null) {
                return null;
            }
            try {
                return filterParser.parse(alias.filter().uncompressed()).orElse(null);
            }
            catch (IOException ex) {
                throw new AliasFilterParsingException(index, alias.getAlias(), "Invalid alias filter", ex);
            }
        };
        if (aliasNames.length == 1) {
            AliasMetaData alias2 = aliases.get(aliasNames[0]);
            if (alias2 == null) {
                throw new InvalidAliasNameException(index, aliasNames[0], "Unknown alias name was passed to alias Filter");
            }
            return parserFunction.apply(alias2);
        }
        BoolQueryBuilder combined = new BoolQueryBuilder();
        for (String aliasName : aliasNames) {
            AliasMetaData alias3 = aliases.get(aliasName);
            if (alias3 == null) {
                throw new InvalidAliasNameException(index, aliasNames[0], "Unknown alias name was passed to alias Filter");
            }
            QueryBuilder parsedFilter = parserFunction.apply(alias3);
            if (parsedFilter == null) {
                return null;
            }
            combined.should(parsedFilter);
        }
        return combined;
    }

    @FunctionalInterface
    public static interface FilterParser {
        public Optional<QueryBuilder> parse(byte[] var1) throws IOException;
    }
}

