/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.decider;

import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.UnassignedInfo;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;

public class MaxRetryAllocationDecider
extends AllocationDecider {
    public static final Setting<Integer> SETTING_ALLOCATION_MAX_RETRY = Setting.intSetting("index.allocation.max_retries", 5, 0, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final String NAME = "max_retry";

    public MaxRetryAllocationDecider(Settings settings) {
        super(settings);
    }

    @Override
    public Decision canAllocate(ShardRouting shardRouting, RoutingAllocation allocation) {
        Decision decision;
        UnassignedInfo unassignedInfo = shardRouting.unassignedInfo();
        if (unassignedInfo != null && unassignedInfo.getNumFailedAllocations() > 0) {
            IndexMetaData indexMetaData = allocation.metaData().getIndexSafe(shardRouting.index());
            int maxRetry = SETTING_ALLOCATION_MAX_RETRY.get(indexMetaData.getSettings());
            decision = allocation.isRetryFailed() ? allocation.decision(Decision.YES, NAME, "shard has already failed allocating [" + unassignedInfo.getNumFailedAllocations() + "] times vs. [" + maxRetry + "] retries allowed " + unassignedInfo.toString() + " - retrying once on manual allocation", new Object[0]) : (unassignedInfo.getNumFailedAllocations() >= maxRetry ? allocation.decision(Decision.NO, NAME, "shard has already failed allocating [" + unassignedInfo.getNumFailedAllocations() + "] times vs. [" + maxRetry + "] retries allowed " + unassignedInfo.toString() + " - manually call [/_cluster/reroute?retry_failed=true] to retry", new Object[0]) : allocation.decision(Decision.YES, NAME, "shard has already failed allocating [" + unassignedInfo.getNumFailedAllocations() + "] times but [" + maxRetry + "] retries are allowed", new Object[0]));
        } else {
            decision = allocation.decision(Decision.YES, NAME, "shard has no previous failures", new Object[0]);
        }
        return decision;
    }

    @Override
    public Decision canAllocate(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        return this.canAllocate(shardRouting, allocation);
    }

    @Override
    public Decision canForceAllocatePrimary(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        assert (shardRouting.primary()) : "must not call canForceAllocatePrimary on a non-primary shard " + shardRouting;
        return this.canAllocate(shardRouting, node, allocation);
    }
}

