/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation;

import java.util.Collections;
import java.util.Map;
import org.elasticsearch.cluster.routing.allocation.NodeRebalanceResult;
import org.elasticsearch.cluster.routing.allocation.RelocationDecision;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.common.Nullable;

public final class RebalanceDecision
extends RelocationDecision {
    public static final RebalanceDecision NOT_TAKEN = new RebalanceDecision(null, null, null, null, null, Float.POSITIVE_INFINITY);
    @Nullable
    private final Decision canRebalanceDecision;
    @Nullable
    private final Map<String, NodeRebalanceResult> nodeDecisions;
    private float currentWeight;

    public RebalanceDecision(Decision canRebalanceDecision, Decision.Type finalDecision, String finalExplanation) {
        this(canRebalanceDecision, finalDecision, finalExplanation, null, null, Float.POSITIVE_INFINITY);
    }

    public RebalanceDecision(Decision canRebalanceDecision, Decision.Type finalDecision, String finalExplanation, String assignedNodeId, Map<String, NodeRebalanceResult> nodeDecisions, float currentWeight) {
        super(finalDecision, finalExplanation, assignedNodeId);
        this.canRebalanceDecision = canRebalanceDecision;
        this.nodeDecisions = nodeDecisions != null ? Collections.unmodifiableMap(nodeDecisions) : null;
        this.currentWeight = currentWeight;
    }

    public static RebalanceDecision decision(Decision canRebalanceDecision, Decision.Type finalDecision, String assignedNodeId, Map<String, NodeRebalanceResult> nodeDecisions, float currentWeight, float threshold) {
        String explanation = RebalanceDecision.produceFinalExplanation(finalDecision, assignedNodeId, threshold);
        return new RebalanceDecision(canRebalanceDecision, finalDecision, explanation, assignedNodeId, nodeDecisions, currentWeight);
    }

    @Nullable
    public Decision getCanRebalanceDecision() {
        return this.canRebalanceDecision;
    }

    @Nullable
    public Map<String, NodeRebalanceResult> getNodeDecisions() {
        return this.nodeDecisions;
    }

    private static String produceFinalExplanation(Decision.Type finalDecisionType, String assignedNodeId, float threshold) {
        String finalExplanation = assignedNodeId != null ? (finalDecisionType == Decision.Type.THROTTLE ? "throttle moving shard to node [" + assignedNodeId + "], as it is currently busy with other shard relocations" : "moving shard to node [" + assignedNodeId + "] to form a more balanced cluster") : "cannot rebalance shard, no other node exists that would form a more balanced cluster within the defined threshold [" + threshold + "]";
        return finalExplanation;
    }
}

