/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics.percentiles;

import org.elasticsearch.common.ParseField;
import org.elasticsearch.search.aggregations.metrics.percentiles.AbstractPercentilesParser;
import org.elasticsearch.search.aggregations.metrics.percentiles.PercentilesAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.percentiles.PercentilesMethod;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregationBuilder;

public class PercentilesParser
extends AbstractPercentilesParser {
    public static final ParseField PERCENTS_FIELD = new ParseField("percents", new String[0]);
    public static final double[] DEFAULT_PERCENTS = new double[]{1.0, 5.0, 25.0, 50.0, 75.0, 95.0, 99.0};

    public PercentilesParser() {
        super(true);
    }

    @Override
    protected ParseField keysField() {
        return PERCENTS_FIELD;
    }

    @Override
    protected ValuesSourceAggregationBuilder<ValuesSource.Numeric, ?> buildFactory(String aggregationName, double[] keys, PercentilesMethod method, Double compression, Integer numberOfSignificantValueDigits, Boolean keyed) {
        PercentilesAggregationBuilder factory = new PercentilesAggregationBuilder(aggregationName);
        if (keys != null) {
            factory.percentiles(keys);
        }
        if (method != null) {
            factory.method(method);
        }
        if (compression != null) {
            factory.compression(compression);
        }
        if (numberOfSignificantValueDigits != null) {
            factory.numberOfSignificantValueDigits(numberOfSignificantValueDigits);
        }
        if (keyed != null) {
            factory.keyed(keyed);
        }
        return factory;
    }
}

