/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.indices;

import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsRequest;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestActions;
import org.elasticsearch.rest.action.RestBuilderListener;

public class RestIndicesStatsAction
extends BaseRestHandler {
    private static final Set<String> RESPONSE_PARAMS = Collections.singleton("level");

    @Inject
    public RestIndicesStatsAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerHandler(RestRequest.Method.GET, "/_stats", this);
        controller.registerHandler(RestRequest.Method.GET, "/_stats/{metric}", this);
        controller.registerHandler(RestRequest.Method.GET, "/_stats/{metric}/{indexMetric}", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_stats", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_stats/{metric}", this);
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(final RestRequest request, NodeClient client) throws IOException {
        IndicesStatsRequest indicesStatsRequest = new IndicesStatsRequest();
        indicesStatsRequest.indicesOptions(IndicesOptions.fromRequest(request, indicesStatsRequest.indicesOptions()));
        indicesStatsRequest.indices(Strings.splitStringByCommaToArray(request.param("index")));
        indicesStatsRequest.types(Strings.splitStringByCommaToArray(request.param("types")));
        Set<String> metrics = Strings.splitStringByCommaToSet(request.param("metric", "_all"));
        if (metrics.size() == 1 && metrics.contains("_all")) {
            indicesStatsRequest.all();
        } else {
            indicesStatsRequest.clear();
            indicesStatsRequest.docs(metrics.contains("docs"));
            indicesStatsRequest.store(metrics.contains("store"));
            indicesStatsRequest.indexing(metrics.contains("indexing"));
            indicesStatsRequest.search(metrics.contains("search") || metrics.contains("suggest"));
            indicesStatsRequest.get(metrics.contains("get"));
            indicesStatsRequest.merge(metrics.contains("merge"));
            indicesStatsRequest.refresh(metrics.contains("refresh"));
            indicesStatsRequest.flush(metrics.contains("flush"));
            indicesStatsRequest.warmer(metrics.contains("warmer"));
            indicesStatsRequest.queryCache(metrics.contains("query_cache"));
            indicesStatsRequest.segments(metrics.contains("segments"));
            indicesStatsRequest.fieldData(metrics.contains("fielddata"));
            indicesStatsRequest.completion(metrics.contains("completion"));
            indicesStatsRequest.requestCache(metrics.contains("request_cache"));
            indicesStatsRequest.recovery(metrics.contains("recovery"));
            indicesStatsRequest.translog(metrics.contains("translog"));
        }
        if (request.hasParam("groups")) {
            indicesStatsRequest.groups(Strings.splitStringByCommaToArray(request.param("groups")));
        }
        if (request.hasParam("types")) {
            indicesStatsRequest.types(Strings.splitStringByCommaToArray(request.param("types")));
        }
        if (indicesStatsRequest.completion() && (request.hasParam("fields") || request.hasParam("completion_fields"))) {
            indicesStatsRequest.completionFields(request.paramAsStringArray("completion_fields", request.paramAsStringArray("fields", Strings.EMPTY_ARRAY)));
        }
        if (indicesStatsRequest.fieldData() && (request.hasParam("fields") || request.hasParam("fielddata_fields"))) {
            indicesStatsRequest.fieldDataFields(request.paramAsStringArray("fielddata_fields", request.paramAsStringArray("fields", Strings.EMPTY_ARRAY)));
        }
        if (indicesStatsRequest.segments() && request.hasParam("include_segment_file_sizes")) {
            indicesStatsRequest.includeSegmentFileSizes(true);
        }
        return channel -> client.admin().indices().stats(indicesStatsRequest, (ActionListener<IndicesStatsResponse>)new RestBuilderListener<IndicesStatsResponse>(channel){

            @Override
            public RestResponse buildResponse(IndicesStatsResponse response, XContentBuilder builder) throws Exception {
                builder.startObject();
                RestActions.buildBroadcastShardsHeader(builder, request, response);
                response.toXContent(builder, request);
                builder.endObject();
                return new BytesRestResponse(RestStatus.OK, builder);
            }
        });
    }

    @Override
    public boolean canTripCircuitBreaker() {
        return false;
    }

    @Override
    protected Set<String> responseParams() {
        return RESPONSE_PARAMS;
    }
}

