/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.monitor.os;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class OsStats
implements Writeable,
ToXContent {
    private final long timestamp;
    private final Cpu cpu;
    private final Mem mem;
    private final Swap swap;

    public OsStats(long timestamp, Cpu cpu, Mem mem, Swap swap) {
        this.timestamp = timestamp;
        this.cpu = Objects.requireNonNull(cpu, "cpu must not be null");
        this.mem = Objects.requireNonNull(mem, "mem must not be null");
        this.swap = Objects.requireNonNull(swap, "swap must not be null");
    }

    public OsStats(StreamInput in) throws IOException {
        this.timestamp = in.readVLong();
        this.cpu = new Cpu(in);
        this.mem = new Mem(in);
        this.swap = new Swap(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.timestamp);
        this.cpu.writeTo(out);
        this.mem.writeTo(out);
        this.swap.writeTo(out);
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public Cpu getCpu() {
        return this.cpu;
    }

    public Mem getMem() {
        return this.mem;
    }

    public Swap getSwap() {
        return this.swap;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("os");
        builder.field("timestamp", this.getTimestamp());
        this.cpu.toXContent(builder, params);
        this.mem.toXContent(builder, params);
        this.swap.toXContent(builder, params);
        builder.endObject();
        return builder;
    }

    public static short calculatePercentage(long used, long max) {
        return max <= 0L ? (short)0 : (short)Math.round(100.0 * (double)used / (double)max);
    }

    public static class Mem
    implements Writeable,
    ToXContent {
        private final long total;
        private final long free;

        public Mem(long total, long free) {
            this.total = total;
            this.free = free;
        }

        public Mem(StreamInput in) throws IOException {
            this.total = in.readLong();
            this.free = in.readLong();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeLong(this.total);
            out.writeLong(this.free);
        }

        public ByteSizeValue getTotal() {
            return new ByteSizeValue(this.total);
        }

        public ByteSizeValue getUsed() {
            return new ByteSizeValue(this.total - this.free);
        }

        public short getUsedPercent() {
            return OsStats.calculatePercentage(this.getUsed().getBytes(), this.total);
        }

        public ByteSizeValue getFree() {
            return new ByteSizeValue(this.free);
        }

        public short getFreePercent() {
            return OsStats.calculatePercentage(this.free, this.total);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject("mem");
            builder.byteSizeField("total_in_bytes", "total", this.getTotal());
            builder.byteSizeField("free_in_bytes", "free", this.getFree());
            builder.byteSizeField("used_in_bytes", "used", this.getUsed());
            builder.field("free_percent", this.getFreePercent());
            builder.field("used_percent", this.getUsedPercent());
            builder.endObject();
            return builder;
        }
    }

    public static class Swap
    implements Writeable,
    ToXContent {
        private final long total;
        private final long free;

        public Swap(long total, long free) {
            this.total = total;
            this.free = free;
        }

        public Swap(StreamInput in) throws IOException {
            this.total = in.readLong();
            this.free = in.readLong();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeLong(this.total);
            out.writeLong(this.free);
        }

        public ByteSizeValue getFree() {
            return new ByteSizeValue(this.free);
        }

        public ByteSizeValue getUsed() {
            return new ByteSizeValue(this.total - this.free);
        }

        public ByteSizeValue getTotal() {
            return new ByteSizeValue(this.total);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject("swap");
            builder.byteSizeField("total_in_bytes", "total", this.getTotal());
            builder.byteSizeField("free_in_bytes", "free", this.getFree());
            builder.byteSizeField("used_in_bytes", "used", this.getUsed());
            builder.endObject();
            return builder;
        }
    }

    public static class Cpu
    implements Writeable,
    ToXContent {
        private final short percent;
        private final double[] loadAverage;

        public Cpu(short systemCpuPercent, double[] systemLoadAverage) {
            this.percent = systemCpuPercent;
            this.loadAverage = systemLoadAverage;
        }

        public Cpu(StreamInput in) throws IOException {
            this.percent = in.readShort();
            this.loadAverage = (double[])(in.readBoolean() ? in.readDoubleArray() : null);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeShort(this.percent);
            if (this.loadAverage == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                out.writeDoubleArray(this.loadAverage);
            }
        }

        public short getPercent() {
            return this.percent;
        }

        public double[] getLoadAverage() {
            return this.loadAverage;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject("cpu");
            builder.field("percent", this.getPercent());
            if (this.getLoadAverage() != null && Arrays.stream(this.getLoadAverage()).anyMatch(load -> load != -1.0)) {
                builder.startObject("load_average");
                if (this.getLoadAverage()[0] != -1.0) {
                    builder.field("1m", this.getLoadAverage()[0]);
                }
                if (this.getLoadAverage()[1] != -1.0) {
                    builder.field("5m", this.getLoadAverage()[1]);
                }
                if (this.getLoadAverage()[2] != -1.0) {
                    builder.field("15m", this.getLoadAverage()[2]);
                }
                builder.endObject();
            }
            builder.endObject();
            return builder;
        }
    }

    static final class Fields {
        static final String OS = "os";
        static final String TIMESTAMP = "timestamp";
        static final String CPU = "cpu";
        static final String PERCENT = "percent";
        static final String LOAD_AVERAGE = "load_average";
        static final String LOAD_AVERAGE_1M = "1m";
        static final String LOAD_AVERAGE_5M = "5m";
        static final String LOAD_AVERAGE_15M = "15m";
        static final String MEM = "mem";
        static final String SWAP = "swap";
        static final String FREE = "free";
        static final String FREE_IN_BYTES = "free_in_bytes";
        static final String USED = "used";
        static final String USED_IN_BYTES = "used_in_bytes";
        static final String TOTAL = "total";
        static final String TOTAL_IN_BYTES = "total_in_bytes";
        static final String FREE_PERCENT = "free_percent";
        static final String USED_PERCENT = "used_percent";

        Fields() {
        }
    }
}

