/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.LongSupplier;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.queryparser.classic.MapperQueryParser;
import org.apache.lucene.queryparser.classic.QueryParserSettings;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.join.BitSetProducer;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.Version;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AnalysisService;
import org.elasticsearch.index.cache.bitset.BitsetFilterCache;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexFieldDataService;
import org.elasticsearch.index.mapper.ContentPath;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.ObjectMapper;
import org.elasticsearch.index.mapper.TextFieldMapper;
import org.elasticsearch.index.query.ParsedQuery;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.QueryShardException;
import org.elasticsearch.index.query.support.NestedScope;
import org.elasticsearch.index.similarity.SimilarityService;
import org.elasticsearch.indices.query.IndicesQueriesRegistry;
import org.elasticsearch.script.CompiledScript;
import org.elasticsearch.script.ExecutableScript;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.script.SearchScript;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.lookup.SearchLookup;

public class QueryShardContext
extends QueryRewriteContext {
    private final MapperService mapperService;
    private final SimilarityService similarityService;
    private final BitsetFilterCache bitsetFilterCache;
    private final IndexFieldDataService indexFieldDataService;
    private final IndexSettings indexSettings;
    private String[] types = Strings.EMPTY_ARRAY;
    private boolean cachable = true;
    private final SetOnce<Boolean> frozen = new SetOnce();
    private final Map<String, Query> namedQueries = new HashMap<String, Query>();
    private final MapperQueryParser queryParser = new MapperQueryParser(this);
    private final IndicesQueriesRegistry indicesQueriesRegistry;
    private boolean allowUnmappedFields;
    private boolean mapUnmappedFieldAsString;
    private NestedScope nestedScope;
    private boolean isFilter;
    private final LongSupplier nowInMillis;
    private SearchLookup lookup = null;

    public void setTypes(String ... types) {
        this.types = types;
    }

    public String[] getTypes() {
        return this.types;
    }

    public QueryShardContext(IndexSettings indexSettings, BitsetFilterCache bitsetFilterCache, IndexFieldDataService indexFieldDataService, MapperService mapperService, SimilarityService similarityService, ScriptService scriptService, IndicesQueriesRegistry indicesQueriesRegistry, Client client, IndexReader reader, ClusterState clusterState, LongSupplier nowInMillis) {
        super(indexSettings, mapperService, scriptService, indicesQueriesRegistry, client, reader, clusterState);
        this.indexSettings = indexSettings;
        this.similarityService = similarityService;
        this.mapperService = mapperService;
        this.bitsetFilterCache = bitsetFilterCache;
        this.indexFieldDataService = indexFieldDataService;
        this.allowUnmappedFields = indexSettings.isDefaultAllowUnmappedFields();
        this.indicesQueriesRegistry = indicesQueriesRegistry;
        this.nestedScope = new NestedScope();
        this.nowInMillis = nowInMillis;
    }

    public QueryShardContext(QueryShardContext source) {
        this(source.indexSettings, source.bitsetFilterCache, source.indexFieldDataService, source.mapperService, source.similarityService, source.scriptService, source.indicesQueriesRegistry, source.client, source.reader, source.clusterState, source.nowInMillis);
        this.types = source.getTypes();
    }

    private void reset() {
        this.allowUnmappedFields = this.indexSettings.isDefaultAllowUnmappedFields();
        this.lookup = null;
        this.namedQueries.clear();
        this.nestedScope = new NestedScope();
        this.isFilter = false;
    }

    public AnalysisService getAnalysisService() {
        return this.mapperService.analysisService();
    }

    public Similarity getSearchSimilarity() {
        return this.similarityService != null ? this.similarityService.similarity(this.mapperService) : null;
    }

    public String defaultField() {
        return this.indexSettings.getDefaultField();
    }

    public boolean queryStringLenient() {
        return this.indexSettings.isQueryStringLenient();
    }

    public boolean queryStringAnalyzeWildcard() {
        return this.indexSettings.isQueryStringAnalyzeWildcard();
    }

    public boolean queryStringAllowLeadingWildcard() {
        return this.indexSettings.isQueryStringAllowLeadingWildcard();
    }

    public MapperQueryParser queryParser(QueryParserSettings settings) {
        this.queryParser.reset(settings);
        return this.queryParser;
    }

    public BitSetProducer bitsetFilter(Query filter) {
        return this.bitsetFilterCache.getBitSetProducer(filter);
    }

    public <IFD extends IndexFieldData<?>> IFD getForField(MappedFieldType mapper) {
        return this.indexFieldDataService.getForField(mapper);
    }

    public void addNamedQuery(String name, Query query) {
        if (query != null) {
            this.namedQueries.put(name, query);
        }
    }

    public Map<String, Query> copyNamedQueries() {
        return Collections.unmodifiableMap(new HashMap<String, Query>(this.namedQueries));
    }

    public boolean isFilter() {
        return this.isFilter;
    }

    public void setIsFilter(boolean isFilter) {
        this.isFilter = isFilter;
    }

    public Collection<String> simpleMatchToIndexNames(String pattern) {
        return this.mapperService.simpleMatchToIndexNames(pattern);
    }

    public MappedFieldType fieldMapper(String name) {
        return this.failIfFieldMappingNotFound(name, this.mapperService.fullName(name));
    }

    public ObjectMapper getObjectMapper(String name) {
        return this.mapperService.getObjectMapper(name);
    }

    public Analyzer getSearchAnalyzer(MappedFieldType fieldType) {
        if (fieldType.searchAnalyzer() != null) {
            return fieldType.searchAnalyzer();
        }
        return this.getMapperService().searchAnalyzer();
    }

    public Analyzer getSearchQuoteAnalyzer(MappedFieldType fieldType) {
        if (fieldType.searchQuoteAnalyzer() != null) {
            return fieldType.searchQuoteAnalyzer();
        }
        return this.getMapperService().searchQuoteAnalyzer();
    }

    public void setAllowUnmappedFields(boolean allowUnmappedFields) {
        this.allowUnmappedFields = allowUnmappedFields;
    }

    public void setMapUnmappedFieldAsString(boolean mapUnmappedFieldAsString) {
        this.mapUnmappedFieldAsString = mapUnmappedFieldAsString;
    }

    MappedFieldType failIfFieldMappingNotFound(String name, MappedFieldType fieldMapping) {
        if (fieldMapping != null || this.allowUnmappedFields) {
            return fieldMapping;
        }
        if (this.mapUnmappedFieldAsString) {
            TextFieldMapper.Builder builder = new TextFieldMapper.Builder(name);
            return builder.build(new Mapper.BuilderContext(this.indexSettings.getSettings(), new ContentPath(1))).fieldType();
        }
        throw new QueryShardException(this, "No field mapping can be found for the field with name [{}]", name);
    }

    public Collection<String> queryTypes() {
        String[] types = this.getTypes();
        if (types == null || types.length == 0) {
            return this.getMapperService().types();
        }
        if (types.length == 1 && types[0].equals("_all")) {
            return this.getMapperService().types();
        }
        return Arrays.asList(types);
    }

    public SearchLookup lookup() {
        SearchContext current = SearchContext.current();
        if (current != null) {
            return current.lookup();
        }
        if (this.lookup == null) {
            this.lookup = new SearchLookup(this.getMapperService(), this.indexFieldDataService, null);
        }
        return this.lookup;
    }

    public long nowInMillis() {
        this.failIfFrozen();
        return this.nowInMillis.getAsLong();
    }

    public NestedScope nestedScope() {
        return this.nestedScope;
    }

    public Version indexVersionCreated() {
        return this.indexSettings.getIndexVersionCreated();
    }

    public boolean matchesIndices(String ... indices) {
        for (String index : indices) {
            if (!this.indexSettings.matchesIndexName(index)) continue;
            return true;
        }
        return false;
    }

    public ParsedQuery toFilter(QueryBuilder queryBuilder) {
        return this.toQuery(queryBuilder, q -> {
            Query filter = q.toFilter(this);
            if (filter == null) {
                return null;
            }
            return filter;
        });
    }

    public ParsedQuery toQuery(QueryBuilder queryBuilder) {
        return this.toQuery(queryBuilder, q -> {
            Query query = q.toQuery(this);
            if (query == null) {
                query = Queries.newMatchNoDocsQuery("No query left after rewrite.");
            }
            return query;
        });
    }

    private ParsedQuery toQuery(QueryBuilder queryBuilder, CheckedFunction<QueryBuilder, Query> filterOrQuery) {
        this.reset();
        try {
            QueryBuilder rewriteQuery = QueryBuilder.rewriteQuery(queryBuilder, this);
            ParsedQuery parsedQuery = new ParsedQuery(filterOrQuery.apply(rewriteQuery), this.copyNamedQueries());
            return parsedQuery;
        }
        catch (ParsingException | QueryShardException e) {
            throw e;
        }
        catch (Exception e) {
            throw new QueryShardException(this, "failed to create query: {}", e, queryBuilder);
        }
        finally {
            this.reset();
        }
    }

    public final Index index() {
        return this.indexSettings.getIndex();
    }

    public SearchScript getSearchScript(Script script, ScriptContext context, Map<String, String> params) {
        this.failIfFrozen();
        return this.scriptService.search(this.lookup(), script, context, params);
    }

    public Function<Map<String, Object>, SearchScript> getLazySearchScript(Script script, ScriptContext context, Map<String, String> params) {
        this.failIfFrozen();
        CompiledScript compile = this.scriptService.compile(script, context, params);
        return p -> this.scriptService.search(this.lookup(), compile, (Map<String, Object>)p);
    }

    public ExecutableScript getExecutableScript(Script script, ScriptContext context, Map<String, String> params) {
        this.failIfFrozen();
        return this.scriptService.executable(script, context, params);
    }

    public Function<Map<String, Object>, ExecutableScript> getLazyExecutableScript(Script script, ScriptContext context, Map<String, String> params) {
        this.failIfFrozen();
        CompiledScript executable = this.scriptService.compile(script, context, params);
        return p -> this.scriptService.executable(executable, (Map<String, Object>)p);
    }

    public void freezeContext() {
        this.frozen.set((Object)Boolean.TRUE);
    }

    protected void failIfFrozen() {
        this.cachable = false;
        if (this.frozen.get() == Boolean.TRUE) {
            throw new IllegalArgumentException("features that prevent cachability are disabled on this context");
        }
        assert (this.frozen.get() == null) : (Boolean)this.frozen.get();
    }

    @Override
    public BytesReference getTemplateBytes(Script template) {
        this.failIfFrozen();
        return super.getTemplateBytes(template);
    }

    public boolean isCachable() {
        return this.cachable;
    }

    @Override
    public Client getClient() {
        this.failIfFrozen();
        return super.getClient();
    }

    @FunctionalInterface
    private static interface CheckedFunction<T, R> {
        public R apply(T var1) throws IOException;
    }
}

