/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.cache;

import java.util.Objects;
import java.util.function.ToLongBiFunction;
import org.elasticsearch.common.cache.Cache;
import org.elasticsearch.common.cache.RemovalListener;

public class CacheBuilder<K, V> {
    private long maximumWeight = -1L;
    private long expireAfterAccess = -1L;
    private long expireAfterWrite = -1L;
    private ToLongBiFunction<K, V> weigher;
    private RemovalListener<K, V> removalListener;

    public static <K, V> CacheBuilder<K, V> builder() {
        return new CacheBuilder<K, V>();
    }

    private CacheBuilder() {
    }

    public CacheBuilder<K, V> setMaximumWeight(long maximumWeight) {
        if (maximumWeight < 0L) {
            throw new IllegalArgumentException("maximumWeight < 0");
        }
        this.maximumWeight = maximumWeight;
        return this;
    }

    public CacheBuilder<K, V> setExpireAfterAccess(long expireAfterAccess) {
        if (expireAfterAccess <= 0L) {
            throw new IllegalArgumentException("expireAfterAccess <= 0");
        }
        this.expireAfterAccess = expireAfterAccess;
        return this;
    }

    public CacheBuilder<K, V> setExpireAfterWrite(long expireAfterWrite) {
        if (expireAfterWrite <= 0L) {
            throw new IllegalArgumentException("expireAfterWrite <= 0");
        }
        this.expireAfterWrite = expireAfterWrite;
        return this;
    }

    public CacheBuilder<K, V> weigher(ToLongBiFunction<K, V> weigher) {
        Objects.requireNonNull(weigher);
        this.weigher = weigher;
        return this;
    }

    public CacheBuilder<K, V> removalListener(RemovalListener<K, V> removalListener) {
        Objects.requireNonNull(removalListener);
        this.removalListener = removalListener;
        return this;
    }

    public Cache<K, V> build() {
        Cache<K, V> cache = new Cache<K, V>();
        if (this.maximumWeight != -1L) {
            cache.setMaximumWeight(this.maximumWeight);
        }
        if (this.expireAfterAccess != -1L) {
            cache.setExpireAfterAccess(this.expireAfterAccess);
        }
        if (this.expireAfterWrite != -1L) {
            cache.setExpireAfterWrite(this.expireAfterWrite);
        }
        if (this.weigher != null) {
            cache.setWeigher(this.weigher);
        }
        if (this.removalListener != null) {
            cache.setRemovalListener(this.removalListener);
        }
        return cache;
    }
}

