/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.mapper.MapperException;
import org.elasticsearch.rest.RestStatus;

public final class MergeMappingException
extends MapperException {
    private final String[] failures;

    public MergeMappingException(String[] failures) {
        super("Merge failed with failures {" + Arrays.toString(failures) + "}");
        Objects.requireNonNull(failures, "failures must be non-null");
        this.failures = failures;
    }

    public MergeMappingException(StreamInput in) throws IOException {
        super(in);
        this.failures = in.readStringArray();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringArray(this.failures);
    }

    public String[] failures() {
        return this.failures;
    }

    @Override
    public RestStatus status() {
        return RestStatus.BAD_REQUEST;
    }
}

