/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.bulk;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionWriteResponse;
import org.elasticsearch.action.DocumentRequest;
import org.elasticsearch.action.RoutingMissingException;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.create.TransportCreateIndexAction;
import org.elasticsearch.action.bulk.BulkItemRequest;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.bulk.BulkShardRequest;
import org.elasticsearch.action.bulk.BulkShardResponse;
import org.elasticsearch.action.bulk.TransportShardBulkAction;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.TransportDeleteAction;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.AutoCreateIndex;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.update.TransportUpdateAction;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.AtomicArray;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.IndexAlreadyExistsException;
import org.elasticsearch.indices.IndexClosedException;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportBulkAction
extends HandledTransportAction<BulkRequest, BulkResponse> {
    private final AutoCreateIndex autoCreateIndex;
    private final boolean allowIdGeneration;
    private final ClusterService clusterService;
    private final TransportShardBulkAction shardBulkAction;
    private final TransportCreateIndexAction createIndexAction;

    @Inject
    public TransportBulkAction(Settings settings, ThreadPool threadPool, TransportService transportService, ClusterService clusterService, TransportShardBulkAction shardBulkAction, TransportCreateIndexAction createIndexAction, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, AutoCreateIndex autoCreateIndex) {
        super(settings, "indices:data/write/bulk", threadPool, transportService, actionFilters, indexNameExpressionResolver, BulkRequest.class);
        this.clusterService = clusterService;
        this.shardBulkAction = shardBulkAction;
        this.createIndexAction = createIndexAction;
        this.autoCreateIndex = autoCreateIndex;
        this.allowIdGeneration = this.settings.getAsBoolean("action.bulk.action.allow_id_generation", (Boolean)true);
    }

    @Override
    protected void doExecute(final BulkRequest bulkRequest, final ActionListener<BulkResponse> listener) {
        final long startTime = System.currentTimeMillis();
        final AtomicArray<BulkItemResponse> responses = new AtomicArray<BulkItemResponse>(bulkRequest.requests.size());
        if (this.autoCreateIndex.needToCheck()) {
            HashSet<String> autoCreateIndices = new HashSet<String>();
            for (ActionRequest request : bulkRequest.requests) {
                if (request instanceof DocumentRequest) {
                    DocumentRequest req = (DocumentRequest)((Object)request);
                    autoCreateIndices.add(req.index());
                    continue;
                }
                throw new ElasticsearchException("Parsed unknown request in bulk actions: " + request.getClass().getSimpleName(), new Object[0]);
            }
            final AtomicInteger counter = new AtomicInteger(autoCreateIndices.size());
            ClusterState state = this.clusterService.state();
            for (final String index : autoCreateIndices) {
                if (this.autoCreateIndex.shouldAutoCreate(index, state)) {
                    CreateIndexRequest createIndexRequest = new CreateIndexRequest(bulkRequest);
                    createIndexRequest.index(index);
                    createIndexRequest.cause("auto(bulk api)");
                    createIndexRequest.masterNodeTimeout(bulkRequest.timeout());
                    this.createIndexAction.execute(createIndexRequest, new ActionListener<CreateIndexResponse>(){

                        @Override
                        public void onResponse(CreateIndexResponse result) {
                            if (counter.decrementAndGet() == 0) {
                                try {
                                    TransportBulkAction.this.executeBulk(bulkRequest, startTime, listener, responses);
                                }
                                catch (Throwable t) {
                                    listener.onFailure(t);
                                }
                            }
                        }

                        @Override
                        public void onFailure(Throwable e) {
                            if (!(ExceptionsHelper.unwrapCause(e) instanceof IndexAlreadyExistsException)) {
                                for (int i = 0; i < bulkRequest.requests.size(); ++i) {
                                    ActionRequest request = bulkRequest.requests.get(i);
                                    if (request == null || !TransportBulkAction.this.setResponseFailureIfIndexMatches(responses, i, request, index, e)) continue;
                                    bulkRequest.requests.set(i, null);
                                }
                            }
                            if (counter.decrementAndGet() == 0) {
                                try {
                                    TransportBulkAction.this.executeBulk(bulkRequest, startTime, listener, responses);
                                }
                                catch (Throwable t) {
                                    listener.onFailure(t);
                                }
                            }
                        }
                    });
                    continue;
                }
                if (counter.decrementAndGet() != 0) continue;
                this.executeBulk(bulkRequest, startTime, listener, responses);
            }
        } else {
            this.executeBulk(bulkRequest, startTime, listener, responses);
        }
    }

    private boolean setResponseFailureIfIndexMatches(AtomicArray<BulkItemResponse> responses, int idx, ActionRequest request, String index, Throwable e) {
        if (request instanceof IndexRequest) {
            IndexRequest indexRequest = (IndexRequest)request;
            if (index.equals(indexRequest.index())) {
                responses.set(idx, new BulkItemResponse(idx, "index", new BulkItemResponse.Failure(indexRequest.index(), indexRequest.type(), indexRequest.id(), e)));
                return true;
            }
        } else if (request instanceof DeleteRequest) {
            DeleteRequest deleteRequest = (DeleteRequest)request;
            if (index.equals(deleteRequest.index())) {
                responses.set(idx, new BulkItemResponse(idx, "delete", new BulkItemResponse.Failure(deleteRequest.index(), deleteRequest.type(), deleteRequest.id(), e)));
                return true;
            }
        } else if (request instanceof UpdateRequest) {
            UpdateRequest updateRequest = (UpdateRequest)request;
            if (index.equals(updateRequest.index())) {
                responses.set(idx, new BulkItemResponse(idx, "update", new BulkItemResponse.Failure(updateRequest.index(), updateRequest.type(), updateRequest.id(), e)));
                return true;
            }
        } else {
            throw new ElasticsearchException("Parsed unknown request in bulk actions: " + request.getClass().getSimpleName(), new Object[0]);
        }
        return false;
    }

    public void executeBulk(BulkRequest bulkRequest, ActionListener<BulkResponse> listener) {
        long startTime = System.currentTimeMillis();
        this.executeBulk(bulkRequest, startTime, listener, new AtomicArray<BulkItemResponse>(bulkRequest.requests.size()));
    }

    private long buildTookInMillis(long startTime) {
        return Math.max(1L, System.currentTimeMillis() - startTime);
    }

    private void executeBulk(BulkRequest bulkRequest, final long startTime, final ActionListener<BulkResponse> listener, final AtomicArray<BulkItemResponse> responses) {
        ClusterState clusterState = this.clusterService.state();
        clusterState.blocks().globalBlockedRaiseException(ClusterBlockLevel.WRITE);
        final ConcreteIndices concreteIndices = new ConcreteIndices(clusterState, this.indexNameExpressionResolver);
        MetaData metaData = clusterState.metaData();
        for (int i = 0; i < bulkRequest.requests.size(); ++i) {
            BulkItemResponse bulkItemResponse;
            BulkItemResponse.Failure failure;
            DocumentRequest documentRequest;
            ActionRequest request = bulkRequest.requests.get(i);
            if (request == null || this.addFailureIfIndexIsUnavailable(documentRequest = (DocumentRequest)((Object)request), bulkRequest, responses, i, concreteIndices, metaData)) continue;
            String concreteIndex = concreteIndices.resolveIfAbsent(documentRequest);
            if (request instanceof IndexRequest) {
                IndexRequest indexRequest = (IndexRequest)request;
                MappingMetaData mappingMd = null;
                if (metaData.hasIndex(concreteIndex)) {
                    mappingMd = metaData.index(concreteIndex).mappingOrDefault(indexRequest.type());
                }
                try {
                    indexRequest.process(metaData, mappingMd, this.allowIdGeneration, concreteIndex);
                }
                catch (ElasticsearchParseException | RoutingMissingException e) {
                    BulkItemResponse.Failure failure2 = new BulkItemResponse.Failure(concreteIndex, indexRequest.type(), indexRequest.id(), e);
                    BulkItemResponse bulkItemResponse2 = new BulkItemResponse(i, "index", failure2);
                    responses.set(i, bulkItemResponse2);
                    bulkRequest.requests.set(i, null);
                }
                continue;
            }
            if (request instanceof DeleteRequest) {
                try {
                    TransportDeleteAction.resolveAndValidateRouting(metaData, concreteIndex, (DeleteRequest)request);
                }
                catch (RoutingMissingException e) {
                    failure = new BulkItemResponse.Failure(concreteIndex, documentRequest.type(), documentRequest.id(), e);
                    bulkItemResponse = new BulkItemResponse(i, "delete", failure);
                    responses.set(i, bulkItemResponse);
                    bulkRequest.requests.set(i, null);
                }
                continue;
            }
            if (request instanceof UpdateRequest) {
                try {
                    TransportUpdateAction.resolveAndValidateRouting(metaData, concreteIndex, (UpdateRequest)request);
                }
                catch (RoutingMissingException e) {
                    failure = new BulkItemResponse.Failure(concreteIndex, documentRequest.type(), documentRequest.id(), e);
                    bulkItemResponse = new BulkItemResponse(i, "update", failure);
                    responses.set(i, bulkItemResponse);
                    bulkRequest.requests.set(i, null);
                }
                continue;
            }
            throw new AssertionError((Object)("request type not supported: [" + request.getClass().getName() + "]"));
        }
        HashMap requestsByShard = Maps.newHashMap();
        for (int i = 0; i < bulkRequest.requests.size(); ++i) {
            List<BulkItemRequest> list;
            ShardId shardId;
            String concreteIndex;
            ActionRequest request = bulkRequest.requests.get(i);
            if (request instanceof IndexRequest) {
                IndexRequest indexRequest = (IndexRequest)request;
                concreteIndex = concreteIndices.getConcreteIndex(indexRequest.index());
                shardId = this.clusterService.operationRouting().indexShards(clusterState, concreteIndex, indexRequest.type(), indexRequest.id(), indexRequest.routing()).shardId();
                list = (ArrayList<BulkItemRequest>)requestsByShard.get(shardId);
                if (list == null) {
                    list = new ArrayList<BulkItemRequest>();
                    requestsByShard.put(shardId, list);
                }
                list.add(new BulkItemRequest(i, request));
                continue;
            }
            if (request instanceof DeleteRequest) {
                DeleteRequest deleteRequest = (DeleteRequest)request;
                concreteIndex = concreteIndices.getConcreteIndex(deleteRequest.index());
                shardId = this.clusterService.operationRouting().indexShards(clusterState, concreteIndex, deleteRequest.type(), deleteRequest.id(), deleteRequest.routing()).shardId();
                list = (List)requestsByShard.get(shardId);
                if (list == null) {
                    list = new ArrayList();
                    requestsByShard.put(shardId, list);
                }
                list.add(new BulkItemRequest(i, request));
                continue;
            }
            if (!(request instanceof UpdateRequest)) continue;
            UpdateRequest updateRequest = (UpdateRequest)request;
            concreteIndex = concreteIndices.getConcreteIndex(updateRequest.index());
            shardId = this.clusterService.operationRouting().indexShards(clusterState, concreteIndex, updateRequest.type(), updateRequest.id(), updateRequest.routing()).shardId();
            list = (List)requestsByShard.get(shardId);
            if (list == null) {
                list = new ArrayList();
                requestsByShard.put(shardId, list);
            }
            list.add(new BulkItemRequest(i, request));
        }
        if (requestsByShard.isEmpty()) {
            listener.onResponse(new BulkResponse(responses.toArray((BulkItemResponse[])new BulkItemResponse[responses.length()]), this.buildTookInMillis(startTime)));
            return;
        }
        final AtomicInteger counter = new AtomicInteger(requestsByShard.size());
        for (Map.Entry entry : requestsByShard.entrySet()) {
            ShardId shardId = (ShardId)entry.getKey();
            final List requests = (List)entry.getValue();
            BulkShardRequest bulkShardRequest = new BulkShardRequest(bulkRequest, shardId, bulkRequest.refresh(), requests.toArray(new BulkItemRequest[requests.size()]));
            bulkShardRequest.consistencyLevel(bulkRequest.consistencyLevel());
            bulkShardRequest.timeout(bulkRequest.timeout());
            this.shardBulkAction.execute(bulkShardRequest, new ActionListener<BulkShardResponse>(){

                @Override
                public void onResponse(BulkShardResponse bulkShardResponse) {
                    for (BulkItemResponse bulkItemResponse : bulkShardResponse.getResponses()) {
                        if (bulkItemResponse.getResponse() != null) {
                            ((ActionWriteResponse)bulkItemResponse.getResponse()).setShardInfo(bulkShardResponse.getShardInfo());
                        }
                        responses.set(bulkItemResponse.getItemId(), bulkItemResponse);
                    }
                    if (counter.decrementAndGet() == 0) {
                        this.finishHim();
                    }
                }

                @Override
                public void onFailure(Throwable e) {
                    for (BulkItemRequest request : requests) {
                        if (request.request() instanceof IndexRequest) {
                            IndexRequest indexRequest = (IndexRequest)request.request();
                            responses.set(request.id(), new BulkItemResponse(request.id(), indexRequest.opType().toString().toLowerCase(Locale.ENGLISH), new BulkItemResponse.Failure(concreteIndices.getConcreteIndex(indexRequest.index()), indexRequest.type(), indexRequest.id(), e)));
                            continue;
                        }
                        if (request.request() instanceof DeleteRequest) {
                            DeleteRequest deleteRequest = (DeleteRequest)request.request();
                            responses.set(request.id(), new BulkItemResponse(request.id(), "delete", new BulkItemResponse.Failure(concreteIndices.getConcreteIndex(deleteRequest.index()), deleteRequest.type(), deleteRequest.id(), e)));
                            continue;
                        }
                        if (!(request.request() instanceof UpdateRequest)) continue;
                        UpdateRequest updateRequest = (UpdateRequest)request.request();
                        responses.set(request.id(), new BulkItemResponse(request.id(), "update", new BulkItemResponse.Failure(concreteIndices.getConcreteIndex(updateRequest.index()), updateRequest.type(), updateRequest.id(), e)));
                    }
                    if (counter.decrementAndGet() == 0) {
                        this.finishHim();
                    }
                }

                private void finishHim() {
                    listener.onResponse(new BulkResponse(responses.toArray(new BulkItemResponse[responses.length()]), TransportBulkAction.this.buildTookInMillis(startTime)));
                }
            });
        }
    }

    private boolean addFailureIfIndexIsUnavailable(DocumentRequest request, BulkRequest bulkRequest, AtomicArray<BulkItemResponse> responses, int idx, ConcreteIndices concreteIndices, MetaData metaData) {
        IndexMetaData indexMetaData;
        String concreteIndex = concreteIndices.getConcreteIndex(request.index());
        ElasticsearchException unavailableException = null;
        if (concreteIndex == null) {
            try {
                concreteIndex = concreteIndices.resolveIfAbsent(request);
            }
            catch (IndexNotFoundException | IndexClosedException ex) {
                unavailableException = ex;
            }
        }
        if (unavailableException == null && (indexMetaData = metaData.index(concreteIndex)).getState() == IndexMetaData.State.CLOSE) {
            unavailableException = new IndexClosedException(new Index(metaData.index(request.index()).getIndex()));
        }
        if (unavailableException != null) {
            BulkItemResponse.Failure failure = new BulkItemResponse.Failure(request.index(), request.type(), request.id(), unavailableException);
            String operationType = "unknown";
            if (request instanceof IndexRequest) {
                operationType = "index";
            } else if (request instanceof DeleteRequest) {
                operationType = "delete";
            } else if (request instanceof UpdateRequest) {
                operationType = "update";
            }
            BulkItemResponse bulkItemResponse = new BulkItemResponse(idx, operationType, failure);
            responses.set(idx, bulkItemResponse);
            bulkRequest.requests.set(idx, null);
            return true;
        }
        return false;
    }

    private static class ConcreteIndices {
        private final ClusterState state;
        private final IndexNameExpressionResolver indexNameExpressionResolver;
        private final Map<String, String> indices = new HashMap<String, String>();

        ConcreteIndices(ClusterState state, IndexNameExpressionResolver indexNameExpressionResolver) {
            this.state = state;
            this.indexNameExpressionResolver = indexNameExpressionResolver;
        }

        String getConcreteIndex(String indexOrAlias) {
            return this.indices.get(indexOrAlias);
        }

        String resolveIfAbsent(DocumentRequest request) {
            String concreteIndex = this.indices.get(request.index());
            if (concreteIndex == null) {
                concreteIndex = this.indexNameExpressionResolver.concreteSingleIndex(this.state, request);
                this.indices.put(request.index(), concreteIndex);
            }
            return concreteIndex;
        }
    }
}

