/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.concurrent.Callable;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskManager;
import org.elasticsearch.transport.DelegatingTransportChannel;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportResponseOptions;

public class RequestHandlerRegistry<Request extends TransportRequest> {
    private final String action;
    private final TransportRequestHandler<Request> handler;
    private final boolean forceExecution;
    private final String executor;
    private final Callable<Request> requestFactory;
    private final TaskManager taskManager;

    RequestHandlerRegistry(String action, Class<Request> request, TaskManager taskManager, TransportRequestHandler<Request> handler, String executor, boolean forceExecution) {
        this(action, new ReflectionFactory<Request>(request), taskManager, handler, executor, forceExecution);
    }

    public RequestHandlerRegistry(String action, Callable<Request> requestFactory, TaskManager taskManager, TransportRequestHandler<Request> handler, String executor, boolean forceExecution) {
        this.action = action;
        this.requestFactory = requestFactory;
        assert (this.newRequest() != null);
        this.handler = handler;
        this.forceExecution = forceExecution;
        this.executor = executor;
        this.taskManager = taskManager;
    }

    public String getAction() {
        return this.action;
    }

    public Request newRequest() {
        try {
            return (Request)((TransportRequest)this.requestFactory.call());
        }
        catch (Exception e) {
            throw new IllegalStateException("failed to instantiate request ", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processMessageReceived(Request request, TransportChannel channel) throws Exception {
        Task task = this.taskManager.register(channel.getChannelType(), this.action, (TransportRequest)request);
        if (task == null) {
            this.handler.messageReceived(request, channel);
        } else {
            boolean success = false;
            try {
                this.handler.messageReceived(request, new TransportChannelWrapper(this.taskManager, task, channel), task);
                success = true;
            }
            finally {
                if (!success) {
                    this.taskManager.unregister(task);
                }
            }
        }
    }

    public boolean isForceExecution() {
        return this.forceExecution;
    }

    public String getExecutor() {
        return this.executor;
    }

    public String toString() {
        return this.handler.toString();
    }

    private static class TransportChannelWrapper
    extends DelegatingTransportChannel {
        private final Task task;
        private final TaskManager taskManager;

        public TransportChannelWrapper(TaskManager taskManager, Task task, TransportChannel channel) {
            super(channel);
            this.task = task;
            this.taskManager = taskManager;
        }

        @Override
        public void sendResponse(TransportResponse response) throws IOException {
            this.endTask();
            super.sendResponse(response);
        }

        @Override
        public void sendResponse(TransportResponse response, TransportResponseOptions options) throws IOException {
            this.endTask();
            super.sendResponse(response, options);
        }

        @Override
        public void sendResponse(Throwable error) throws IOException {
            this.endTask();
            super.sendResponse(error);
        }

        private void endTask() {
            this.taskManager.unregister(this.task);
        }
    }

    private static final class ReflectionFactory<Request>
    implements Callable<Request> {
        private final Constructor<Request> requestConstructor;

        public ReflectionFactory(Class<Request> request) {
            try {
                this.requestConstructor = request.getDeclaredConstructor(new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException("failed to create constructor (does it have a default constructor?) for request " + request, e);
            }
        }

        @Override
        public Request call() throws Exception {
            try {
                return this.requestConstructor.newInstance(new Object[0]);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Could not access '" + this.requestConstructor + "'. Implementations must be a public class and have a public no-arg ctor.", e);
            }
        }
    }
}

