/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.snapshots;

import java.io.IOException;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.cluster.metadata.SnapshotId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class SnapshotException
extends ElasticsearchException {
    private final SnapshotId snapshot;

    public SnapshotException(SnapshotId snapshot, String msg) {
        this(snapshot, msg, null);
    }

    public SnapshotException(SnapshotId snapshot, String msg, Throwable cause) {
        super("[" + (snapshot == null ? "_na" : snapshot) + "] " + msg, cause, new Object[0]);
        this.snapshot = snapshot;
    }

    public SnapshotException(StreamInput in) throws IOException {
        super(in);
        this.snapshot = in.readBoolean() ? SnapshotId.readSnapshotId(in) : null;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalStreamable(this.snapshot);
    }

    public SnapshotId snapshot() {
        return this.snapshot;
    }
}

