/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.recovery;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;

public class RecoveryStats
implements ToXContent,
Streamable {
    private final AtomicInteger currentAsSource = new AtomicInteger();
    private final AtomicInteger currentAsTarget = new AtomicInteger();
    private final AtomicLong throttleTimeInNanos = new AtomicLong();

    public void add(RecoveryStats recoveryStats) {
        if (recoveryStats != null) {
            this.currentAsSource.addAndGet(recoveryStats.currentAsSource());
            this.currentAsTarget.addAndGet(recoveryStats.currentAsTarget());
        }
        this.addTotals(recoveryStats);
    }

    public void addTotals(RecoveryStats recoveryStats) {
        if (recoveryStats != null) {
            this.throttleTimeInNanos.addAndGet(recoveryStats.throttleTime().nanos());
        }
    }

    public int currentAsSource() {
        return this.currentAsSource.get();
    }

    public int currentAsTarget() {
        return this.currentAsTarget.get();
    }

    public TimeValue throttleTime() {
        return TimeValue.timeValueNanos(this.throttleTimeInNanos.get());
    }

    public void incCurrentAsTarget() {
        this.currentAsTarget.incrementAndGet();
    }

    public void decCurrentAsTarget() {
        this.currentAsTarget.decrementAndGet();
    }

    public void incCurrentAsSource() {
        this.currentAsSource.incrementAndGet();
    }

    public void decCurrentAsSource() {
        this.currentAsSource.decrementAndGet();
    }

    public void addThrottleTime(long nanos) {
        this.throttleTimeInNanos.addAndGet(nanos);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(Fields.RECOVERY);
        builder.field(Fields.CURRENT_AS_SOURCE, this.currentAsSource());
        builder.field(Fields.CURRENT_AS_TARGET, this.currentAsTarget());
        builder.timeValueField(Fields.THROTTLE_TIME_IN_MILLIS, Fields.THROTTLE_TIME, this.throttleTime());
        builder.endObject();
        return builder;
    }

    public static RecoveryStats readRecoveryStats(StreamInput in) throws IOException {
        RecoveryStats stats = new RecoveryStats();
        stats.readFrom(in);
        return stats;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.currentAsSource.set(in.readVInt());
        this.currentAsTarget.set(in.readVInt());
        this.throttleTimeInNanos.set(in.readLong());
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.currentAsSource.get());
        out.writeVInt(this.currentAsTarget.get());
        out.writeLong(this.throttleTimeInNanos.get());
    }

    public String toString() {
        return "recoveryStats, currentAsSource [" + this.currentAsSource() + "],currentAsTarget [" + this.currentAsTarget() + "], throttle [" + this.throttleTime() + "]";
    }

    static final class Fields {
        static final XContentBuilderString RECOVERY = new XContentBuilderString("recovery");
        static final XContentBuilderString CURRENT_AS_SOURCE = new XContentBuilderString("current_as_source");
        static final XContentBuilderString CURRENT_AS_TARGET = new XContentBuilderString("current_as_target");
        static final XContentBuilderString THROTTLE_TIME = new XContentBuilderString("throttle_time");
        static final XContentBuilderString THROTTLE_TIME_IN_MILLIS = new XContentBuilderString("throttle_time_in_millis");

        Fields() {
        }
    }
}

