/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.significant.heuristics;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParseFieldMatcher;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.logging.ESLoggerFactory;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.script.ExecutableScript;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.script.ScriptParameterParser;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.bucket.significant.heuristics.SignificanceHeuristic;
import org.elasticsearch.search.aggregations.bucket.significant.heuristics.SignificanceHeuristicBuilder;
import org.elasticsearch.search.aggregations.bucket.significant.heuristics.SignificanceHeuristicParser;
import org.elasticsearch.search.aggregations.bucket.significant.heuristics.SignificanceHeuristicStreams;
import org.elasticsearch.search.internal.SearchContext;

public class ScriptHeuristic
extends SignificanceHeuristic {
    protected static final ParseField NAMES_FIELD = new ParseField("script_heuristic", new String[0]);
    private final LongAccessor subsetSizeHolder = new LongAccessor();
    private final LongAccessor supersetSizeHolder = new LongAccessor();
    private final LongAccessor subsetDfHolder = new LongAccessor();
    private final LongAccessor supersetDfHolder = new LongAccessor();
    ExecutableScript searchScript = null;
    Script script;
    public static final SignificanceHeuristicStreams.Stream STREAM = new SignificanceHeuristicStreams.Stream(){

        @Override
        public SignificanceHeuristic readResult(StreamInput in) throws IOException {
            Script script = Script.readScript(in);
            return new ScriptHeuristic(null, script);
        }

        @Override
        public String getName() {
            return NAMES_FIELD.getPreferredName();
        }
    };

    public ScriptHeuristic(ExecutableScript searchScript, Script script) {
        this.searchScript = searchScript;
        if (searchScript != null) {
            searchScript.setNextVar("_subset_freq", this.subsetDfHolder);
            searchScript.setNextVar("_subset_size", this.subsetSizeHolder);
            searchScript.setNextVar("_superset_freq", this.supersetDfHolder);
            searchScript.setNextVar("_superset_size", this.supersetSizeHolder);
        }
        this.script = script;
    }

    @Override
    public void initialize(InternalAggregation.ReduceContext context) {
        this.searchScript = context.scriptService().executable(this.script, ScriptContext.Standard.AGGS, context, Collections.emptyMap());
        this.searchScript.setNextVar("_subset_freq", this.subsetDfHolder);
        this.searchScript.setNextVar("_subset_size", this.subsetSizeHolder);
        this.searchScript.setNextVar("_superset_freq", this.supersetDfHolder);
        this.searchScript.setNextVar("_superset_size", this.supersetSizeHolder);
    }

    @Override
    public double getScore(long subsetFreq, long subsetSize, long supersetFreq, long supersetSize) {
        if (this.searchScript == null) {
            ESLoggerFactory.getLogger("script heuristic").warn("cannot compute score - script has not been initialized yet.", new Object[0]);
            return 0.0;
        }
        this.subsetSizeHolder.value = subsetSize;
        this.supersetSizeHolder.value = supersetSize;
        this.subsetDfHolder.value = subsetFreq;
        this.supersetDfHolder.value = supersetFreq;
        return ((Number)this.searchScript.run()).doubleValue();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(STREAM.getName());
        this.script.writeTo(out);
    }

    public final class LongAccessor
    extends Number {
        public long value;

        @Override
        public int intValue() {
            return (int)this.value;
        }

        @Override
        public long longValue() {
            return this.value;
        }

        @Override
        public float floatValue() {
            return this.value;
        }

        @Override
        public double doubleValue() {
            return this.value;
        }

        public String toString() {
            return Long.toString(this.value);
        }
    }

    public static class ScriptHeuristicBuilder
    implements SignificanceHeuristicBuilder {
        private Script script = null;

        public ScriptHeuristicBuilder setScript(Script script) {
            this.script = script;
            return this;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params builderParams) throws IOException {
            builder.startObject(STREAM.getName());
            builder.field(Script.ScriptField.SCRIPT.getPreferredName());
            this.script.toXContent(builder, builderParams);
            builder.endObject();
            return builder;
        }
    }

    public static class ScriptHeuristicParser
    implements SignificanceHeuristicParser {
        private final ScriptService scriptService;

        public ScriptHeuristicParser(ScriptService scriptService) {
            this.scriptService = scriptService;
        }

        @Override
        public SignificanceHeuristic parse(XContentParser parser, ParseFieldMatcher parseFieldMatcher, SearchContext context) throws IOException, QueryParsingException {
            ExecutableScript searchScript;
            XContentParser.Token token;
            String heuristicName = parser.currentName();
            Script script = null;
            Map<Object, Object> params = null;
            String currentFieldName = null;
            ScriptParameterParser scriptParameterParser = new ScriptParameterParser();
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token.equals((Object)XContentParser.Token.FIELD_NAME)) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (token == XContentParser.Token.START_OBJECT) {
                    if (parseFieldMatcher.match(currentFieldName, Script.ScriptField.SCRIPT)) {
                        script = Script.parse(parser, parseFieldMatcher);
                        continue;
                    }
                    if ("params".equals(currentFieldName)) {
                        params = parser.map();
                        continue;
                    }
                    throw new ElasticsearchParseException("failed to parse [{}] significance heuristic. unknown object [{}]", heuristicName, currentFieldName);
                }
                if (scriptParameterParser.token(currentFieldName, token, parser, parseFieldMatcher)) continue;
                throw new ElasticsearchParseException("failed to parse [{}] significance heuristic. unknown field [{}]", heuristicName, currentFieldName);
            }
            if (script == null) {
                ScriptParameterParser.ScriptParameterValue scriptValue = scriptParameterParser.getDefaultScriptParameterValue();
                if (scriptValue != null) {
                    if (params == null) {
                        params = Maps.newHashMap();
                    }
                    script = new Script(scriptValue.script(), scriptValue.scriptType(), scriptParameterParser.lang(), params);
                }
            } else if (params != null) {
                throw new ElasticsearchParseException("failed to parse [{}] significance heuristic. script params must be specified inside script object", heuristicName);
            }
            if (script == null) {
                throw new ElasticsearchParseException("failed to parse [{}] significance heuristic. no script found in script_heuristic", heuristicName);
            }
            try {
                searchScript = this.scriptService.executable(script, ScriptContext.Standard.AGGS, context, Collections.emptyMap());
            }
            catch (Exception e) {
                throw new ElasticsearchParseException("failed to parse [{}] significance heuristic. the script [{}] could not be loaded", (Throwable)e, script, heuristicName);
            }
            return new ScriptHeuristic(searchScript, script);
        }

        @Override
        public String[] getNames() {
            return NAMES_FIELD.getAllNamesIncludedDeprecated();
        }
    }
}

