/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.monitor.fs;

import java.io.IOException;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.monitor.fs.FsInfo;

public class FsProbe
extends AbstractComponent {
    private final NodeEnvironment nodeEnv;

    @Inject
    public FsProbe(Settings settings, NodeEnvironment nodeEnv) {
        super(settings);
        this.nodeEnv = nodeEnv;
    }

    public FsInfo stats() throws IOException {
        if (!this.nodeEnv.hasNodeFile()) {
            return new FsInfo(System.currentTimeMillis(), new FsInfo.Path[0]);
        }
        NodeEnvironment.NodePath[] dataLocations = this.nodeEnv.nodePaths();
        FsInfo.Path[] paths = new FsInfo.Path[dataLocations.length];
        for (int i = 0; i < dataLocations.length; ++i) {
            paths[i] = FsProbe.getFSInfo(dataLocations[i]);
        }
        return new FsInfo(System.currentTimeMillis(), paths);
    }

    public static FsInfo.Path getFSInfo(NodeEnvironment.NodePath nodePath) throws IOException {
        FsInfo.Path fsPath = new FsInfo.Path();
        fsPath.path = nodePath.path.toAbsolutePath().toString();
        fsPath.total = nodePath.fileStore.getTotalSpace();
        fsPath.free = nodePath.fileStore.getUnallocatedSpace();
        fsPath.available = nodePath.fileStore.getUsableSpace();
        fsPath.type = nodePath.fileStore.type();
        fsPath.mount = nodePath.fileStore.toString();
        fsPath.spins = nodePath.spins;
        return fsPath;
    }
}

