/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.bootstrap;

import java.nio.file.Path;
import org.elasticsearch.bootstrap.ConsoleCtrlHandler;
import org.elasticsearch.bootstrap.JNANatives;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;

final class Natives {
    private static final ESLogger logger = Loggers.getLogger(Natives.class);
    static final boolean JNA_AVAILABLE;

    private Natives() {
    }

    static void tryMlockall() {
        if (!JNA_AVAILABLE) {
            logger.warn("cannot mlockall because JNA is not available", new Object[0]);
            return;
        }
        JNANatives.tryMlockall();
    }

    static boolean definitelyRunningAsRoot() {
        if (!JNA_AVAILABLE) {
            logger.warn("cannot check if running as root because JNA is not available", new Object[0]);
            return false;
        }
        return JNANatives.definitelyRunningAsRoot();
    }

    static void tryVirtualLock() {
        if (!JNA_AVAILABLE) {
            logger.warn("cannot mlockall because JNA is not available", new Object[0]);
            return;
        }
        JNANatives.tryVirtualLock();
    }

    static void addConsoleCtrlHandler(ConsoleCtrlHandler handler) {
        if (!JNA_AVAILABLE) {
            logger.warn("cannot register console handler because JNA is not available", new Object[0]);
            return;
        }
        JNANatives.addConsoleCtrlHandler(handler);
    }

    static boolean isMemoryLocked() {
        if (!JNA_AVAILABLE) {
            return false;
        }
        return JNANatives.LOCAL_MLOCKALL;
    }

    static void trySeccomp(Path tmpFile) {
        if (!JNA_AVAILABLE) {
            logger.warn("cannot install syscall filters because JNA is not available", new Object[0]);
            return;
        }
        JNANatives.trySeccomp(tmpFile);
    }

    static boolean isSeccompInstalled() {
        if (!JNA_AVAILABLE) {
            return false;
        }
        return JNANatives.LOCAL_SECCOMP;
    }

    static {
        boolean v = false;
        try {
            Class.forName("com.sun.jna.Native");
            v = true;
        }
        catch (ClassNotFoundException e) {
            logger.warn("JNA not found. native methods will be disabled.", e, new Object[0]);
        }
        catch (UnsatisfiedLinkError e) {
            logger.warn("unable to load JNA native support library, native methods will be disabled.", e, new Object[0]);
        }
        JNA_AVAILABLE = v;
    }
}

