/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.recovery;

import java.io.IOException;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.indices.recovery.RecoveryState;
import org.elasticsearch.transport.TransportRequest;

public class StartRecoveryRequest
extends TransportRequest {
    private long recoveryId;
    private ShardId shardId;
    private DiscoveryNode sourceNode;
    private DiscoveryNode targetNode;
    private boolean markAsRelocated;
    private Store.MetadataSnapshot metadataSnapshot;
    private RecoveryState.Type recoveryType;

    StartRecoveryRequest() {
    }

    public StartRecoveryRequest(ShardId shardId, DiscoveryNode sourceNode, DiscoveryNode targetNode, boolean markAsRelocated, Store.MetadataSnapshot metadataSnapshot, RecoveryState.Type recoveryType, long recoveryId) {
        this.recoveryId = recoveryId;
        this.shardId = shardId;
        this.sourceNode = sourceNode;
        this.targetNode = targetNode;
        this.markAsRelocated = markAsRelocated;
        this.recoveryType = recoveryType;
        this.metadataSnapshot = metadataSnapshot;
    }

    public long recoveryId() {
        return this.recoveryId;
    }

    public ShardId shardId() {
        return this.shardId;
    }

    public DiscoveryNode sourceNode() {
        return this.sourceNode;
    }

    public DiscoveryNode targetNode() {
        return this.targetNode;
    }

    public boolean markAsRelocated() {
        return this.markAsRelocated;
    }

    public RecoveryState.Type recoveryType() {
        return this.recoveryType;
    }

    public Store.MetadataSnapshot metadataSnapshot() {
        return this.metadataSnapshot;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.recoveryId = in.readLong();
        this.shardId = ShardId.readShardId(in);
        this.sourceNode = DiscoveryNode.readNode(in);
        this.targetNode = DiscoveryNode.readNode(in);
        this.markAsRelocated = in.readBoolean();
        this.metadataSnapshot = new Store.MetadataSnapshot(in);
        if (in.getVersion().onOrAfter(Version.V_1_2_2)) {
            this.recoveryType = RecoveryState.Type.fromId(in.readByte());
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeLong(this.recoveryId);
        this.shardId.writeTo(out);
        this.sourceNode.writeTo(out);
        this.targetNode.writeTo(out);
        out.writeBoolean(this.markAsRelocated);
        this.metadataSnapshot.writeTo(out);
        if (out.getVersion().onOrAfter(Version.V_1_2_2)) {
            out.writeByte(this.recoveryType.id());
        }
    }
}

