/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import java.util.Collection;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.DelegatingAnalyzerWrapper;
import org.elasticsearch.common.collect.CopyOnWriteHashMap;

public final class FieldNameAnalyzer
extends DelegatingAnalyzerWrapper {
    private final CopyOnWriteHashMap<String, Analyzer> analyzers;
    private final Analyzer defaultAnalyzer;

    public FieldNameAnalyzer(Analyzer defaultAnalyzer) {
        this(new CopyOnWriteHashMap<String, Analyzer>(), defaultAnalyzer);
    }

    public FieldNameAnalyzer(Map<String, Analyzer> analyzers, Analyzer defaultAnalyzer) {
        super(Analyzer.PER_FIELD_REUSE_STRATEGY);
        this.analyzers = CopyOnWriteHashMap.copyOf(analyzers);
        this.defaultAnalyzer = defaultAnalyzer;
    }

    public Map<String, Analyzer> analyzers() {
        return this.analyzers;
    }

    public Analyzer defaultAnalyzer() {
        return this.defaultAnalyzer;
    }

    protected Analyzer getWrappedAnalyzer(String fieldName) {
        return this.getAnalyzer(fieldName);
    }

    private Analyzer getAnalyzer(String name) {
        Analyzer analyzer = this.analyzers.get(name);
        if (analyzer != null) {
            return analyzer;
        }
        return this.defaultAnalyzer;
    }

    public FieldNameAnalyzer copyAndAddAll(Collection<? extends Map.Entry<String, Analyzer>> mappers) {
        CopyOnWriteHashMap<String, Analyzer> analyzers = this.analyzers;
        for (Map.Entry<String, Analyzer> entry : mappers) {
            if (entry.getValue() == null) continue;
            analyzers = analyzers.copyAndPut(entry.getKey(), entry.getValue());
        }
        return new FieldNameAnalyzer(analyzers, this.defaultAnalyzer);
    }
}

