/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.settings;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.Version;
import org.elasticsearch.common.Booleans;
import org.elasticsearch.common.Classes;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.base.Charsets;
import org.elasticsearch.common.base.Predicate;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.Iterables;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.io.Streams;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.property.PropertyPlaceholder;
import org.elasticsearch.common.settings.NoClassSettingsException;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsException;
import org.elasticsearch.common.settings.loader.SettingsLoader;
import org.elasticsearch.common.settings.loader.SettingsLoaderFactory;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.MemorySizeValue;
import org.elasticsearch.common.unit.RatioValue;
import org.elasticsearch.common.unit.SizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class ImmutableSettings
implements Settings {
    public static final Settings EMPTY = new Builder().build();
    public static final String FLAT_SETTINGS_KEY = "flat_settings";
    private static final Pattern ARRAY_PATTERN = Pattern.compile("(.*)\\.\\d+$");
    private ImmutableMap<String, String> settings;
    private final ImmutableMap<String, String> forcedUnderscoreSettings;
    private transient ClassLoader classLoader;

    ImmutableSettings(Map<String, String> settings, ClassLoader classLoader) {
        this.settings = ImmutableMap.copyOf(settings);
        HashMap<String, String> forcedUnderscoreSettings = null;
        for (Map.Entry<String, String> entry : settings.entrySet()) {
            String toUnderscoreCase = Strings.toUnderscoreCase(entry.getKey());
            if (toUnderscoreCase.equals(entry.getKey())) continue;
            if (forcedUnderscoreSettings == null) {
                forcedUnderscoreSettings = new HashMap<String, String>();
            }
            forcedUnderscoreSettings.put(toUnderscoreCase, entry.getValue());
        }
        this.forcedUnderscoreSettings = forcedUnderscoreSettings == null ? ImmutableMap.of() : ImmutableMap.copyOf(forcedUnderscoreSettings);
        this.classLoader = classLoader;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader == null ? Classes.getDefaultClassLoader() : this.classLoader;
    }

    @Override
    public ClassLoader getClassLoaderIfSet() {
        return this.classLoader;
    }

    @Override
    public ImmutableMap<String, String> getAsMap() {
        return this.settings;
    }

    @Override
    public Map<String, Object> getAsStructuredMap() {
        HashMap<String, Object> map = Maps.newHashMapWithExpectedSize(2);
        for (Map.Entry entry : this.settings.entrySet()) {
            this.processSetting(map, "", (String)entry.getKey(), (String)entry.getValue());
        }
        for (Map.Entry entry : map.entrySet()) {
            if (!(entry.getValue() instanceof Map)) continue;
            Map valMap = (Map)entry.getValue();
            entry.setValue(this.convertMapsToArrays(valMap));
        }
        return map;
    }

    private void processSetting(Map<String, Object> map, String prefix, String setting, String value) {
        int prefixLength = setting.indexOf(46);
        if (prefixLength == -1) {
            Map innerMap = (Map)map.get(prefix + setting);
            if (innerMap != null) {
                for (Map.Entry entry : innerMap.entrySet()) {
                    map.put(prefix + setting + "." + (String)entry.getKey(), entry.getValue());
                }
            }
            map.put(prefix + setting, value);
        } else {
            String key = setting.substring(0, prefixLength);
            String rest = setting.substring(prefixLength + 1);
            Object existingValue = map.get(prefix + key);
            if (existingValue == null) {
                HashMap<String, Object> newMap = Maps.newHashMapWithExpectedSize(2);
                this.processSetting(newMap, "", rest, value);
                map.put(key, newMap);
            } else if (existingValue instanceof Map) {
                Map innerMap = (Map)existingValue;
                this.processSetting(innerMap, "", rest, value);
                map.put(key, innerMap);
            } else {
                this.processSetting(map, prefix + key + ".", rest, value);
            }
        }
    }

    private Object convertMapsToArrays(Map<String, Object> map) {
        if (map.isEmpty()) {
            return map;
        }
        boolean isArray = true;
        int maxIndex = -1;
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (isArray) {
                try {
                    int index = Integer.parseInt(entry.getKey());
                    if (index >= 0) {
                        maxIndex = Math.max(maxIndex, index);
                    } else {
                        isArray = false;
                    }
                }
                catch (NumberFormatException ex) {
                    isArray = false;
                }
            }
            if (!(entry.getValue() instanceof Map)) continue;
            Map valMap = (Map)entry.getValue();
            entry.setValue(this.convertMapsToArrays(valMap));
        }
        if (isArray && maxIndex + 1 == map.size()) {
            ArrayList<Object> newValue = Lists.newArrayListWithExpectedSize(maxIndex + 1);
            for (int i = 0; i <= maxIndex; ++i) {
                Object obj = map.get(Integer.toString(i));
                if (obj == null) {
                    return map;
                }
                newValue.add(obj);
            }
            return newValue;
        }
        return map;
    }

    @Override
    public Settings getComponentSettings(Class component) {
        if (component.getName().startsWith("org.elasticsearch")) {
            return this.getComponentSettings("org.elasticsearch", component);
        }
        return this.getComponentSettings(component.getName().substring(0, component.getName().indexOf(46)), component);
    }

    @Override
    public Settings getComponentSettings(String prefix, Class component) {
        String type = component.getName();
        if (!type.startsWith(prefix)) {
            throw new SettingsException("Component [" + type + "] does not start with prefix [" + prefix + "]");
        }
        String settingPrefix = type.substring(prefix.length() + 1);
        settingPrefix = settingPrefix.substring(0, settingPrefix.length() - component.getSimpleName().length());
        return this.getByPrefix(settingPrefix);
    }

    @Override
    public Settings getByPrefix(String prefix) {
        Builder builder = new Builder();
        for (Map.Entry entry : this.getAsMap().entrySet()) {
            if (!((String)entry.getKey()).startsWith(prefix) || ((String)entry.getKey()).length() < prefix.length()) continue;
            builder.put(((String)entry.getKey()).substring(prefix.length()), (String)entry.getValue());
        }
        builder.classLoader(this.classLoader);
        return builder.build();
    }

    @Override
    public Settings getAsSettings(String setting) {
        return this.getByPrefix(setting + ".");
    }

    @Override
    public String get(String setting) {
        String retVal = this.settings.get(setting);
        if (retVal != null) {
            return retVal;
        }
        return this.forcedUnderscoreSettings.get(setting);
    }

    @Override
    public String get(String[] settings) {
        for (String setting : settings) {
            String retVal = this.get(setting);
            if (retVal == null) continue;
            return retVal;
        }
        return null;
    }

    @Override
    public String get(String setting, String defaultValue) {
        String retVal = this.get(setting);
        return retVal == null ? defaultValue : retVal;
    }

    @Override
    public String get(String[] settings, String defaultValue) {
        String retVal = this.get(settings);
        return retVal == null ? defaultValue : retVal;
    }

    @Override
    public Float getAsFloat(String setting, Float defaultValue) {
        String sValue = this.get(setting);
        if (sValue == null) {
            return defaultValue;
        }
        try {
            return Float.valueOf(Float.parseFloat(sValue));
        }
        catch (NumberFormatException e) {
            throw new SettingsException("Failed to parse float setting [" + setting + "] with value [" + sValue + "]", e);
        }
    }

    @Override
    public Float getAsFloat(String[] settings, Float defaultValue) throws SettingsException {
        String sValue = this.get(settings);
        if (sValue == null) {
            return defaultValue;
        }
        try {
            return Float.valueOf(Float.parseFloat(sValue));
        }
        catch (NumberFormatException e) {
            throw new SettingsException("Failed to parse float setting [" + Arrays.toString(settings) + "] with value [" + sValue + "]", e);
        }
    }

    @Override
    public Double getAsDouble(String setting, Double defaultValue) {
        String sValue = this.get(setting);
        if (sValue == null) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(sValue);
        }
        catch (NumberFormatException e) {
            throw new SettingsException("Failed to parse double setting [" + setting + "] with value [" + sValue + "]", e);
        }
    }

    @Override
    public Double getAsDouble(String[] settings, Double defaultValue) {
        String sValue = this.get(settings);
        if (sValue == null) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(sValue);
        }
        catch (NumberFormatException e) {
            throw new SettingsException("Failed to parse double setting [" + Arrays.toString(settings) + "] with value [" + sValue + "]", e);
        }
    }

    @Override
    public Integer getAsInt(String setting, Integer defaultValue) {
        String sValue = this.get(setting);
        if (sValue == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(sValue);
        }
        catch (NumberFormatException e) {
            throw new SettingsException("Failed to parse int setting [" + setting + "] with value [" + sValue + "]", e);
        }
    }

    @Override
    public Integer getAsInt(String[] settings, Integer defaultValue) {
        String sValue = this.get(settings);
        if (sValue == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(sValue);
        }
        catch (NumberFormatException e) {
            throw new SettingsException("Failed to parse int setting [" + Arrays.toString(settings) + "] with value [" + sValue + "]", e);
        }
    }

    @Override
    public Long getAsLong(String setting, Long defaultValue) {
        String sValue = this.get(setting);
        if (sValue == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(sValue);
        }
        catch (NumberFormatException e) {
            throw new SettingsException("Failed to parse long setting [" + setting + "] with value [" + sValue + "]", e);
        }
    }

    @Override
    public Long getAsLong(String[] settings, Long defaultValue) {
        String sValue = this.get(settings);
        if (sValue == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(sValue);
        }
        catch (NumberFormatException e) {
            throw new SettingsException("Failed to parse long setting [" + Arrays.toString(settings) + "] with value [" + sValue + "]", e);
        }
    }

    @Override
    public Boolean getAsBoolean(String setting, Boolean defaultValue) {
        return Booleans.parseBoolean(this.get(setting), defaultValue);
    }

    @Override
    public Boolean getAsBoolean(String[] settings, Boolean defaultValue) {
        return Booleans.parseBoolean(this.get(settings), defaultValue);
    }

    @Override
    public TimeValue getAsTime(String setting, TimeValue defaultValue) {
        return TimeValue.parseTimeValue(this.get(setting), defaultValue);
    }

    @Override
    public TimeValue getAsTime(String[] settings, TimeValue defaultValue) {
        return TimeValue.parseTimeValue(this.get(settings), defaultValue);
    }

    @Override
    public ByteSizeValue getAsBytesSize(String setting, ByteSizeValue defaultValue) throws SettingsException {
        return ByteSizeValue.parseBytesSizeValue(this.get(setting), defaultValue);
    }

    @Override
    public ByteSizeValue getAsBytesSize(String[] settings, ByteSizeValue defaultValue) throws SettingsException {
        return ByteSizeValue.parseBytesSizeValue(this.get(settings), defaultValue);
    }

    @Override
    public ByteSizeValue getAsMemory(String setting, String defaultValue) throws SettingsException {
        return MemorySizeValue.parseBytesSizeValueOrHeapRatio(this.get(setting, defaultValue));
    }

    @Override
    public ByteSizeValue getAsMemory(String[] settings, String defaultValue) throws SettingsException {
        return MemorySizeValue.parseBytesSizeValueOrHeapRatio(this.get(settings, defaultValue));
    }

    @Override
    public RatioValue getAsRatio(String setting, String defaultValue) throws SettingsException {
        return RatioValue.parseRatioValue(this.get(setting, defaultValue));
    }

    @Override
    public RatioValue getAsRatio(String[] settings, String defaultValue) throws SettingsException {
        return RatioValue.parseRatioValue(this.get(settings, defaultValue));
    }

    @Override
    public SizeValue getAsSize(String setting, SizeValue defaultValue) throws SettingsException {
        return SizeValue.parseSizeValue(this.get(setting), defaultValue);
    }

    @Override
    public SizeValue getAsSize(String[] settings, SizeValue defaultValue) throws SettingsException {
        return SizeValue.parseSizeValue(this.get(settings), defaultValue);
    }

    @Override
    public <T> Class<? extends T> getAsClass(String setting, Class<? extends T> defaultClazz) throws NoClassSettingsException {
        String sValue = this.get(setting);
        if (sValue == null) {
            return defaultClazz;
        }
        try {
            return this.getClassLoader().loadClass(sValue);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassSettingsException("Failed to load class setting [" + setting + "] with value [" + sValue + "]", e);
        }
    }

    @Override
    public <T> Class<? extends T> getAsClass(String setting, Class<? extends T> defaultClazz, String prefixPackage, String suffixClassName) throws NoClassSettingsException {
        String sValue = this.get(setting);
        if (sValue == null) {
            return defaultClazz;
        }
        String fullClassName = sValue;
        try {
            return this.getClassLoader().loadClass(fullClassName);
        }
        catch (ClassNotFoundException e) {
            String prefixValue = prefixPackage;
            int packageSeparator = sValue.lastIndexOf(46);
            if (packageSeparator > 0) {
                prefixValue = sValue.substring(0, packageSeparator + 1);
                sValue = sValue.substring(packageSeparator + 1);
            }
            fullClassName = prefixValue + Strings.capitalize(Strings.toCamelCase(sValue)) + suffixClassName;
            try {
                return this.getClassLoader().loadClass(fullClassName);
            }
            catch (ClassNotFoundException e1) {
                return this.loadClass(prefixValue, sValue, suffixClassName, setting);
            }
            catch (NoClassDefFoundError e1) {
                return this.loadClass(prefixValue, sValue, suffixClassName, setting);
            }
        }
    }

    private <T> Class<? extends T> loadClass(String prefixValue, String sValue, String suffixClassName, String setting) {
        String fullClassName = prefixValue + Strings.toCamelCase(sValue).toLowerCase(Locale.ROOT) + "." + Strings.capitalize(Strings.toCamelCase(sValue)) + suffixClassName;
        try {
            return this.getClassLoader().loadClass(fullClassName);
        }
        catch (ClassNotFoundException e2) {
            throw new NoClassSettingsException("Failed to load class setting [" + setting + "] with value [" + this.get(setting) + "]", e2);
        }
    }

    @Override
    public String[] getAsArray(String settingPrefix) throws SettingsException {
        return this.getAsArray(settingPrefix, Strings.EMPTY_ARRAY, true);
    }

    @Override
    public String[] getAsArray(String settingPrefix, String[] defaultArray) throws SettingsException {
        return this.getAsArray(settingPrefix, defaultArray, true);
    }

    @Override
    public String[] getAsArray(String settingPrefix, String[] defaultArray, Boolean commaDelimited) throws SettingsException {
        String value;
        ArrayList<String> result = Lists.newArrayList();
        if (this.get(settingPrefix) != null) {
            if (commaDelimited.booleanValue()) {
                String[] strings = Strings.splitStringByCommaToArray(this.get(settingPrefix));
                if (strings.length > 0) {
                    for (String string : strings) {
                        result.add(string.trim());
                    }
                }
            } else {
                result.add(this.get(settingPrefix).trim());
            }
        }
        int counter = 0;
        while ((value = this.get(settingPrefix + '.' + counter++)) != null) {
            result.add(value.trim());
        }
        if (result.isEmpty()) {
            return defaultArray;
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public Map<String, Settings> getGroups(String settingPrefix) throws SettingsException {
        return this.getGroups(settingPrefix, false);
    }

    @Override
    public Map<String, Settings> getGroups(String settingPrefix, boolean ignoreNonGrouped) throws SettingsException {
        if (!Strings.hasLength(settingPrefix)) {
            throw new ElasticsearchIllegalArgumentException("illegal setting prefix " + settingPrefix);
        }
        if (settingPrefix.charAt(settingPrefix.length() - 1) != '.') {
            settingPrefix = settingPrefix + ".";
        }
        LinkedHashMap<String, LinkedHashMap<String, String>> map = new LinkedHashMap<String, LinkedHashMap<String, String>>();
        for (Object o : this.settings.keySet()) {
            String setting = (String)o;
            if (!setting.startsWith(settingPrefix)) continue;
            String nameValue = setting.substring(settingPrefix.length());
            int dotIndex = nameValue.indexOf(46);
            if (dotIndex == -1) {
                if (ignoreNonGrouped) continue;
                throw new SettingsException("Failed to get setting group for [" + settingPrefix + "] setting prefix and setting [" + setting + "] because of a missing '.'");
            }
            String name = nameValue.substring(0, dotIndex);
            String value = nameValue.substring(dotIndex + 1);
            LinkedHashMap<String, String> groupSettings = (LinkedHashMap<String, String>)map.get(name);
            if (groupSettings == null) {
                groupSettings = new LinkedHashMap<String, String>();
                map.put(name, groupSettings);
            }
            groupSettings.put(value, this.get(setting));
        }
        LinkedHashMap retVal = new LinkedHashMap();
        for (Map.Entry entry : map.entrySet()) {
            retVal.put(entry.getKey(), new ImmutableSettings(Collections.unmodifiableMap((Map)entry.getValue()), this.classLoader));
        }
        return Collections.unmodifiableMap(retVal);
    }

    @Override
    public Version getAsVersion(String setting, Version defaultVersion) throws SettingsException {
        String sValue = this.get(setting);
        if (sValue == null) {
            return defaultVersion;
        }
        try {
            return Version.fromId(Integer.parseInt(sValue));
        }
        catch (Exception e) {
            throw new SettingsException("Failed to parse version setting [" + setting + "] with value [" + sValue + "]", e);
        }
    }

    @Override
    public Set<String> names() {
        HashSet<String> names = new HashSet<String>();
        for (String key : this.settings.keySet()) {
            int i = key.indexOf(".");
            if (i < 0) {
                names.add(key);
                continue;
            }
            names.add(key.substring(0, i));
        }
        return names;
    }

    @Override
    public String toDelimitedString(char delimiter) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : this.settings.entrySet()) {
            sb.append((String)entry.getKey()).append("=").append((String)entry.getValue()).append(delimiter);
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableSettings that = (ImmutableSettings)o;
        if (this.classLoader != null ? !this.classLoader.equals(that.classLoader) : that.classLoader != null) {
            return false;
        }
        return !(this.settings != null ? !this.settings.equals(that.settings) : that.settings != null);
    }

    public int hashCode() {
        int result = this.settings != null ? this.settings.hashCode() : 0;
        result = 31 * result + (this.classLoader != null ? this.classLoader.hashCode() : 0);
        return result;
    }

    public static Settings readSettingsFromStream(StreamInput in) throws IOException {
        Builder builder = new Builder();
        int numberOfSettings = in.readVInt();
        for (int i = 0; i < numberOfSettings; ++i) {
            builder.put(in.readString(), in.readString());
        }
        return builder.build();
    }

    public static void writeSettingsToStream(Settings settings, StreamOutput out) throws IOException {
        out.writeVInt(settings.getAsMap().size());
        for (Map.Entry entry : settings.getAsMap().entrySet()) {
            out.writeString((String)entry.getKey());
            out.writeString((String)entry.getValue());
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder settingsBuilder() {
        return new Builder();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (!params.paramAsBoolean(FLAT_SETTINGS_KEY, false)) {
            for (Map.Entry<String, Object> entry : this.getAsStructuredMap().entrySet()) {
                builder.field(entry.getKey(), entry.getValue());
            }
        } else {
            for (Map.Entry entry : this.getAsMap().entrySet()) {
                builder.field((String)entry.getKey(), (String)entry.getValue(), XContentBuilder.FieldCaseConversion.NONE);
            }
        }
        return builder;
    }

    private static StartsWithPredicate startsWith(String prefix) {
        return new StartsWithPredicate(prefix);
    }

    private static final class StartsWithPredicate
    implements Predicate<String> {
        private String prefix;

        public StartsWithPredicate(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public boolean apply(String input) {
            return input.startsWith(this.prefix);
        }
    }

    public static class Builder
    implements Settings.Builder {
        public static final Settings EMPTY_SETTINGS = new Builder().build();
        private final Map<String, String> map = new LinkedHashMap<String, String>();
        private ClassLoader classLoader;

        private Builder() {
        }

        public Map<String, String> internalMap() {
            return this.map;
        }

        public String remove(String key) {
            return this.map.remove(key);
        }

        public String get(String key) {
            String retVal = this.map.get(key);
            if (retVal != null) {
                return retVal;
            }
            return this.map.get(Strings.toCamelCase(key));
        }

        public Builder put(Object ... settings) {
            if (settings.length == 1) {
                if (settings[0] instanceof Map) {
                    return this.put((Map)settings[0]);
                }
                if (settings[0] instanceof Settings) {
                    return this.put((Settings)settings[0]);
                }
            }
            if (settings.length % 2 != 0) {
                throw new ElasticsearchIllegalArgumentException("array settings of key + value order doesn't hold correct number of arguments (" + settings.length + ")");
            }
            for (int i = 0; i < settings.length; ++i) {
                this.put(settings[i++].toString(), settings[i].toString());
            }
            return this;
        }

        public Builder put(String key, String value) {
            this.map.put(key, value);
            return this;
        }

        public Builder put(String key, Class clazz) {
            this.map.put(key, clazz.getName());
            return this;
        }

        public Builder put(String setting, boolean value) {
            this.put(setting, String.valueOf(value));
            return this;
        }

        public Builder put(String setting, int value) {
            this.put(setting, String.valueOf(value));
            return this;
        }

        public Builder put(String setting, Version version) {
            this.put(setting, version.id);
            return this;
        }

        public Builder put(String setting, long value) {
            this.put(setting, String.valueOf(value));
            return this;
        }

        public Builder put(String setting, float value) {
            this.put(setting, String.valueOf(value));
            return this;
        }

        public Builder put(String setting, double value) {
            this.put(setting, String.valueOf(value));
            return this;
        }

        public Builder put(String setting, long value, TimeUnit timeUnit) {
            this.put(setting, timeUnit.toMillis(value));
            return this;
        }

        public Builder put(String setting, long value, ByteSizeUnit sizeUnit) {
            this.put(setting, sizeUnit.toBytes(value));
            return this;
        }

        public Builder putArray(String setting, String ... values) {
            String value;
            this.remove(setting);
            int counter = 0;
            while ((value = this.map.remove(setting + '.' + counter++)) != null) {
            }
            for (int i = 0; i < values.length; ++i) {
                this.put(setting + "." + i, values[i]);
            }
            return this;
        }

        public Builder put(String settingPrefix, String groupName, String[] settings, String[] values) throws SettingsException {
            if (settings.length != values.length) {
                throw new SettingsException("The settings length must match the value length");
            }
            for (int i = 0; i < settings.length; ++i) {
                if (values[i] == null) continue;
                this.put(settingPrefix + "." + groupName + "." + settings[i], values[i]);
            }
            return this;
        }

        public Builder put(Settings settings) {
            this.removeNonArraysFieldsIfNewSettingsContainsFieldAsArray(settings.getAsMap());
            this.map.putAll(settings.getAsMap());
            this.classLoader = settings.getClassLoaderIfSet();
            return this;
        }

        public Builder put(Map<String, String> settings) {
            this.removeNonArraysFieldsIfNewSettingsContainsFieldAsArray(settings);
            this.map.putAll(settings);
            return this;
        }

        private void removeNonArraysFieldsIfNewSettingsContainsFieldAsArray(Map<String, String> settings) {
            ArrayList<String> prefixesToRemove = new ArrayList<String>();
            for (Map.Entry<String, String> entry : settings.entrySet()) {
                Matcher matcher = ARRAY_PATTERN.matcher(entry.getKey());
                if (matcher.matches()) {
                    prefixesToRemove.add(matcher.group(1));
                    continue;
                }
                if (!Iterables.any(this.map.keySet(), ImmutableSettings.startsWith(entry.getKey() + "."))) continue;
                prefixesToRemove.add(entry.getKey());
            }
            for (String prefix : prefixesToRemove) {
                Iterator<Map.Entry<String, String>> iterator = this.map.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, String> entry = iterator.next();
                    if (!entry.getKey().startsWith(prefix + ".") && !entry.getKey().equals(prefix)) continue;
                    iterator.remove();
                }
            }
        }

        public Builder put(Properties properties) {
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                this.map.put((String)entry.getKey(), (String)entry.getValue());
            }
            return this;
        }

        public Builder loadFromDelimitedString(String value, char delimiter) {
            String[] values;
            for (String s : values = Strings.splitStringToArray(value, delimiter)) {
                int index = s.indexOf(61);
                if (index == -1) {
                    throw new ElasticsearchIllegalArgumentException("value [" + s + "] for settings loaded with delimiter [" + delimiter + "] is malformed, missing =");
                }
                this.map.put(s.substring(0, index), s.substring(index + 1));
            }
            return this;
        }

        public Builder loadFromSource(String source) {
            SettingsLoader settingsLoader = SettingsLoaderFactory.loaderFromSource(source);
            try {
                Map<String, String> loadedSettings = settingsLoader.load(source);
                this.put(loadedSettings);
            }
            catch (Exception e) {
                throw new SettingsException("Failed to load settings from [" + source + "]", e);
            }
            return this;
        }

        public Builder loadFromUrl(URL url) throws SettingsException {
            try {
                return this.loadFromStream(url.toExternalForm(), url.openStream());
            }
            catch (IOException e) {
                throw new SettingsException("Failed to open stream for url [" + url.toExternalForm() + "]", e);
            }
        }

        public Builder loadFromStream(String resourceName, InputStream is) throws SettingsException {
            SettingsLoader settingsLoader = SettingsLoaderFactory.loaderFromResource(resourceName);
            try {
                Map<String, String> loadedSettings = settingsLoader.load(Streams.copyToString(new InputStreamReader(is, Charsets.UTF_8)));
                this.put(loadedSettings);
            }
            catch (Exception e) {
                throw new SettingsException("Failed to load settings from [" + resourceName + "]", e);
            }
            return this;
        }

        public Builder loadFromClasspath(String resourceName) throws SettingsException {
            InputStream is;
            ClassLoader classLoader = this.classLoader;
            if (classLoader == null) {
                classLoader = Classes.getDefaultClassLoader();
            }
            if ((is = classLoader.getResourceAsStream(resourceName)) == null) {
                return this;
            }
            return this.loadFromStream(resourceName, is);
        }

        public Builder classLoader(ClassLoader classLoader) {
            this.classLoader = classLoader;
            return this;
        }

        public Builder putProperties(String prefix, Properties properties) {
            for (Object key1 : properties.keySet()) {
                String key = (String)key1;
                String value = properties.getProperty(key);
                if (!key.startsWith(prefix)) continue;
                this.map.put(key.substring(prefix.length()), value);
            }
            return this;
        }

        public Builder putProperties(String prefix, Properties properties, String[] ignorePrefixes) {
            for (Object key1 : properties.keySet()) {
                String key = (String)key1;
                String value = properties.getProperty(key);
                if (!key.startsWith(prefix)) continue;
                boolean ignore = false;
                for (String ignorePrefix : ignorePrefixes) {
                    if (!key.startsWith(ignorePrefix)) continue;
                    ignore = true;
                    break;
                }
                if (ignore) continue;
                this.map.put(key.substring(prefix.length()), value);
            }
            return this;
        }

        public Builder replacePropertyPlaceholders() {
            PropertyPlaceholder propertyPlaceholder = new PropertyPlaceholder("${", "}", false);
            PropertyPlaceholder.PlaceholderResolver placeholderResolver = new PropertyPlaceholder.PlaceholderResolver(){

                @Override
                public String resolvePlaceholder(String placeholderName) {
                    if (placeholderName.startsWith("env.")) {
                        return System.getenv(placeholderName.substring("env.".length()));
                    }
                    String value = System.getProperty(placeholderName);
                    if (value != null) {
                        return value;
                    }
                    value = System.getenv(placeholderName);
                    if (value != null) {
                        return value;
                    }
                    return (String)Builder.this.map.get(placeholderName);
                }

                @Override
                public boolean shouldIgnoreMissing(String placeholderName) {
                    return placeholderName.startsWith("env.") || placeholderName.startsWith("prompt.");
                }

                @Override
                public boolean shouldRemoveMissingPlaceholder(String placeholderName) {
                    return !placeholderName.startsWith("prompt.");
                }
            };
            for (Map.Entry<String, String> entry : Maps.newHashMap(this.map).entrySet()) {
                String value = propertyPlaceholder.replacePlaceholders(entry.getValue(), placeholderResolver);
                if (Strings.hasLength(value)) {
                    this.map.put(entry.getKey(), value);
                    continue;
                }
                this.map.remove(entry.getKey());
            }
            return this;
        }

        public Builder normalizePrefix(String prefix) {
            HashMap<String, String> replacements = Maps.newHashMap();
            Iterator<Map.Entry<String, String>> iterator = this.map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, String> entry = iterator.next();
                if (entry.getKey().startsWith(prefix)) continue;
                replacements.put(prefix + entry.getKey(), entry.getValue());
                iterator.remove();
            }
            this.map.putAll(replacements);
            return this;
        }

        @Override
        public Settings build() {
            return new ImmutableSettings(Collections.unmodifiableMap(this.map), this.classLoader);
        }
    }
}

