/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing;

import java.io.IOException;
import java.io.Serializable;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.routing.PlainShardIterator;
import org.elasticsearch.cluster.routing.RestoreSource;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.ShardRoutingState;
import org.elasticsearch.cluster.routing.UnassignedInfo;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.shard.ShardId;

public class ImmutableShardRouting
implements Streamable,
Serializable,
ShardRouting {
    protected String index;
    protected int shardId;
    protected String currentNodeId;
    protected String relocatingNodeId;
    protected boolean primary;
    protected ShardRoutingState state;
    protected long version;
    private transient ShardId shardIdentifier;
    protected RestoreSource restoreSource;
    protected UnassignedInfo unassignedInfo;
    private final transient ImmutableList<ShardRouting> asList;

    ImmutableShardRouting() {
        this.asList = ImmutableList.of(this);
    }

    public ImmutableShardRouting(ShardRouting copy) {
        this(copy, copy.version());
    }

    public ImmutableShardRouting(ShardRouting copy, long version) {
        this(copy.index(), copy.id(), copy.currentNodeId(), copy.relocatingNodeId(), copy.restoreSource(), copy.primary(), copy.state(), version, copy.unassignedInfo());
    }

    public ImmutableShardRouting(String index, int shardId, String currentNodeId, boolean primary, ShardRoutingState state, long version) {
        this(index, shardId, currentNodeId, null, primary, state, version);
    }

    public ImmutableShardRouting(String index, int shardId, String currentNodeId, String relocatingNodeId, boolean primary, ShardRoutingState state, long version) {
        this(index, shardId, currentNodeId, relocatingNodeId, null, primary, state, version);
    }

    public ImmutableShardRouting(String index, int shardId, String currentNodeId, String relocatingNodeId, RestoreSource restoreSource, boolean primary, ShardRoutingState state, long version) {
        this(index, shardId, currentNodeId, relocatingNodeId, restoreSource, primary, state, version, null);
    }

    public ImmutableShardRouting(String index, int shardId, String currentNodeId, String relocatingNodeId, RestoreSource restoreSource, boolean primary, ShardRoutingState state, long version, UnassignedInfo unassignedInfo) {
        this.index = index;
        this.shardId = shardId;
        this.currentNodeId = currentNodeId;
        this.relocatingNodeId = relocatingNodeId;
        this.primary = primary;
        this.state = state;
        this.asList = ImmutableList.of(this);
        this.version = version;
        this.restoreSource = restoreSource;
        this.unassignedInfo = unassignedInfo;
        assert (state != ShardRoutingState.UNASSIGNED || unassignedInfo != null) : "unassigned shard must be created with meta";
    }

    @Override
    public String index() {
        return this.index;
    }

    @Override
    public String getIndex() {
        return this.index();
    }

    @Override
    public int id() {
        return this.shardId;
    }

    @Override
    public int getId() {
        return this.id();
    }

    @Override
    public long version() {
        return this.version;
    }

    @Override
    public boolean unassigned() {
        return this.state == ShardRoutingState.UNASSIGNED;
    }

    @Override
    public boolean initializing() {
        return this.state == ShardRoutingState.INITIALIZING;
    }

    @Override
    public boolean active() {
        return this.started() || this.relocating();
    }

    @Override
    public boolean started() {
        return this.state == ShardRoutingState.STARTED;
    }

    @Override
    public boolean relocating() {
        return this.state == ShardRoutingState.RELOCATING;
    }

    @Override
    public boolean assignedToNode() {
        return this.currentNodeId != null;
    }

    @Override
    public String currentNodeId() {
        return this.currentNodeId;
    }

    @Override
    public String relocatingNodeId() {
        return this.relocatingNodeId;
    }

    @Override
    public ShardRouting targetRoutingIfRelocating() {
        if (!this.relocating()) {
            return null;
        }
        return new ImmutableShardRouting(this.index, this.shardId, this.relocatingNodeId, this.currentNodeId, this.primary, ShardRoutingState.INITIALIZING, this.version);
    }

    @Override
    public RestoreSource restoreSource() {
        return this.restoreSource;
    }

    @Override
    @Nullable
    public UnassignedInfo unassignedInfo() {
        return this.unassignedInfo;
    }

    @Override
    public boolean primary() {
        return this.primary;
    }

    @Override
    public ShardRoutingState state() {
        return this.state;
    }

    @Override
    public ShardId shardId() {
        if (this.shardIdentifier != null) {
            return this.shardIdentifier;
        }
        this.shardIdentifier = new ShardId(this.index, this.shardId);
        return this.shardIdentifier;
    }

    @Override
    public ShardIterator shardsIt() {
        return new PlainShardIterator(this.shardId(), this.asList);
    }

    public static ImmutableShardRouting readShardRoutingEntry(StreamInput in) throws IOException {
        ImmutableShardRouting entry = new ImmutableShardRouting();
        entry.readFrom(in);
        return entry;
    }

    public static ImmutableShardRouting readShardRoutingEntry(StreamInput in, String index, int shardId) throws IOException {
        ImmutableShardRouting entry = new ImmutableShardRouting();
        entry.readFrom(in, index, shardId);
        return entry;
    }

    public void readFrom(StreamInput in, String index, int shardId) throws IOException {
        this.index = index;
        this.shardId = shardId;
        this.readFromThin(in);
    }

    @Override
    public void readFromThin(StreamInput in) throws IOException {
        this.version = in.readLong();
        if (in.readBoolean()) {
            this.currentNodeId = in.readString();
        }
        if (in.readBoolean()) {
            this.relocatingNodeId = in.readString();
        }
        this.primary = in.readBoolean();
        this.state = ShardRoutingState.fromValue(in.readByte());
        this.restoreSource = RestoreSource.readOptionalRestoreSource(in);
        if (in.getVersion().onOrAfter(Version.V_1_7_0)) {
            if (in.readBoolean()) {
                this.unassignedInfo = new UnassignedInfo(in);
            }
        } else if (this.state == ShardRoutingState.UNASSIGNED) {
            this.unassignedInfo = new UnassignedInfo(UnassignedInfo.Reason.UNKNOWN, null);
        }
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.readFrom(in, in.readString(), in.readVInt());
    }

    @Override
    public void writeToThin(StreamOutput out) throws IOException {
        out.writeLong(this.version);
        if (this.currentNodeId != null) {
            out.writeBoolean(true);
            out.writeString(this.currentNodeId);
        } else {
            out.writeBoolean(false);
        }
        if (this.relocatingNodeId != null) {
            out.writeBoolean(true);
            out.writeString(this.relocatingNodeId);
        } else {
            out.writeBoolean(false);
        }
        out.writeBoolean(this.primary);
        out.writeByte(this.state.value());
        if (this.restoreSource != null) {
            out.writeBoolean(true);
            this.restoreSource.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        if (out.getVersion().onOrAfter(Version.V_1_7_0)) {
            if (this.unassignedInfo != null) {
                out.writeBoolean(true);
                this.unassignedInfo.writeTo(out);
            } else {
                out.writeBoolean(false);
            }
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.index);
        out.writeVInt(this.shardId);
        this.writeToThin(out);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof ImmutableShardRouting)) {
            return false;
        }
        ImmutableShardRouting that = (ImmutableShardRouting)o;
        if (this.primary != that.primary) {
            return false;
        }
        if (this.shardId != that.shardId) {
            return false;
        }
        if (this.currentNodeId != null ? !this.currentNodeId.equals(that.currentNodeId) : that.currentNodeId != null) {
            return false;
        }
        if (this.index != null ? !this.index.equals(that.index) : that.index != null) {
            return false;
        }
        if (this.relocatingNodeId != null ? !this.relocatingNodeId.equals(that.relocatingNodeId) : that.relocatingNodeId != null) {
            return false;
        }
        if (this.state != that.state) {
            return false;
        }
        return !(this.restoreSource != null ? !this.restoreSource.equals(that.restoreSource) : that.restoreSource != null);
    }

    public int hashCode() {
        int result = this.index != null ? this.index.hashCode() : 0;
        result = 31 * result + this.shardId;
        result = 31 * result + (this.currentNodeId != null ? this.currentNodeId.hashCode() : 0);
        result = 31 * result + (this.relocatingNodeId != null ? this.relocatingNodeId.hashCode() : 0);
        result = 31 * result + (this.primary ? 1 : 0);
        result = 31 * result + (this.state != null ? this.state.hashCode() : 0);
        result = 31 * result + (this.restoreSource != null ? this.restoreSource.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.shortSummary();
    }

    @Override
    public String shortSummary() {
        StringBuilder sb = new StringBuilder();
        sb.append('[').append(this.index).append(']').append('[').append(this.shardId).append(']');
        sb.append(", node[").append(this.currentNodeId).append("], ");
        if (this.relocatingNodeId != null) {
            sb.append("relocating [").append(this.relocatingNodeId).append("], ");
        }
        if (this.primary) {
            sb.append("[P]");
        } else {
            sb.append("[R]");
        }
        if (this.restoreSource != null) {
            sb.append(", restoring[" + this.restoreSource + "]");
        }
        sb.append(", s[").append((Object)this.state).append("]");
        if (this.unassignedInfo != null) {
            sb.append(", ").append(this.unassignedInfo.toString());
        }
        return sb.toString();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject().field("state", (Object)this.state()).field("primary", this.primary()).field("node", this.currentNodeId()).field("relocating_node", this.relocatingNodeId()).field("shard", this.shardId().id()).field("index", this.shardId().index().name());
        if (this.restoreSource() != null) {
            builder.field("restore_source");
            this.restoreSource().toXContent(builder, params);
        }
        if (this.unassignedInfo != null) {
            this.unassignedInfo.toXContent(builder, params);
        }
        return builder.endObject();
    }
}

