/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.upgrade.post;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.apache.lucene.util.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.PrimaryMissingActionException;
import org.elasticsearch.action.ShardOperationFailedException;
import org.elasticsearch.action.admin.indices.upgrade.post.ShardUpgradeRequest;
import org.elasticsearch.action.admin.indices.upgrade.post.ShardUpgradeResponse;
import org.elasticsearch.action.admin.indices.upgrade.post.TransportUpgradeSettingsAction;
import org.elasticsearch.action.admin.indices.upgrade.post.UpgradeRequest;
import org.elasticsearch.action.admin.indices.upgrade.post.UpgradeResponse;
import org.elasticsearch.action.admin.indices.upgrade.post.UpgradeSettingsRequest;
import org.elasticsearch.action.admin.indices.upgrade.post.UpgradeSettingsResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.DefaultShardOperationFailedException;
import org.elasticsearch.action.support.broadcast.BroadcastShardOperationFailedException;
import org.elasticsearch.action.support.broadcast.TransportBroadcastOperationAction;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.routing.GroupShardsIterator;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.collect.Sets;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportUpgradeAction
extends TransportBroadcastOperationAction<UpgradeRequest, UpgradeResponse, ShardUpgradeRequest, ShardUpgradeResponse> {
    private final IndicesService indicesService;
    private final TransportUpgradeSettingsAction upgradeSettingsAction;

    @Inject
    public TransportUpgradeAction(Settings settings, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, IndicesService indicesService, ActionFilters actionFilters, TransportUpgradeSettingsAction upgradeSettingsAction) {
        super(settings, "indices:admin/upgrade", threadPool, clusterService, transportService, actionFilters);
        this.indicesService = indicesService;
        this.upgradeSettingsAction = upgradeSettingsAction;
    }

    @Override
    protected UpgradeResponse newResponse(UpgradeRequest request, AtomicReferenceArray shardsResponses, ClusterState clusterState) {
        int successfulShards = 0;
        int failedShards = 0;
        ArrayList<ShardOperationFailedException> shardFailures = null;
        HashMap<String, Integer> successfulPrimaryShards = Maps.newHashMap();
        HashMap<String, Version> versions = Maps.newHashMap();
        for (int i = 0; i < shardsResponses.length(); ++i) {
            Version version;
            Object shardResponse = shardsResponses.get(i);
            if (shardResponse == null) continue;
            if (shardResponse instanceof BroadcastShardOperationFailedException) {
                ++failedShards;
                if (shardFailures == null) {
                    shardFailures = Lists.newArrayList();
                }
                shardFailures.add(new DefaultShardOperationFailedException((BroadcastShardOperationFailedException)shardResponse));
                continue;
            }
            ++successfulShards;
            ShardUpgradeResponse shardUpgradeResponse = (ShardUpgradeResponse)shardResponse;
            String index = shardUpgradeResponse.getIndex();
            if (shardUpgradeResponse.primary()) {
                Integer count = (Integer)successfulPrimaryShards.get(index);
                successfulPrimaryShards.put(index, count == null ? 1 : count + 1);
            }
            if ((version = (Version)versions.get(index)) != null && shardUpgradeResponse.version().onOrAfter(version)) continue;
            versions.put(index, shardUpgradeResponse.version());
        }
        HashMap<String, String> updatedVersions = Maps.newHashMap();
        MetaData metaData = clusterState.metaData();
        for (Map.Entry versionEntry : versions.entrySet()) {
            String index = (String)versionEntry.getKey();
            Integer primaryCount = (Integer)successfulPrimaryShards.get(index);
            int expectedPrimaryCount = metaData.index(index).getNumberOfShards();
            if (primaryCount.intValue() == metaData.index(index).getNumberOfShards()) {
                updatedVersions.put(index, ((Version)versionEntry.getValue()).toString());
                continue;
            }
            this.logger.warn("Not updating settings for the index [{}] because upgraded of some primary shards failed - expected[{}], received[{}]", index, expectedPrimaryCount, primaryCount == null ? 0 : primaryCount);
        }
        return new UpgradeResponse(updatedVersions, shardsResponses.length(), successfulShards, failedShards, shardFailures);
    }

    @Override
    protected ShardUpgradeRequest newShardRequest() {
        return new ShardUpgradeRequest();
    }

    @Override
    protected ShardUpgradeRequest newShardRequest(int numShards, ShardRouting shard, UpgradeRequest request) {
        return new ShardUpgradeRequest(shard.shardId(), request);
    }

    @Override
    protected ShardUpgradeResponse newShardResponse() {
        return new ShardUpgradeResponse();
    }

    @Override
    protected ShardUpgradeResponse shardOperation(ShardUpgradeRequest request) {
        IndexShard indexShard = this.indicesService.indexServiceSafe(request.shardId().getIndex()).shardSafe(request.shardId().id());
        Version version = indexShard.upgrade(request.upgradeRequest());
        return new ShardUpgradeResponse(request.shardId(), indexShard.routingEntry().primary(), version);
    }

    @Override
    protected GroupShardsIterator shards(ClusterState clusterState, UpgradeRequest request, String[] concreteIndices) {
        GroupShardsIterator iterator = clusterState.routingTable().allActiveShardsGrouped(concreteIndices, true);
        Set<String> indicesWithMissingPrimaries = this.indicesWithMissingPrimaries(clusterState, concreteIndices);
        if (indicesWithMissingPrimaries.isEmpty()) {
            return iterator;
        }
        throw new PrimaryMissingActionException("Cannot upgrade indices because the following indices are missing primary shards " + indicesWithMissingPrimaries);
    }

    private Set<String> indicesWithMissingPrimaries(ClusterState clusterState, String[] concreteIndices) {
        HashSet<String> indices = Sets.newHashSet();
        RoutingTable routingTable = clusterState.routingTable();
        for (String index : concreteIndices) {
            IndexRoutingTable indexRoutingTable = routingTable.index(index);
            if (indexRoutingTable.allPrimaryShardsActive()) continue;
            indices.add(index);
        }
        return indices;
    }

    @Override
    protected ClusterBlockException checkGlobalBlock(ClusterState state, UpgradeRequest request) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    @Override
    protected ClusterBlockException checkRequestBlock(ClusterState state, UpgradeRequest request, String[] concreteIndices) {
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_WRITE, concreteIndices);
    }

    @Override
    protected void doExecute(UpgradeRequest request, final ActionListener<UpgradeResponse> listener) {
        ActionListener<UpgradeResponse> settingsUpdateListener = new ActionListener<UpgradeResponse>(){

            @Override
            public void onResponse(UpgradeResponse upgradeResponse) {
                try {
                    if (upgradeResponse.versions().isEmpty()) {
                        listener.onResponse(upgradeResponse);
                    } else {
                        TransportUpgradeAction.this.updateSettings(upgradeResponse, listener);
                    }
                }
                catch (Throwable t) {
                    listener.onFailure(t);
                }
            }

            @Override
            public void onFailure(Throwable e) {
                listener.onFailure(e);
            }
        };
        super.doExecute(request, settingsUpdateListener);
    }

    @Override
    protected String executor() {
        return "optimize";
    }

    @Override
    protected UpgradeRequest newRequest() {
        return new UpgradeRequest();
    }

    private void updateSettings(final UpgradeResponse upgradeResponse, final ActionListener<UpgradeResponse> listener) {
        UpgradeSettingsRequest upgradeSettingsRequest = new UpgradeSettingsRequest(upgradeResponse.versions());
        this.upgradeSettingsAction.execute(upgradeSettingsRequest, new ActionListener<UpgradeSettingsResponse>(){

            @Override
            public void onResponse(UpgradeSettingsResponse updateSettingsResponse) {
                listener.onResponse(upgradeResponse);
            }

            @Override
            public void onFailure(Throwable e) {
                listener.onFailure(e);
            }
        });
    }
}

