/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.blobstore.support;

import java.io.IOException;
import org.elasticsearch.common.blobstore.BlobContainer;
import org.elasticsearch.common.blobstore.BlobMetaData;
import org.elasticsearch.common.blobstore.BlobPath;
import org.elasticsearch.common.collect.ImmutableMap;

public abstract class AbstractBlobContainer
implements BlobContainer {
    private final BlobPath path;

    protected AbstractBlobContainer(BlobPath path) {
        this.path = path;
    }

    @Override
    public BlobPath path() {
        return this.path;
    }

    @Override
    public ImmutableMap<String, BlobMetaData> listBlobsByPrefix(String blobNamePrefix) throws IOException {
        ImmutableMap<String, BlobMetaData> allBlobs = this.listBlobs();
        ImmutableMap.Builder<String, BlobMetaData> blobs = ImmutableMap.builder();
        for (BlobMetaData blob : allBlobs.values()) {
            if (!blob.name().startsWith(blobNamePrefix)) continue;
            blobs.put(blob.name(), blob);
        }
        return blobs.build();
    }

    @Override
    public void deleteBlobsByPrefix(String blobNamePrefix) throws IOException {
        ImmutableMap<String, BlobMetaData> blobs = this.listBlobsByPrefix(blobNamePrefix);
        for (BlobMetaData blob : blobs.values()) {
            this.deleteBlob(blob.name());
        }
    }

    @Override
    public void deleteBlobsByFilter(BlobContainer.BlobNameFilter filter) throws IOException {
        ImmutableMap<String, BlobMetaData> blobs = this.listBlobs();
        for (BlobMetaData blob : blobs.values()) {
            if (!filter.accept(blob.name())) continue;
            this.deleteBlob(blob.name());
        }
    }
}

