/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.decider;

import java.util.List;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDeciders;
import org.elasticsearch.cluster.routing.allocation.decider.AwarenessAllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.ClusterRebalanceAllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.ConcurrentRebalanceAllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.DisableAllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.DiskThresholdDecider;
import org.elasticsearch.cluster.routing.allocation.decider.EnableAllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.FilterAllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.NodeVersionAllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.RebalanceOnlyWhenActiveAllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.ReplicaAfterPrimaryActiveAllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.SameShardAllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.ShardsLimitAllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.SnapshotInProgressAllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.ThrottlingAllocationDecider;
import org.elasticsearch.common.collect.ImmutableSet;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.inject.AbstractModule;
import org.elasticsearch.common.inject.multibindings.Multibinder;
import org.elasticsearch.common.settings.Settings;

public class AllocationDecidersModule
extends AbstractModule {
    private final Settings settings;
    private List<Class<? extends AllocationDecider>> allocations = Lists.newArrayList();
    public static final ImmutableSet<Class<? extends AllocationDecider>> DEFAULT_ALLOCATION_DECIDERS = ((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().add(SameShardAllocationDecider.class)).add(FilterAllocationDecider.class)).add(ReplicaAfterPrimaryActiveAllocationDecider.class)).add(ThrottlingAllocationDecider.class)).add(RebalanceOnlyWhenActiveAllocationDecider.class)).add(ClusterRebalanceAllocationDecider.class)).add(ConcurrentRebalanceAllocationDecider.class)).add(EnableAllocationDecider.class)).add(DisableAllocationDecider.class)).add(AwarenessAllocationDecider.class)).add(ShardsLimitAllocationDecider.class)).add(NodeVersionAllocationDecider.class)).add(DiskThresholdDecider.class)).add(SnapshotInProgressAllocationDecider.class)).build();

    public AllocationDecidersModule(Settings settings) {
        this.settings = settings;
    }

    public AllocationDecidersModule add(Class<? extends AllocationDecider> allocationDecider) {
        this.allocations.add(allocationDecider);
        return this;
    }

    @Override
    protected void configure() {
        Multibinder<AllocationDecider> allocationMultibinder = Multibinder.newSetBinder(this.binder(), AllocationDecider.class);
        for (Class clazz : DEFAULT_ALLOCATION_DECIDERS) {
            allocationMultibinder.addBinding().to(clazz).asEagerSingleton();
        }
        for (Class<? extends AllocationDecider> clazz : this.allocations) {
            allocationMultibinder.addBinding().to(clazz).asEagerSingleton();
        }
        this.bind(AllocationDeciders.class).asEagerSingleton();
    }
}

