/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsClusterStateUpdateRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.ack.AckedRequest;
import org.elasticsearch.cluster.ack.ClusterStateUpdateResponse;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.settings.DynamicSettings;
import org.elasticsearch.common.Booleans;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.collect.Sets;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.settings.IndexDynamicSettings;

public class MetaDataUpdateSettingsService
extends AbstractComponent
implements ClusterStateListener {
    private static final String ALL_NODES_VALUE = "all";
    private final ClusterService clusterService;
    private final AllocationService allocationService;
    private final DynamicSettings dynamicSettings;

    @Inject
    public MetaDataUpdateSettingsService(Settings settings, ClusterService clusterService, AllocationService allocationService, @IndexDynamicSettings DynamicSettings dynamicSettings) {
        super(settings);
        this.clusterService = clusterService;
        this.clusterService.add(this);
        this.allocationService = allocationService;
        this.dynamicSettings = dynamicSettings;
    }

    @Override
    public void clusterChanged(ClusterChangedEvent event) {
        if (!event.state().nodes().localNodeMaster()) {
            return;
        }
        int dataNodeCount = event.state().nodes().dataNodes().size();
        HashMap nrReplicasChanged = new HashMap();
        for (IndexMetaData indexMetaData : event.state().metaData()) {
            String autoExpandReplicas = indexMetaData.settings().get("index.auto_expand_replicas");
            if (autoExpandReplicas == null || !Booleans.parseBoolean(autoExpandReplicas, true)) continue;
            try {
                int max;
                int min;
                int dash = autoExpandReplicas.indexOf(45);
                if (-1 == dash) {
                    this.logger.warn("Unexpected value [{}] for setting [{}]; it should be dash delimited", autoExpandReplicas, "index.auto_expand_replicas");
                    continue;
                }
                String sMin = autoExpandReplicas.substring(0, dash);
                try {
                    min = Integer.parseInt(sMin);
                }
                catch (NumberFormatException e) {
                    this.logger.warn("failed to set [{}], minimum value is not a number [{}]", e, "index.auto_expand_replicas", sMin);
                    continue;
                }
                String sMax = autoExpandReplicas.substring(dash + 1);
                if (sMax.equals(ALL_NODES_VALUE)) {
                    max = dataNodeCount - 1;
                } else {
                    try {
                        max = Integer.parseInt(sMax);
                    }
                    catch (NumberFormatException e) {
                        this.logger.warn("failed to set [{}], maximum value is neither [{}] nor a number [{}]", e, "index.auto_expand_replicas", ALL_NODES_VALUE, sMax);
                        continue;
                    }
                }
                int numberOfReplicas = dataNodeCount - 1;
                if (numberOfReplicas < min) {
                    numberOfReplicas = min;
                } else if (numberOfReplicas > max) {
                    numberOfReplicas = max;
                }
                if (numberOfReplicas == indexMetaData.numberOfReplicas() || numberOfReplicas < min || numberOfReplicas > max) continue;
                if (!nrReplicasChanged.containsKey(numberOfReplicas)) {
                    nrReplicasChanged.put(numberOfReplicas, new ArrayList());
                }
                ((List)nrReplicasChanged.get(numberOfReplicas)).add(indexMetaData.index());
            }
            catch (Exception e) {
                this.logger.warn("[{}] failed to parse auto expand replicas", e, indexMetaData.index());
            }
        }
        if (nrReplicasChanged.size() > 0) {
            for (final Integer fNumberOfReplicas : nrReplicasChanged.keySet()) {
                Settings settings = ImmutableSettings.settingsBuilder().put("index.number_of_replicas", fNumberOfReplicas).build();
                final List indices = (List)nrReplicasChanged.get(fNumberOfReplicas);
                UpdateSettingsClusterStateUpdateRequest updateRequest = (UpdateSettingsClusterStateUpdateRequest)((UpdateSettingsClusterStateUpdateRequest)((UpdateSettingsClusterStateUpdateRequest)new UpdateSettingsClusterStateUpdateRequest().indices(indices.toArray(new String[indices.size()]))).settings(settings).ackTimeout(TimeValue.timeValueMillis(0L))).masterNodeTimeout(TimeValue.timeValueMinutes(10L));
                this.updateSettings(updateRequest, new ActionListener<ClusterStateUpdateResponse>(){

                    @Override
                    public void onResponse(ClusterStateUpdateResponse response) {
                        for (String index : indices) {
                            MetaDataUpdateSettingsService.this.logger.info("[{}] auto expanded replicas to [{}]", index, fNumberOfReplicas);
                        }
                    }

                    @Override
                    public void onFailure(Throwable t) {
                        for (String index : indices) {
                            MetaDataUpdateSettingsService.this.logger.warn("[{}] fail to auto expand replicas to [{}]", index, fNumberOfReplicas);
                        }
                    }
                });
            }
        }
    }

    public void updateSettings(final UpdateSettingsClusterStateUpdateRequest request, ActionListener<ClusterStateUpdateResponse> listener) {
        ImmutableSettings.Builder updatedSettingsBuilder = ImmutableSettings.settingsBuilder();
        updatedSettingsBuilder.put(request.settings()).normalizePrefix("index.");
        for (String key : updatedSettingsBuilder.internalMap().keySet()) {
            if (!key.equals("index.number_of_shards")) continue;
            listener.onFailure(new ElasticsearchIllegalArgumentException("can't change the number of shards for an index"));
            return;
        }
        final Settings closeSettings = updatedSettingsBuilder.build();
        final HashSet<String> removedSettings = Sets.newHashSet();
        HashSet<String> errors = Sets.newHashSet();
        for (Map.Entry<String, String> setting : updatedSettingsBuilder.internalMap().entrySet()) {
            if (!this.dynamicSettings.hasDynamicSetting(setting.getKey())) {
                removedSettings.add(setting.getKey());
                continue;
            }
            String error = this.dynamicSettings.validateDynamicSetting(setting.getKey(), setting.getValue());
            if (error == null) continue;
            errors.add("[" + setting.getKey() + "] - " + error);
        }
        if (!errors.isEmpty()) {
            listener.onFailure(new ElasticsearchIllegalArgumentException("can't process the settings: " + ((Object)errors).toString()));
            return;
        }
        if (!removedSettings.isEmpty()) {
            for (String removedSetting : removedSettings) {
                updatedSettingsBuilder.remove(removedSetting);
            }
        }
        final Settings openSettings = updatedSettingsBuilder.build();
        this.clusterService.submitStateUpdateTask("update-settings", Priority.URGENT, new AckedClusterStateUpdateTask<ClusterStateUpdateResponse>((AckedRequest)request, listener){

            @Override
            protected ClusterStateUpdateResponse newResponse(boolean acknowledged) {
                return new ClusterStateUpdateResponse(acknowledged);
            }

            @Override
            public ClusterState execute(ClusterState currentState) {
                Boolean updateReadBlock;
                Boolean updateWriteBlock;
                Boolean updateMetaDataBlock;
                String[] actualIndices = currentState.metaData().concreteIndices(IndicesOptions.strictExpand(), request.indices());
                RoutingTable.Builder routingTableBuilder = RoutingTable.builder(currentState.routingTable());
                MetaData.Builder metaDataBuilder = MetaData.builder(currentState.metaData());
                HashSet<String> openIndices = Sets.newHashSet();
                HashSet<String> closeIndices = Sets.newHashSet();
                for (String index : actualIndices) {
                    if (currentState.metaData().index(index).state() == IndexMetaData.State.OPEN) {
                        openIndices.add(index);
                        continue;
                    }
                    closeIndices.add(index);
                }
                if (!removedSettings.isEmpty() && !openIndices.isEmpty()) {
                    throw new ElasticsearchIllegalArgumentException(String.format(Locale.ROOT, "Can't update non dynamic settings[%s] for open indices[%s]", removedSettings, openIndices));
                }
                int updatedNumberOfReplicas = openSettings.getAsInt("index.number_of_replicas", (Integer)-1);
                if (updatedNumberOfReplicas != -1) {
                    routingTableBuilder.updateNumberOfReplicas(updatedNumberOfReplicas, actualIndices);
                    metaDataBuilder.updateNumberOfReplicas(updatedNumberOfReplicas, actualIndices);
                    MetaDataUpdateSettingsService.this.logger.info("updating number_of_replicas to [{}] for indices {}", updatedNumberOfReplicas, actualIndices);
                }
                ClusterBlocks.Builder blocks = ClusterBlocks.builder().blocks(currentState.blocks());
                Boolean updatedReadOnly = openSettings.getAsBoolean("index.blocks.read_only", null);
                if (updatedReadOnly != null) {
                    for (String index : actualIndices) {
                        if (updatedReadOnly.booleanValue()) {
                            blocks.addIndexBlock(index, IndexMetaData.INDEX_READ_ONLY_BLOCK);
                            continue;
                        }
                        blocks.removeIndexBlock(index, IndexMetaData.INDEX_READ_ONLY_BLOCK);
                    }
                }
                if ((updateMetaDataBlock = openSettings.getAsBoolean("index.blocks.metadata", null)) != null) {
                    for (String index : actualIndices) {
                        if (updateMetaDataBlock.booleanValue()) {
                            blocks.addIndexBlock(index, IndexMetaData.INDEX_METADATA_BLOCK);
                            continue;
                        }
                        blocks.removeIndexBlock(index, IndexMetaData.INDEX_METADATA_BLOCK);
                    }
                }
                if ((updateWriteBlock = openSettings.getAsBoolean("index.blocks.write", null)) != null) {
                    for (String index : actualIndices) {
                        if (updateWriteBlock.booleanValue()) {
                            blocks.addIndexBlock(index, IndexMetaData.INDEX_WRITE_BLOCK);
                            continue;
                        }
                        blocks.removeIndexBlock(index, IndexMetaData.INDEX_WRITE_BLOCK);
                    }
                }
                if ((updateReadBlock = openSettings.getAsBoolean("index.blocks.read", null)) != null) {
                    for (String index : actualIndices) {
                        if (updateReadBlock.booleanValue()) {
                            blocks.addIndexBlock(index, IndexMetaData.INDEX_READ_BLOCK);
                            continue;
                        }
                        blocks.removeIndexBlock(index, IndexMetaData.INDEX_READ_BLOCK);
                    }
                }
                if (!openIndices.isEmpty()) {
                    String[] indices = openIndices.toArray(new String[openIndices.size()]);
                    metaDataBuilder.updateSettings(openSettings, indices);
                }
                if (!closeIndices.isEmpty()) {
                    String[] indices = closeIndices.toArray(new String[closeIndices.size()]);
                    metaDataBuilder.updateSettings(closeSettings, indices);
                }
                ClusterState updatedState = ClusterState.builder(currentState).metaData(metaDataBuilder).routingTable(routingTableBuilder).blocks(blocks).build();
                RoutingAllocation.Result routingResult = MetaDataUpdateSettingsService.this.allocationService.reroute(updatedState);
                updatedState = ClusterState.builder(updatedState).routingResult(routingResult).build();
                return updatedState;
            }
        });
    }
}

