/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.termvector;

import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.apache.lucene.index.DocsAndPositionsEnum;
import org.apache.lucene.index.DocsEnum;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.action.termvector.TermVectorRequest;
import org.elasticsearch.action.termvector.TermVectorResponse;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.BytesStreamOutput;

final class TermVectorWriter {
    final List<String> fields = new ArrayList<String>();
    final List<Long> fieldOffset = new ArrayList<Long>();
    final BytesStreamOutput output = new BytesStreamOutput(1);
    private static final String HEADER = "TV";
    private static final int CURRENT_VERSION = -1;
    TermVectorResponse response = null;

    TermVectorWriter(TermVectorResponse termVectorResponse) throws IOException {
        this.response = termVectorResponse;
    }

    void setFields(Fields termVectorsByField, Set<String> selectedFields, EnumSet<TermVectorRequest.Flag> flags, Fields topLevelFields) throws IOException {
        int numFieldsWritten = 0;
        TermsEnum iterator = null;
        DocsAndPositionsEnum docsAndPosEnum = null;
        DocsEnum docsEnum = null;
        TermsEnum topLevelIterator = null;
        for (String field : termVectorsByField) {
            boolean useDocsAndPos;
            if (selectedFields != null && !selectedFields.contains(field)) continue;
            Terms fieldTermVector = termVectorsByField.terms(field);
            Terms topLevelTerms = topLevelFields.terms(field);
            if (topLevelTerms == null) {
                topLevelTerms = fieldTermVector;
            }
            topLevelIterator = topLevelTerms.iterator(topLevelIterator);
            boolean positions = flags.contains((Object)TermVectorRequest.Flag.Positions) && fieldTermVector.hasPositions();
            boolean offsets = flags.contains((Object)TermVectorRequest.Flag.Offsets) && fieldTermVector.hasOffsets();
            boolean payloads = flags.contains((Object)TermVectorRequest.Flag.Payloads) && fieldTermVector.hasPayloads();
            this.startField(field, fieldTermVector.size(), positions, offsets, payloads);
            if (flags.contains((Object)TermVectorRequest.Flag.FieldStatistics)) {
                this.writeFieldStatistics(topLevelTerms);
            }
            iterator = fieldTermVector.iterator(iterator);
            boolean bl = useDocsAndPos = positions || offsets || payloads;
            while (iterator.next() != null) {
                BytesRef term = iterator.term();
                boolean foundTerm = topLevelIterator.seekExact(term);
                this.startTerm(term);
                if (flags.contains((Object)TermVectorRequest.Flag.TermStatistics)) {
                    if (foundTerm) {
                        this.writeTermStatistics(topLevelIterator);
                    } else {
                        this.writeEmptyTermStatistics();
                    }
                }
                if (useDocsAndPos) {
                    docsAndPosEnum = this.writeTermWithDocsAndPos(iterator, docsAndPosEnum, positions, offsets, payloads);
                    continue;
                }
                docsEnum = this.writeTermWithDocsOnly(iterator, docsEnum);
            }
            ++numFieldsWritten;
        }
        this.response.setTermVectorField(this.output);
        this.response.setHeader(this.writeHeader(numFieldsWritten, flags.contains((Object)TermVectorRequest.Flag.TermStatistics), flags.contains((Object)TermVectorRequest.Flag.FieldStatistics)));
    }

    private BytesReference writeHeader(int numFieldsWritten, boolean getTermStatistics, boolean getFieldStatistics) throws IOException {
        BytesStreamOutput header = new BytesStreamOutput();
        header.writeString(HEADER);
        header.writeInt(-1);
        header.writeBoolean(getTermStatistics);
        header.writeBoolean(getFieldStatistics);
        header.writeVInt(numFieldsWritten);
        for (int i = 0; i < this.fields.size(); ++i) {
            header.writeString(this.fields.get(i));
            header.writeVLong(this.fieldOffset.get(i));
        }
        header.close();
        return header.bytes();
    }

    private DocsEnum writeTermWithDocsOnly(TermsEnum iterator, DocsEnum docsEnum) throws IOException {
        docsEnum = iterator.docs(null, docsEnum);
        int nextDoc = docsEnum.nextDoc();
        assert (nextDoc != Integer.MAX_VALUE);
        this.writeFreq(docsEnum.freq());
        nextDoc = docsEnum.nextDoc();
        assert (nextDoc == Integer.MAX_VALUE);
        return docsEnum;
    }

    private DocsAndPositionsEnum writeTermWithDocsAndPos(TermsEnum iterator, DocsAndPositionsEnum docsAndPosEnum, boolean positions, boolean offsets, boolean payloads) throws IOException {
        docsAndPosEnum = iterator.docsAndPositions(null, docsAndPosEnum);
        int nextDoc = docsAndPosEnum.nextDoc();
        assert (nextDoc != Integer.MAX_VALUE);
        int freq = docsAndPosEnum.freq();
        this.writeFreq(freq);
        for (int j = 0; j < freq; ++j) {
            int curPos = docsAndPosEnum.nextPosition();
            if (positions) {
                this.writePosition(curPos);
            }
            if (offsets) {
                this.writeOffsets(docsAndPosEnum.startOffset(), docsAndPosEnum.endOffset());
            }
            if (!payloads) continue;
            this.writePayload(docsAndPosEnum.getPayload());
        }
        nextDoc = docsAndPosEnum.nextDoc();
        assert (nextDoc == Integer.MAX_VALUE);
        return docsAndPosEnum;
    }

    private void writePayload(BytesRef payload) throws IOException {
        if (payload != null) {
            this.output.writeVInt(payload.length);
            this.output.writeBytes(payload.bytes, payload.offset, payload.length);
        } else {
            this.output.writeVInt(0);
        }
    }

    private void writeFreq(int termFreq) throws IOException {
        this.writePotentiallyNegativeVInt(termFreq);
    }

    private void writeOffsets(int startOffset, int endOffset) throws IOException {
        assert (startOffset >= 0);
        assert (endOffset >= 0);
        if (startOffset >= 0 && endOffset >= 0) {
            this.output.writeVInt(startOffset);
            this.output.writeVInt(endOffset);
        }
    }

    private void writePosition(int pos) throws IOException {
        assert (pos >= 0);
        if (pos >= 0) {
            this.output.writeVInt(pos);
        }
    }

    private void startField(String fieldName, long termsSize, boolean writePositions, boolean writeOffsets, boolean writePayloads) throws IOException {
        this.fields.add(fieldName);
        this.fieldOffset.add(this.output.position());
        this.output.writeVLong(termsSize);
        this.output.writeBoolean(writePositions);
        this.output.writeBoolean(writeOffsets);
        this.output.writeBoolean(writePayloads);
    }

    private void startTerm(BytesRef term) throws IOException {
        this.output.writeVInt(term.length);
        this.output.writeBytes(term.bytes, term.offset, term.length);
    }

    private void writeTermStatistics(TermsEnum topLevelIterator) throws IOException {
        int docFreq = topLevelIterator.docFreq();
        assert (docFreq >= -1);
        this.writePotentiallyNegativeVInt(docFreq);
        long ttf = topLevelIterator.totalTermFreq();
        assert (ttf >= -1L);
        this.writePotentiallyNegativeVLong(ttf);
    }

    private void writeEmptyTermStatistics() throws IOException {
        this.writePotentiallyNegativeVInt(0);
        this.writePotentiallyNegativeVLong(0L);
    }

    private void writeFieldStatistics(Terms topLevelTerms) throws IOException {
        long sttf = topLevelTerms.getSumTotalTermFreq();
        assert (sttf >= -1L);
        this.writePotentiallyNegativeVLong(sttf);
        long sdf = topLevelTerms.getSumDocFreq();
        assert (sdf >= -1L);
        this.writePotentiallyNegativeVLong(sdf);
        int dc = topLevelTerms.getDocCount();
        assert (dc >= -1);
        this.writePotentiallyNegativeVInt(dc);
    }

    private void writePotentiallyNegativeVInt(int value) throws IOException {
        this.output.writeVInt(Math.max(0, value + 1));
    }

    private void writePotentiallyNegativeVLong(long value) throws IOException {
        this.output.writeVLong(Math.max(0L, value + 1L));
    }
}

