/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.master;

import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.action.support.master.MasterNodeOperationRequest;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateObserver;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.discovery.MasterNotDiscoveredException;
import org.elasticsearch.node.NodeClosedException;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.BaseTransportRequestHandler;
import org.elasticsearch.transport.BaseTransportResponseHandler;
import org.elasticsearch.transport.ConnectTransportException;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportService;

public abstract class TransportMasterNodeOperationAction<Request extends MasterNodeOperationRequest, Response extends ActionResponse>
extends TransportAction<Request, Response> {
    protected final TransportService transportService;
    protected final ClusterService clusterService;
    final String executor;

    protected TransportMasterNodeOperationAction(Settings settings, String actionName, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters) {
        super(settings, actionName, threadPool, actionFilters);
        this.transportService = transportService;
        this.clusterService = clusterService;
        this.executor = this.executor();
        transportService.registerHandler(actionName, new TransportHandler());
    }

    protected abstract String executor();

    protected abstract Request newRequest();

    protected abstract Response newResponse();

    protected abstract void masterOperation(Request var1, ClusterState var2, ActionListener<Response> var3) throws ElasticsearchException;

    protected boolean localExecute(Request request) {
        return false;
    }

    protected abstract ClusterBlockException checkBlock(Request var1, ClusterState var2);

    protected void processBeforeDelegationToMaster(Request request, ClusterState state) {
    }

    @Override
    protected boolean forceThreadedListener() {
        return true;
    }

    @Override
    protected void doExecute(Request request, ActionListener<Response> listener) {
        this.innerExecute(request, listener, new ClusterStateObserver(this.clusterService, ((MasterNodeOperationRequest)request).masterNodeTimeout(), this.logger), false);
    }

    private void innerExecute(Request request, final ActionListener<Response> listener, final ClusterStateObserver observer, boolean retrying) {
        ClusterState clusterState = observer.observedState();
        final DiscoveryNodes nodes = clusterState.nodes();
        if (nodes.localNodeMaster() || this.localExecute(request)) {
            ClusterBlockException blockException = this.checkBlock(request, clusterState);
            if (blockException != null) {
                if (!blockException.retryable()) {
                    listener.onFailure(blockException);
                    return;
                }
                this.logger.trace("can't execute due to a cluster block: [{}], retrying", blockException, new Object[0]);
                observer.waitForNextChange(new ClusterStateObserver.Listener((MasterNodeOperationRequest)request, listener, observer, blockException){
                    final /* synthetic */ MasterNodeOperationRequest val$request;
                    final /* synthetic */ ActionListener val$listener;
                    final /* synthetic */ ClusterStateObserver val$observer;
                    final /* synthetic */ ClusterBlockException val$blockException;
                    {
                        this.val$request = masterNodeOperationRequest;
                        this.val$listener = actionListener;
                        this.val$observer = clusterStateObserver;
                        this.val$blockException = clusterBlockException;
                    }

                    @Override
                    public void onNewClusterState(ClusterState state) {
                        TransportMasterNodeOperationAction.this.innerExecute(this.val$request, this.val$listener, this.val$observer, false);
                    }

                    @Override
                    public void onClusterServiceClose() {
                        this.val$listener.onFailure(this.val$blockException);
                    }

                    @Override
                    public void onTimeout(TimeValue timeout) {
                        this.val$listener.onFailure(this.val$blockException);
                    }
                }, new ClusterStateObserver.ValidationPredicate((MasterNodeOperationRequest)request){
                    final /* synthetic */ MasterNodeOperationRequest val$request;
                    {
                        this.val$request = masterNodeOperationRequest;
                    }

                    @Override
                    protected boolean validate(ClusterState newState) {
                        ClusterBlockException blockException = TransportMasterNodeOperationAction.this.checkBlock(this.val$request, newState);
                        return blockException == null || !blockException.retryable();
                    }
                });
            } else {
                try {
                    this.threadPool.executor(this.executor).execute(new Runnable((MasterNodeOperationRequest)request, listener){
                        final /* synthetic */ MasterNodeOperationRequest val$request;
                        final /* synthetic */ ActionListener val$listener;
                        {
                            this.val$request = masterNodeOperationRequest;
                            this.val$listener = actionListener;
                        }

                        @Override
                        public void run() {
                            try {
                                TransportMasterNodeOperationAction.this.masterOperation(this.val$request, TransportMasterNodeOperationAction.this.clusterService.state(), this.val$listener);
                            }
                            catch (Throwable e) {
                                this.val$listener.onFailure(e);
                            }
                        }
                    });
                }
                catch (Throwable t) {
                    listener.onFailure(t);
                }
            }
        } else {
            if (nodes.masterNode() == null) {
                if (retrying) {
                    listener.onFailure(new MasterNotDiscoveredException());
                } else {
                    this.logger.debug("no known master node, scheduling a retry", new Object[0]);
                    observer.waitForNextChange(new ClusterStateObserver.Listener((MasterNodeOperationRequest)request, listener, observer){
                        final /* synthetic */ MasterNodeOperationRequest val$request;
                        final /* synthetic */ ActionListener val$listener;
                        final /* synthetic */ ClusterStateObserver val$observer;
                        {
                            this.val$request = masterNodeOperationRequest;
                            this.val$listener = actionListener;
                            this.val$observer = clusterStateObserver;
                        }

                        @Override
                        public void onNewClusterState(ClusterState state) {
                            TransportMasterNodeOperationAction.this.innerExecute(this.val$request, this.val$listener, this.val$observer, true);
                        }

                        @Override
                        public void onClusterServiceClose() {
                            this.val$listener.onFailure(new NodeClosedException(TransportMasterNodeOperationAction.this.clusterService.localNode()));
                        }

                        @Override
                        public void onTimeout(TimeValue timeout) {
                            this.val$listener.onFailure(new MasterNotDiscoveredException("waited for [" + timeout + "]"));
                        }
                    }, new ClusterStateObserver.ChangePredicate(){

                        @Override
                        public boolean apply(ClusterState previousState, ClusterState.ClusterStateStatus previousStatus, ClusterState newState, ClusterState.ClusterStateStatus newStatus) {
                            return newState.nodes().masterNodeId() != null;
                        }

                        @Override
                        public boolean apply(ClusterChangedEvent event) {
                            return event.nodesDelta().masterNodeChanged();
                        }
                    });
                }
                return;
            }
            this.processBeforeDelegationToMaster(request, clusterState);
            this.transportService.sendRequest(nodes.masterNode(), this.actionName, (TransportRequest)request, new BaseTransportResponseHandler<Response>((MasterNodeOperationRequest)request){
                final /* synthetic */ MasterNodeOperationRequest val$request;
                {
                    this.val$request = masterNodeOperationRequest;
                }

                @Override
                public Response newInstance() {
                    return TransportMasterNodeOperationAction.this.newResponse();
                }

                @Override
                public void handleResponse(Response response) {
                    listener.onResponse(response);
                }

                @Override
                public String executor() {
                    return "same";
                }

                @Override
                public void handleException(TransportException exp) {
                    if (exp.unwrapCause() instanceof ConnectTransportException) {
                        TransportMasterNodeOperationAction.this.logger.debug("connection exception while trying to forward request to master node [{}], scheduling a retry. Error: [{}]", nodes.masterNode(), exp.getDetailedMessage());
                        observer.waitForNextChange(new ClusterStateObserver.Listener(){

                            @Override
                            public void onNewClusterState(ClusterState state) {
                                TransportMasterNodeOperationAction.this.innerExecute(val$request, listener, observer, false);
                            }

                            @Override
                            public void onClusterServiceClose() {
                                listener.onFailure(new NodeClosedException(TransportMasterNodeOperationAction.this.clusterService.localNode()));
                            }

                            @Override
                            public void onTimeout(TimeValue timeout) {
                                listener.onFailure(new MasterNotDiscoveredException());
                            }
                        }, new ClusterStateObserver.EventPredicate(){

                            @Override
                            public boolean apply(ClusterChangedEvent event) {
                                return event.nodesDelta().masterNodeChanged();
                            }
                        });
                    } else {
                        listener.onFailure(exp);
                    }
                }
            });
        }
    }

    private class TransportHandler
    extends BaseTransportRequestHandler<Request> {
        private TransportHandler() {
        }

        @Override
        public Request newInstance() {
            return TransportMasterNodeOperationAction.this.newRequest();
        }

        @Override
        public String executor() {
            return "same";
        }

        @Override
        public void messageReceived(Request request, final TransportChannel channel) throws Exception {
            ((ActionRequest)request).listenerThreaded(false);
            TransportMasterNodeOperationAction.this.execute(request, new ActionListener<Response>(){

                @Override
                public void onResponse(Response response) {
                    try {
                        channel.sendResponse((TransportResponse)response);
                    }
                    catch (Throwable e) {
                        this.onFailure(e);
                    }
                }

                @Override
                public void onFailure(Throwable e) {
                    try {
                        channel.sendResponse(e);
                    }
                    catch (Exception e1) {
                        TransportMasterNodeOperationAction.this.logger.warn("Failed to send response", e1, new Object[0]);
                    }
                }
            });
        }
    }
}

