/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.highlight;

import java.util.Set;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.search.highlight.Highlighter;

public class Highlighters {
    private final ImmutableMap<String, Highlighter> parsers;

    @Inject
    public Highlighters(Set<Highlighter> parsers) {
        MapBuilder<String, Highlighter> builder = MapBuilder.newMapBuilder();
        for (Highlighter parser : parsers) {
            for (String type : parser.names()) {
                builder.put(type, parser);
            }
        }
        this.parsers = builder.immutableMap();
    }

    public Highlighter get(String type) {
        return this.parsers.get(type);
    }
}

