/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.significant;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.elasticsearch.Version;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.text.StringText;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.aggregations.AggregationStreams;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.bucket.significant.InternalSignificantTerms;
import org.elasticsearch.search.aggregations.bucket.significant.SignificantTerms;
import org.elasticsearch.search.aggregations.bucket.significant.heuristics.SignificanceHeuristic;
import org.elasticsearch.search.aggregations.bucket.significant.heuristics.SignificanceHeuristicStreams;
import org.elasticsearch.search.aggregations.support.format.ValueFormatter;
import org.elasticsearch.search.aggregations.support.format.ValueFormatterStreams;

public class SignificantLongTerms
extends InternalSignificantTerms {
    public static final InternalAggregation.Type TYPE = new InternalAggregation.Type("significant_terms", "siglterms");
    public static final AggregationStreams.Stream STREAM = new AggregationStreams.Stream(){

        @Override
        public SignificantLongTerms readResult(StreamInput in) throws IOException {
            SignificantLongTerms buckets = new SignificantLongTerms();
            buckets.readFrom(in);
            return buckets;
        }
    };
    private ValueFormatter formatter;

    public static void registerStreams() {
        AggregationStreams.registerStream(STREAM, TYPE.stream());
    }

    SignificantLongTerms() {
    }

    public SignificantLongTerms(long subsetSize, long supersetSize, String name, @Nullable ValueFormatter formatter, int requiredSize, long minDocCount, SignificanceHeuristic significanceHeuristic, Collection<InternalSignificantTerms.Bucket> buckets) {
        super(subsetSize, supersetSize, name, requiredSize, minDocCount, significanceHeuristic, buckets);
        this.formatter = formatter;
    }

    @Override
    public InternalAggregation.Type type() {
        return TYPE;
    }

    @Override
    InternalSignificantTerms newAggregation(long subsetSize, long supersetSize, List<InternalSignificantTerms.Bucket> buckets) {
        return new SignificantLongTerms(subsetSize, supersetSize, this.getName(), this.formatter, this.requiredSize, this.minDocCount, this.significanceHeuristic, buckets);
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.name = in.readString();
        this.formatter = ValueFormatterStreams.readOptional(in);
        this.requiredSize = SignificantLongTerms.readSize(in);
        this.minDocCount = in.readVLong();
        this.subsetSize = in.readVLong();
        this.supersetSize = in.readVLong();
        this.significanceHeuristic = SignificanceHeuristicStreams.read(in);
        int size = in.readVInt();
        ArrayList<Bucket> buckets = new ArrayList<Bucket>(size);
        for (int i = 0; i < size; ++i) {
            long subsetDf = in.readVLong();
            long supersetDf = in.readVLong();
            long term = in.readLong();
            Bucket readBucket = new Bucket(subsetDf, this.subsetSize, supersetDf, this.supersetSize, term, InternalAggregations.readAggregations(in));
            readBucket.updateScore(this.significanceHeuristic);
            buckets.add(readBucket);
        }
        this.buckets = buckets;
        this.bucketMap = null;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        ValueFormatterStreams.writeOptional(this.formatter, out);
        SignificantLongTerms.writeSize(this.requiredSize, out);
        out.writeVLong(this.minDocCount);
        out.writeVLong(this.subsetSize);
        out.writeVLong(this.supersetSize);
        if (out.getVersion().onOrAfter(Version.V_1_3_0)) {
            this.significanceHeuristic.writeTo(out);
        }
        out.writeVInt(this.buckets.size());
        for (InternalSignificantTerms.Bucket bucket : this.buckets) {
            out.writeVLong(((Bucket)bucket).subsetDf);
            out.writeVLong(((Bucket)bucket).supersetDf);
            out.writeLong(((Bucket)bucket).term);
            ((InternalAggregations)bucket.getAggregations()).writeTo(out);
        }
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("doc_count", this.subsetSize);
        builder.startArray(InternalAggregation.CommonFields.BUCKETS);
        for (InternalSignificantTerms.Bucket bucket : this.buckets) {
            builder.startObject();
            builder.field(InternalAggregation.CommonFields.KEY, ((Bucket)bucket).term);
            if (this.formatter != null) {
                builder.field(InternalAggregation.CommonFields.KEY_AS_STRING, this.formatter.format(((Bucket)bucket).term));
            }
            builder.field(InternalAggregation.CommonFields.DOC_COUNT, bucket.getDocCount());
            builder.field("score", bucket.score);
            builder.field("bg_count", bucket.supersetDf);
            ((InternalAggregations)bucket.getAggregations()).toXContentInternal(builder, params);
            builder.endObject();
        }
        builder.endArray();
        return builder;
    }

    static class Bucket
    extends InternalSignificantTerms.Bucket {
        long term;

        public Bucket(long subsetDf, long subsetSize, long supersetDf, long supersetSize, long term, InternalAggregations aggregations) {
            super(subsetDf, subsetSize, supersetDf, supersetSize, aggregations);
            this.term = term;
        }

        @Override
        public Text getKeyAsText() {
            return new StringText(String.valueOf(this.term));
        }

        @Override
        public Number getKeyAsNumber() {
            return this.term;
        }

        @Override
        int compareTerm(SignificantTerms.Bucket other) {
            return Long.compare(this.term, other.getKeyAsNumber().longValue());
        }

        @Override
        public String getKey() {
            return Long.toString(this.term);
        }

        @Override
        Bucket newBucket(long subsetDf, long subsetSize, long supersetDf, long supersetSize, InternalAggregations aggregations) {
            return new Bucket(subsetDf, subsetSize, supersetDf, supersetSize, this.term, aggregations);
        }
    }
}

