/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices;

import org.elasticsearch.action.update.UpdateHelper;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.inject.AbstractModule;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.inject.SpawnModules;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.indices.IndicesLifecycle;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.InternalIndicesLifecycle;
import org.elasticsearch.indices.InternalIndicesService;
import org.elasticsearch.indices.analysis.IndicesAnalysisModule;
import org.elasticsearch.indices.cache.filter.IndicesFilterCache;
import org.elasticsearch.indices.cache.filter.terms.IndicesTermsFilterCache;
import org.elasticsearch.indices.cache.query.IndicesQueryCache;
import org.elasticsearch.indices.cluster.IndicesClusterStateService;
import org.elasticsearch.indices.fielddata.cache.IndicesFieldDataCache;
import org.elasticsearch.indices.fielddata.cache.IndicesFieldDataCacheListener;
import org.elasticsearch.indices.memory.IndexingMemoryController;
import org.elasticsearch.indices.query.IndicesQueriesModule;
import org.elasticsearch.indices.recovery.RecoverySettings;
import org.elasticsearch.indices.recovery.RecoverySource;
import org.elasticsearch.indices.recovery.RecoveryTarget;
import org.elasticsearch.indices.store.IndicesStore;
import org.elasticsearch.indices.store.TransportNodesListShardStoreMetaData;
import org.elasticsearch.indices.ttl.IndicesTTLService;
import org.elasticsearch.indices.warmer.IndicesWarmer;
import org.elasticsearch.indices.warmer.InternalIndicesWarmer;

public class IndicesModule
extends AbstractModule
implements SpawnModules {
    private final Settings settings;

    public IndicesModule(Settings settings) {
        this.settings = settings;
    }

    @Override
    public Iterable<? extends Module> spawnModules() {
        return ImmutableList.of(new IndicesQueriesModule(), new IndicesAnalysisModule());
    }

    @Override
    protected void configure() {
        this.bind(IndicesLifecycle.class).to(InternalIndicesLifecycle.class).asEagerSingleton();
        this.bind(IndicesService.class).to(InternalIndicesService.class).asEagerSingleton();
        this.bind(RecoverySettings.class).asEagerSingleton();
        this.bind(RecoveryTarget.class).asEagerSingleton();
        this.bind(RecoverySource.class).asEagerSingleton();
        this.bind(IndicesStore.class).asEagerSingleton();
        this.bind(IndicesClusterStateService.class).asEagerSingleton();
        this.bind(IndexingMemoryController.class).asEagerSingleton();
        this.bind(IndicesFilterCache.class).asEagerSingleton();
        this.bind(IndicesQueryCache.class).asEagerSingleton();
        this.bind(IndicesFieldDataCache.class).asEagerSingleton();
        this.bind(IndicesTermsFilterCache.class).asEagerSingleton();
        this.bind(TransportNodesListShardStoreMetaData.class).asEagerSingleton();
        this.bind(IndicesTTLService.class).asEagerSingleton();
        this.bind(IndicesWarmer.class).to(InternalIndicesWarmer.class).asEagerSingleton();
        this.bind(UpdateHelper.class).asEagerSingleton();
        this.bind(IndicesFieldDataCacheListener.class).asEagerSingleton();
    }
}

