/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.Locale;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.queryparser.classic.MapperQueryParser;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.queryparser.classic.QueryParserSettings;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.hppc.ObjectFloatOpenHashMap;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.Fuzziness;
import org.elasticsearch.common.util.LocaleUtils;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParser;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.index.query.support.QueryParsers;

public class QueryStringQueryParser
implements QueryParser {
    public static final String NAME = "query_string";
    private static final ParseField FUZZINESS = Fuzziness.FIELD.withDeprecation("fuzzy_min_sim");
    private final boolean defaultAnalyzeWildcard;
    private final boolean defaultAllowLeadingWildcard;

    @Inject
    public QueryStringQueryParser(Settings settings) {
        this.defaultAnalyzeWildcard = settings.getAsBoolean("indices.query.query_string.analyze_wildcard", (Boolean)false);
        this.defaultAllowLeadingWildcard = settings.getAsBoolean("indices.query.query_string.allowLeadingWildcard", (Boolean)true);
    }

    @Override
    public String[] names() {
        return new String[]{NAME, Strings.toCamelCase(NAME)};
    }

    @Override
    public Query parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        String queryName = null;
        QueryParserSettings qpSettings = new QueryParserSettings();
        qpSettings.defaultField(parseContext.defaultField());
        qpSettings.lenient(parseContext.queryStringLenient());
        qpSettings.analyzeWildcard(this.defaultAnalyzeWildcard);
        qpSettings.allowLeadingWildcard(this.defaultAllowLeadingWildcard);
        qpSettings.locale(Locale.ROOT);
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            NamedAnalyzer analyzer;
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_ARRAY) {
                if ("fields".equals(currentFieldName)) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        String fField = null;
                        float fBoost = -1.0f;
                        char[] text = parser.textCharacters();
                        int end = parser.textOffset() + parser.textLength();
                        for (int i = parser.textOffset(); i < end; ++i) {
                            if (text[i] != '^') continue;
                            int relativeLocation = i - parser.textOffset();
                            fField = new String(text, parser.textOffset(), relativeLocation);
                            fBoost = Float.parseFloat(new String(text, i + 1, parser.textLength() - relativeLocation - 1));
                            break;
                        }
                        if (fField == null) {
                            fField = parser.text();
                        }
                        if (qpSettings.fields() == null) {
                            qpSettings.fields(Lists.newArrayList());
                        }
                        if (Regex.isSimpleMatchPattern(fField)) {
                            for (String field : parseContext.mapperService().simpleMatchToIndexNames(fField)) {
                                qpSettings.fields().add(field);
                                if (fBoost == -1.0f) continue;
                                if (qpSettings.boosts() == null) {
                                    qpSettings.boosts(new ObjectFloatOpenHashMap<String>());
                                }
                                qpSettings.boosts().put(field, fBoost);
                            }
                            continue;
                        }
                        qpSettings.fields().add(fField);
                        if (fBoost == -1.0f) continue;
                        if (qpSettings.boosts() == null) {
                            qpSettings.boosts(new ObjectFloatOpenHashMap<String>());
                        }
                        qpSettings.boosts().put(fField, fBoost);
                    }
                    continue;
                }
                throw new QueryParsingException(parseContext.index(), "[query_string] query does not support [" + currentFieldName + "]");
            }
            if (!token.isValue()) continue;
            if ("query".equals(currentFieldName)) {
                qpSettings.queryString(parser.text());
                continue;
            }
            if ("default_field".equals(currentFieldName) || "defaultField".equals(currentFieldName)) {
                qpSettings.defaultField(parser.text());
                continue;
            }
            if ("default_operator".equals(currentFieldName) || "defaultOperator".equals(currentFieldName)) {
                String op = parser.text();
                if ("or".equalsIgnoreCase(op)) {
                    qpSettings.defaultOperator(QueryParser.Operator.OR);
                    continue;
                }
                if ("and".equalsIgnoreCase(op)) {
                    qpSettings.defaultOperator(QueryParser.Operator.AND);
                    continue;
                }
                throw new QueryParsingException(parseContext.index(), "Query default operator [" + op + "] is not allowed");
            }
            if ("analyzer".equals(currentFieldName)) {
                analyzer = parseContext.analysisService().analyzer(parser.text());
                if (analyzer == null) {
                    throw new QueryParsingException(parseContext.index(), "[query_string] analyzer [" + parser.text() + "] not found");
                }
                qpSettings.forcedAnalyzer((Analyzer)analyzer);
                continue;
            }
            if ("quote_analyzer".equals(currentFieldName) || "quoteAnalyzer".equals(currentFieldName)) {
                analyzer = parseContext.analysisService().analyzer(parser.text());
                if (analyzer == null) {
                    throw new QueryParsingException(parseContext.index(), "[query_string] quote_analyzer [" + parser.text() + "] not found");
                }
                qpSettings.forcedQuoteAnalyzer((Analyzer)analyzer);
                continue;
            }
            if ("allow_leading_wildcard".equals(currentFieldName) || "allowLeadingWildcard".equals(currentFieldName)) {
                qpSettings.allowLeadingWildcard(parser.booleanValue());
                continue;
            }
            if ("auto_generate_phrase_queries".equals(currentFieldName) || "autoGeneratePhraseQueries".equals(currentFieldName)) {
                qpSettings.autoGeneratePhraseQueries(parser.booleanValue());
                continue;
            }
            if ("max_determinized_states".equals(currentFieldName) || "maxDeterminizedStates".equals(currentFieldName)) {
                qpSettings.maxDeterminizedStates(parser.intValue());
                continue;
            }
            if ("lowercase_expanded_terms".equals(currentFieldName) || "lowercaseExpandedTerms".equals(currentFieldName)) {
                qpSettings.lowercaseExpandedTerms(parser.booleanValue());
                continue;
            }
            if ("enable_position_increments".equals(currentFieldName) || "enablePositionIncrements".equals(currentFieldName)) {
                qpSettings.enablePositionIncrements(parser.booleanValue());
                continue;
            }
            if ("escape".equals(currentFieldName)) {
                qpSettings.escape(parser.booleanValue());
                continue;
            }
            if ("use_dis_max".equals(currentFieldName) || "useDisMax".equals(currentFieldName)) {
                qpSettings.useDisMax(parser.booleanValue());
                continue;
            }
            if ("fuzzy_prefix_length".equals(currentFieldName) || "fuzzyPrefixLength".equals(currentFieldName)) {
                qpSettings.fuzzyPrefixLength(parser.intValue());
                continue;
            }
            if ("fuzzy_max_expansions".equals(currentFieldName) || "fuzzyMaxExpansions".equals(currentFieldName)) {
                qpSettings.fuzzyMaxExpansions(parser.intValue());
                continue;
            }
            if ("fuzzy_rewrite".equals(currentFieldName) || "fuzzyRewrite".equals(currentFieldName)) {
                qpSettings.fuzzyRewriteMethod(QueryParsers.parseRewriteMethod(parser.textOrNull()));
                continue;
            }
            if ("phrase_slop".equals(currentFieldName) || "phraseSlop".equals(currentFieldName)) {
                qpSettings.phraseSlop(parser.intValue());
                continue;
            }
            if (FUZZINESS.match(currentFieldName, parseContext.parseFlags())) {
                qpSettings.fuzzyMinSim(Fuzziness.parse(parser).asSimilarity());
                continue;
            }
            if ("boost".equals(currentFieldName)) {
                qpSettings.boost(parser.floatValue());
                continue;
            }
            if ("tie_breaker".equals(currentFieldName) || "tieBreaker".equals(currentFieldName)) {
                qpSettings.tieBreaker(parser.floatValue());
                continue;
            }
            if ("analyze_wildcard".equals(currentFieldName) || "analyzeWildcard".equals(currentFieldName)) {
                qpSettings.analyzeWildcard(parser.booleanValue());
                continue;
            }
            if ("rewrite".equals(currentFieldName)) {
                qpSettings.rewriteMethod(QueryParsers.parseRewriteMethod(parser.textOrNull()));
                continue;
            }
            if ("minimum_should_match".equals(currentFieldName) || "minimumShouldMatch".equals(currentFieldName)) {
                qpSettings.minimumShouldMatch(parser.textOrNull());
                continue;
            }
            if ("quote_field_suffix".equals(currentFieldName) || "quoteFieldSuffix".equals(currentFieldName)) {
                qpSettings.quoteFieldSuffix(parser.textOrNull());
                continue;
            }
            if ("lenient".equalsIgnoreCase(currentFieldName)) {
                qpSettings.lenient(parser.booleanValue());
                continue;
            }
            if ("locale".equals(currentFieldName)) {
                String localeStr = parser.text();
                qpSettings.locale(LocaleUtils.parse(localeStr));
                continue;
            }
            if ("_name".equals(currentFieldName)) {
                queryName = parser.text();
                continue;
            }
            throw new QueryParsingException(parseContext.index(), "[query_string] query does not support [" + currentFieldName + "]");
        }
        if (qpSettings.queryString() == null) {
            throw new QueryParsingException(parseContext.index(), "query_string must be provided with a [query]");
        }
        qpSettings.defaultAnalyzer(parseContext.mapperService().searchAnalyzer());
        qpSettings.defaultQuoteAnalyzer(parseContext.mapperService().searchQuoteAnalyzer());
        if (qpSettings.escape()) {
            qpSettings.queryString(org.apache.lucene.queryparser.classic.QueryParser.escape((String)qpSettings.queryString()));
        }
        qpSettings.queryTypes(parseContext.queryTypes());
        Query query = parseContext.queryParserCache().get(qpSettings);
        if (query != null) {
            if (queryName != null) {
                parseContext.addNamedQuery(queryName, query);
            }
            return query;
        }
        MapperQueryParser queryParser = parseContext.queryParser(qpSettings);
        try {
            query = queryParser.parse(qpSettings.queryString());
            if (query == null) {
                return null;
            }
            if (qpSettings.boost() != 1.0f) {
                query.setBoost(query.getBoost() * qpSettings.boost());
            }
            if ((query = Queries.fixNegativeQueryIfNeeded(query)) instanceof BooleanQuery) {
                Queries.applyMinimumShouldMatch((BooleanQuery)query, qpSettings.minimumShouldMatch());
            }
            parseContext.queryParserCache().put(qpSettings, query);
            if (queryName != null) {
                parseContext.addNamedQuery(queryName, query);
            }
            return query;
        }
        catch (ParseException e) {
            throw new QueryParsingException(parseContext.index(), "Failed to parse query [" + qpSettings.queryString() + "]", e);
        }
    }
}

