/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.hppc.ObjectFloatOpenHashMap;
import org.elasticsearch.common.unit.Fuzziness;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.BaseQueryBuilder;
import org.elasticsearch.index.query.BoostableQueryBuilder;

public class QueryStringQueryBuilder
extends BaseQueryBuilder
implements BoostableQueryBuilder<QueryStringQueryBuilder> {
    private final String queryString;
    private String defaultField;
    private Operator defaultOperator;
    private String analyzer;
    private String quoteAnalyzer;
    private String quoteFieldSuffix;
    private Boolean autoGeneratePhraseQueries;
    private Boolean allowLeadingWildcard;
    private Boolean lowercaseExpandedTerms;
    private Boolean enablePositionIncrements;
    private Boolean analyzeWildcard;
    private Locale locale;
    private float boost = -1.0f;
    private Fuzziness fuzziness;
    private int fuzzyPrefixLength = -1;
    private int fuzzyMaxExpansions = -1;
    private String fuzzyRewrite;
    private int phraseSlop = -1;
    private List<String> fields;
    private ObjectFloatOpenHashMap<String> fieldsBoosts;
    private Boolean useDisMax;
    private float tieBreaker = -1.0f;
    private String rewrite = null;
    private String minimumShouldMatch;
    private Boolean lenient;
    private String queryName;
    private Integer maxDeterminizedStates;

    public QueryStringQueryBuilder(String queryString) {
        this.queryString = queryString;
    }

    public QueryStringQueryBuilder defaultField(String defaultField) {
        this.defaultField = defaultField;
        return this;
    }

    public QueryStringQueryBuilder field(String field) {
        if (this.fields == null) {
            this.fields = Lists.newArrayList();
        }
        this.fields.add(field);
        return this;
    }

    public QueryStringQueryBuilder field(String field, float boost) {
        if (this.fields == null) {
            this.fields = Lists.newArrayList();
        }
        this.fields.add(field);
        if (this.fieldsBoosts == null) {
            this.fieldsBoosts = new ObjectFloatOpenHashMap();
        }
        this.fieldsBoosts.put(field, boost);
        return this;
    }

    public QueryStringQueryBuilder useDisMax(boolean useDisMax) {
        this.useDisMax = useDisMax;
        return this;
    }

    public QueryStringQueryBuilder tieBreaker(float tieBreaker) {
        this.tieBreaker = tieBreaker;
        return this;
    }

    public QueryStringQueryBuilder defaultOperator(Operator defaultOperator) {
        this.defaultOperator = defaultOperator;
        return this;
    }

    public QueryStringQueryBuilder analyzer(String analyzer) {
        this.analyzer = analyzer;
        return this;
    }

    public QueryStringQueryBuilder quoteAnalyzer(String analyzer) {
        this.quoteAnalyzer = analyzer;
        return this;
    }

    public QueryStringQueryBuilder autoGeneratePhraseQueries(boolean autoGeneratePhraseQueries) {
        this.autoGeneratePhraseQueries = autoGeneratePhraseQueries;
        return this;
    }

    public QueryStringQueryBuilder maxDeterminizedStates(int maxDeterminizedStates) {
        this.maxDeterminizedStates = maxDeterminizedStates;
        return this;
    }

    public QueryStringQueryBuilder allowLeadingWildcard(boolean allowLeadingWildcard) {
        this.allowLeadingWildcard = allowLeadingWildcard;
        return this;
    }

    public QueryStringQueryBuilder lowercaseExpandedTerms(boolean lowercaseExpandedTerms) {
        this.lowercaseExpandedTerms = lowercaseExpandedTerms;
        return this;
    }

    public QueryStringQueryBuilder enablePositionIncrements(boolean enablePositionIncrements) {
        this.enablePositionIncrements = enablePositionIncrements;
        return this;
    }

    public QueryStringQueryBuilder fuzziness(Fuzziness fuzziness) {
        this.fuzziness = fuzziness;
        return this;
    }

    public QueryStringQueryBuilder fuzzyPrefixLength(int fuzzyPrefixLength) {
        this.fuzzyPrefixLength = fuzzyPrefixLength;
        return this;
    }

    public QueryStringQueryBuilder fuzzyMaxExpansions(int fuzzyMaxExpansions) {
        this.fuzzyMaxExpansions = fuzzyMaxExpansions;
        return this;
    }

    public QueryStringQueryBuilder fuzzyRewrite(String fuzzyRewrite) {
        this.fuzzyRewrite = fuzzyRewrite;
        return this;
    }

    public QueryStringQueryBuilder phraseSlop(int phraseSlop) {
        this.phraseSlop = phraseSlop;
        return this;
    }

    public QueryStringQueryBuilder analyzeWildcard(boolean analyzeWildcard) {
        this.analyzeWildcard = analyzeWildcard;
        return this;
    }

    public QueryStringQueryBuilder rewrite(String rewrite) {
        this.rewrite = rewrite;
        return this;
    }

    public QueryStringQueryBuilder minimumShouldMatch(String minimumShouldMatch) {
        this.minimumShouldMatch = minimumShouldMatch;
        return this;
    }

    @Override
    public QueryStringQueryBuilder boost(float boost) {
        this.boost = boost;
        return this;
    }

    public QueryStringQueryBuilder quoteFieldSuffix(String quoteFieldSuffix) {
        this.quoteFieldSuffix = quoteFieldSuffix;
        return this;
    }

    public QueryStringQueryBuilder lenient(Boolean lenient) {
        this.lenient = lenient;
        return this;
    }

    public QueryStringQueryBuilder queryName(String queryName) {
        this.queryName = queryName;
        return this;
    }

    public QueryStringQueryBuilder locale(Locale locale) {
        this.locale = locale;
        return this;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("query_string");
        builder.field("query", this.queryString);
        if (this.defaultField != null) {
            builder.field("default_field", this.defaultField);
        }
        if (this.fields != null) {
            builder.startArray("fields");
            for (String field : this.fields) {
                if (this.fieldsBoosts != null && this.fieldsBoosts.containsKey(field)) {
                    field = field + "^" + this.fieldsBoosts.get(field);
                }
                builder.value(field);
            }
            builder.endArray();
        }
        if (this.useDisMax != null) {
            builder.field("use_dis_max", (Object)this.useDisMax);
        }
        if (this.tieBreaker != -1.0f) {
            builder.field("tie_breaker", this.tieBreaker);
        }
        if (this.defaultOperator != null) {
            builder.field("default_operator", this.defaultOperator.name().toLowerCase(Locale.ROOT));
        }
        if (this.analyzer != null) {
            builder.field("analyzer", this.analyzer);
        }
        if (this.quoteAnalyzer != null) {
            builder.field("quote_analyzer", this.quoteAnalyzer);
        }
        if (this.autoGeneratePhraseQueries != null) {
            builder.field("auto_generate_phrase_queries", (Object)this.autoGeneratePhraseQueries);
        }
        if (this.maxDeterminizedStates != null) {
            builder.field("max_determinized_states", this.maxDeterminizedStates);
        }
        if (this.allowLeadingWildcard != null) {
            builder.field("allow_leading_wildcard", (Object)this.allowLeadingWildcard);
        }
        if (this.lowercaseExpandedTerms != null) {
            builder.field("lowercase_expanded_terms", (Object)this.lowercaseExpandedTerms);
        }
        if (this.enablePositionIncrements != null) {
            builder.field("enable_position_increments", (Object)this.enablePositionIncrements);
        }
        if (this.fuzziness != null) {
            this.fuzziness.toXContent(builder, params);
        }
        if (this.boost != -1.0f) {
            builder.field("boost", this.boost);
        }
        if (this.fuzzyPrefixLength != -1) {
            builder.field("fuzzy_prefix_length", this.fuzzyPrefixLength);
        }
        if (this.fuzzyMaxExpansions != -1) {
            builder.field("fuzzy_max_expansions", this.fuzzyMaxExpansions);
        }
        if (this.fuzzyRewrite != null) {
            builder.field("fuzzy_rewrite", this.fuzzyRewrite);
        }
        if (this.phraseSlop != -1) {
            builder.field("phrase_slop", this.phraseSlop);
        }
        if (this.analyzeWildcard != null) {
            builder.field("analyze_wildcard", (Object)this.analyzeWildcard);
        }
        if (this.rewrite != null) {
            builder.field("rewrite", this.rewrite);
        }
        if (this.minimumShouldMatch != null) {
            builder.field("minimum_should_match", this.minimumShouldMatch);
        }
        if (this.quoteFieldSuffix != null) {
            builder.field("quote_field_suffix", this.quoteFieldSuffix);
        }
        if (this.lenient != null) {
            builder.field("lenient", (Object)this.lenient);
        }
        if (this.queryName != null) {
            builder.field("_name", this.queryName);
        }
        if (this.locale != null) {
            builder.field("locale", this.locale.toString());
        }
        builder.endObject();
    }

    public static enum Operator {
        OR,
        AND;

    }
}

