/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.search.XFilteredQuery;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.cache.fixedbitset.FixedBitSetFilter;
import org.elasticsearch.index.fielddata.plain.ParentChildIndexFieldData;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.internal.ParentFieldMapper;
import org.elasticsearch.index.query.FilterParser;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParserUtils;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.index.query.support.XContentStructure;
import org.elasticsearch.index.search.child.ChildrenConstantScoreQuery;
import org.elasticsearch.index.search.child.ChildrenQuery;
import org.elasticsearch.index.search.child.CustomQueryWrappingFilter;
import org.elasticsearch.index.search.child.ScoreType;
import org.elasticsearch.index.search.nested.NonNestedDocsFilter;

public class HasChildFilterParser
implements FilterParser {
    public static final String NAME = "has_child";

    @Inject
    public HasChildFilterParser() {
    }

    @Override
    public String[] names() {
        return new String[]{NAME, Strings.toCamelCase(NAME)};
    }

    @Override
    public Filter parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        XContentParser.Token token;
        QueryParserUtils.ensureNotDeleteByQuery(NAME, parseContext);
        XContentParser parser = parseContext.parser();
        boolean queryFound = false;
        boolean filterFound = false;
        String childType = null;
        int shortCircuitParentDocSet = 8192;
        int minChildren = 0;
        int maxChildren = 0;
        String filterName = null;
        String currentFieldName = null;
        XContentStructure.InnerQuery innerQuery = null;
        XContentStructure.InnerFilter innerFilter = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if ("query".equals(currentFieldName)) {
                    String[] stringArray;
                    if (childType == null) {
                        stringArray = null;
                    } else {
                        String[] stringArray2 = new String[1];
                        stringArray = stringArray2;
                        stringArray2[0] = childType;
                    }
                    innerQuery = new XContentStructure.InnerQuery(parseContext, stringArray);
                    queryFound = true;
                    continue;
                }
                if ("filter".equals(currentFieldName)) {
                    String[] stringArray;
                    if (childType == null) {
                        stringArray = null;
                    } else {
                        String[] stringArray3 = new String[1];
                        stringArray = stringArray3;
                        stringArray3[0] = childType;
                    }
                    innerFilter = new XContentStructure.InnerFilter(parseContext, stringArray);
                    filterFound = true;
                    continue;
                }
                throw new QueryParsingException(parseContext.index(), "[has_child] filter does not support [" + currentFieldName + "]");
            }
            if (!token.isValue()) continue;
            if ("type".equals(currentFieldName) || "child_type".equals(currentFieldName) || "childType".equals(currentFieldName)) {
                childType = parser.text();
                continue;
            }
            if ("_scope".equals(currentFieldName)) {
                throw new QueryParsingException(parseContext.index(), "the [_scope] support in [has_child] filter has been removed, use a filter as a facet_filter in the relevant global facet");
            }
            if ("_name".equals(currentFieldName)) {
                filterName = parser.text();
                continue;
            }
            if ("_cache".equals(currentFieldName) || "_cache_key".equals(currentFieldName) || "_cacheKey".equals(currentFieldName)) continue;
            if ("short_circuit_cutoff".equals(currentFieldName)) {
                shortCircuitParentDocSet = parser.intValue();
                continue;
            }
            if ("min_children".equals(currentFieldName) || "minChildren".equals(currentFieldName)) {
                minChildren = parser.intValue(true);
                continue;
            }
            if ("max_children".equals(currentFieldName) || "maxChildren".equals(currentFieldName)) {
                maxChildren = parser.intValue(true);
                continue;
            }
            throw new QueryParsingException(parseContext.index(), "[has_child] filter does not support [" + currentFieldName + "]");
        }
        if (!queryFound && !filterFound) {
            throw new QueryParsingException(parseContext.index(), "[has_child] filter requires 'query' or 'filter' field");
        }
        if (childType == null) {
            throw new QueryParsingException(parseContext.index(), "[has_child] filter requires 'type' field");
        }
        Query query = queryFound ? innerQuery.asQuery(childType) : innerFilter.asFilter(childType);
        if (query == null) {
            return null;
        }
        DocumentMapper childDocMapper = parseContext.mapperService().documentMapper(childType);
        if (childDocMapper == null) {
            throw new QueryParsingException(parseContext.index(), "No mapping for for type [" + childType + "]");
        }
        ParentFieldMapper parentFieldMapper = childDocMapper.parentFieldMapper();
        if (!parentFieldMapper.active()) {
            throw new QueryParsingException(parseContext.index(), "Type [" + childType + "] does not have parent mapping");
        }
        String parentType = parentFieldMapper.type();
        query = new XFilteredQuery(query, parseContext.cacheFilter(childDocMapper.typeFilter(), null));
        DocumentMapper parentDocMapper = parseContext.mapperService().documentMapper(parentType);
        if (parentDocMapper == null) {
            throw new QueryParsingException(parseContext.index(), "[has_child]  Type [" + childType + "] points to a non existent parent type [" + parentType + "]");
        }
        if (maxChildren > 0 && maxChildren < minChildren) {
            throw new QueryParsingException(parseContext.index(), "[has_child] 'max_children' is less than 'min_children'");
        }
        FixedBitSetFilter nonNestedDocsFilter = null;
        if (parentDocMapper.hasNestedObjects()) {
            nonNestedDocsFilter = parseContext.fixedBitSetFilter(NonNestedDocsFilter.INSTANCE);
        }
        Filter parentFilter = parseContext.cacheFilter(parentDocMapper.typeFilter(), null);
        ParentChildIndexFieldData parentChildIndexFieldData = (ParentChildIndexFieldData)parseContext.getForField(parentFieldMapper);
        Query childrenQuery = minChildren > 1 || maxChildren > 0 ? new ChildrenQuery(parentChildIndexFieldData, parentType, childType, parentFilter, query, ScoreType.NONE, minChildren, maxChildren, shortCircuitParentDocSet, nonNestedDocsFilter) : new ChildrenConstantScoreQuery(parentChildIndexFieldData, query, parentType, childType, parentFilter, shortCircuitParentDocSet, nonNestedDocsFilter);
        if (filterName != null) {
            parseContext.addNamedFilter(filterName, new CustomQueryWrappingFilter(childrenQuery));
        }
        return new CustomQueryWrappingFilter(childrenQuery);
    }
}

