/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.http.netty.pipelining;

import org.elasticsearch.common.netty.channel.Channel;
import org.elasticsearch.common.netty.channel.ChannelEvent;
import org.elasticsearch.common.netty.channel.ChannelFuture;
import org.elasticsearch.common.netty.channel.Channels;
import org.elasticsearch.common.netty.channel.DownstreamMessageEvent;
import org.elasticsearch.http.netty.pipelining.OrderedUpstreamMessageEvent;

public class OrderedDownstreamChannelEvent
implements ChannelEvent {
    final ChannelEvent ce;
    final OrderedUpstreamMessageEvent oue;
    final int subsequence;
    final boolean last;

    public OrderedDownstreamChannelEvent(OrderedUpstreamMessageEvent oue, int subsequence, boolean last, ChannelEvent ce) {
        this.oue = oue;
        this.ce = ce;
        this.subsequence = subsequence;
        this.last = last;
    }

    public OrderedDownstreamChannelEvent(OrderedUpstreamMessageEvent oe, Object message) {
        this(oe, 0, true, message);
    }

    public OrderedDownstreamChannelEvent(OrderedUpstreamMessageEvent oue, int subsequence, boolean last, Object message) {
        this(oue, subsequence, last, new DownstreamMessageEvent(oue.getChannel(), Channels.future(oue.getChannel()), message, oue.getRemoteAddress()));
    }

    public OrderedUpstreamMessageEvent getOrderedUpstreamMessageEvent() {
        return this.oue;
    }

    public int getSubsequence() {
        return this.subsequence;
    }

    public boolean isLast() {
        return this.last;
    }

    @Override
    public Channel getChannel() {
        return this.ce.getChannel();
    }

    @Override
    public ChannelFuture getFuture() {
        return this.ce.getFuture();
    }

    public ChannelEvent getChannelEvent() {
        return this.ce;
    }
}

