/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.termvector;

import java.io.IOException;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.lucene.index.DocsAndPositionsEnum;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRefBuilder;
import org.elasticsearch.ElasticsearchIllegalStateException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.termvector.TermVectorFields;
import org.elasticsearch.action.termvector.TermVectorRequest;
import org.elasticsearch.action.termvector.TermVectorWriter;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;

public class TermVectorResponse
extends ActionResponse
implements ToXContent {
    private BytesReference termVectors;
    private BytesReference headerRef;
    private String index;
    private String type;
    private String id;
    private long docVersion;
    private boolean exists = false;
    private boolean artificial = false;
    private boolean sourceCopied = false;
    int[] currentPositions = new int[0];
    int[] currentStartOffset = new int[0];
    int[] currentEndOffset = new int[0];
    BytesReference[] currentPayloads = new BytesReference[0];

    public TermVectorResponse(String index, String type, String id) {
        this.index = index;
        this.type = type;
        this.id = id;
    }

    TermVectorResponse() {
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.index);
        out.writeString(this.type);
        out.writeString(this.id);
        out.writeVLong(this.docVersion);
        boolean docExists = this.isExists();
        out.writeBoolean(docExists);
        if (out.getVersion().onOrAfter(Version.V_1_4_4)) {
            out.writeBoolean(this.artificial);
        }
        out.writeBoolean(this.hasTermVectors());
        if (this.hasTermVectors()) {
            out.writeBytesReference(this.headerRef);
            out.writeBytesReference(this.termVectors);
        }
    }

    private boolean hasTermVectors() {
        assert (this.headerRef == null && this.termVectors == null || this.headerRef != null && this.termVectors != null);
        return this.headerRef != null;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.index = in.readString();
        this.type = in.readString();
        this.id = in.readString();
        this.docVersion = in.readVLong();
        this.exists = in.readBoolean();
        if (in.getVersion().onOrAfter(Version.V_1_4_4)) {
            this.artificial = in.readBoolean();
        }
        if (in.readBoolean()) {
            this.headerRef = in.readBytesReference();
            this.termVectors = in.readBytesReference();
        }
    }

    public Fields getFields() throws IOException {
        if (this.hasTermVectors() && this.isExists()) {
            if (!this.sourceCopied) {
                this.headerRef = this.headerRef.copyBytesArray();
                this.termVectors = this.termVectors.copyBytesArray();
            }
            return new TermVectorFields(this.headerRef, this.termVectors);
        }
        return new Fields(){

            public Iterator<String> iterator() {
                return Iterators.emptyIterator();
            }

            public Terms terms(String field) throws IOException {
                return null;
            }

            public int size() {
                return 0;
            }
        };
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        assert (this.index != null);
        assert (this.type != null);
        assert (this.id != null);
        builder.field(FieldStrings._INDEX, this.index);
        builder.field(FieldStrings._TYPE, this.type);
        if (!this.isArtificial()) {
            builder.field(FieldStrings._ID, this.id);
        }
        builder.field(FieldStrings._VERSION, this.docVersion);
        builder.field(FieldStrings.FOUND, this.isExists());
        if (!this.isExists()) {
            return builder;
        }
        builder.startObject(FieldStrings.TERM_VECTORS);
        CharsRefBuilder spare = new CharsRefBuilder();
        Fields theFields = this.getFields();
        Iterator fieldIter = theFields.iterator();
        while (fieldIter.hasNext()) {
            this.buildField(builder, spare, theFields, fieldIter);
        }
        builder.endObject();
        return builder;
    }

    private void buildField(XContentBuilder builder, CharsRefBuilder spare, Fields theFields, Iterator<String> fieldIter) throws IOException {
        String fieldName = fieldIter.next();
        builder.startObject(fieldName);
        Terms curTerms = theFields.terms(fieldName);
        this.buildFieldStatistics(builder, curTerms);
        builder.startObject(FieldStrings.TERMS);
        TermsEnum termIter = curTerms.iterator(null);
        int i = 0;
        while ((long)i < curTerms.size()) {
            this.buildTerm(builder, spare, curTerms, termIter);
            ++i;
        }
        builder.endObject();
        builder.endObject();
    }

    private void buildTerm(XContentBuilder builder, CharsRefBuilder spare, Terms curTerms, TermsEnum termIter) throws IOException {
        BytesRef term = termIter.next();
        spare.copyUTF8Bytes(term);
        builder.startObject(spare.toString());
        this.buildTermStatistics(builder, termIter);
        DocsAndPositionsEnum posEnum = termIter.docsAndPositions(null, null);
        int termFreq = posEnum.freq();
        builder.field(FieldStrings.TERM_FREQ, termFreq);
        this.initMemory(curTerms, termFreq);
        this.initValues(curTerms, posEnum, termFreq);
        this.buildValues(builder, curTerms, termFreq);
        builder.endObject();
    }

    private void buildTermStatistics(XContentBuilder builder, TermsEnum termIter) throws IOException {
        assert (termIter.docFreq() > 0 && termIter.totalTermFreq() > 0L || termIter.docFreq() == -1 && termIter.totalTermFreq() == -1L);
        int docFreq = termIter.docFreq();
        if (docFreq > 0) {
            builder.field(FieldStrings.DOC_FREQ, docFreq);
            builder.field(FieldStrings.TTF, termIter.totalTermFreq());
        }
    }

    private void buildValues(XContentBuilder builder, Terms curTerms, int termFreq) throws IOException {
        if (!(curTerms.hasPayloads() || curTerms.hasOffsets() || curTerms.hasPositions())) {
            return;
        }
        builder.startArray(FieldStrings.TOKENS);
        for (int i = 0; i < termFreq; ++i) {
            builder.startObject();
            if (curTerms.hasPositions()) {
                builder.field(FieldStrings.POS, this.currentPositions[i]);
            }
            if (curTerms.hasOffsets()) {
                builder.field(FieldStrings.START_OFFSET, this.currentStartOffset[i]);
                builder.field(FieldStrings.END_OFFSET, this.currentEndOffset[i]);
            }
            if (curTerms.hasPayloads() && this.currentPayloads[i].length() > 0) {
                builder.field(FieldStrings.PAYLOAD, this.currentPayloads[i]);
            }
            builder.endObject();
        }
        builder.endArray();
    }

    private void initValues(Terms curTerms, DocsAndPositionsEnum posEnum, int termFreq) throws IOException {
        for (int j = 0; j < termFreq; ++j) {
            int nextPos = posEnum.nextPosition();
            if (curTerms.hasPositions()) {
                this.currentPositions[j] = nextPos;
            }
            if (curTerms.hasOffsets()) {
                this.currentStartOffset[j] = posEnum.startOffset();
                this.currentEndOffset[j] = posEnum.endOffset();
            }
            if (!curTerms.hasPayloads()) continue;
            BytesRef curPayload = posEnum.getPayload();
            this.currentPayloads[j] = curPayload != null ? new BytesArray(curPayload.bytes, 0, curPayload.length) : null;
        }
    }

    private void initMemory(Terms curTerms, int termFreq) {
        if (curTerms.hasPositions()) {
            this.currentPositions = ArrayUtil.grow((int[])this.currentPositions, (int)termFreq);
        }
        if (curTerms.hasOffsets()) {
            this.currentStartOffset = ArrayUtil.grow((int[])this.currentStartOffset, (int)termFreq);
            this.currentEndOffset = ArrayUtil.grow((int[])this.currentEndOffset, (int)termFreq);
        }
        if (curTerms.hasPayloads()) {
            this.currentPayloads = new BytesArray[termFreq];
        }
    }

    private void buildFieldStatistics(XContentBuilder builder, Terms curTerms) throws IOException {
        long sumDocFreq = curTerms.getSumDocFreq();
        int docCount = curTerms.getDocCount();
        long sumTotalTermFrequencies = curTerms.getSumTotalTermFreq();
        if (docCount > 0) {
            assert (sumDocFreq > 0L) : "docCount >= 0 but sumDocFreq ain't!";
            assert (sumTotalTermFrequencies > 0L) : "docCount >= 0 but sumTotalTermFrequencies ain't!";
            builder.startObject(FieldStrings.FIELD_STATISTICS);
            builder.field(FieldStrings.SUM_DOC_FREQ, sumDocFreq);
            builder.field(FieldStrings.DOC_COUNT, docCount);
            builder.field(FieldStrings.SUM_TTF, sumTotalTermFrequencies);
            builder.endObject();
        } else if (docCount == -1) {
            assert (sumDocFreq == -1L) : "docCount was -1 but sumDocFreq ain't!";
            assert (sumTotalTermFrequencies == -1L) : "docCount was -1 but sumTotalTermFrequencies ain't!";
        } else {
            throw new ElasticsearchIllegalStateException("Something is wrong with the field statistics of the term vector request: Values are \n" + FieldStrings.SUM_DOC_FREQ + " " + sumDocFreq + "\n" + FieldStrings.DOC_COUNT + " " + docCount + "\n" + FieldStrings.SUM_TTF + " " + sumTotalTermFrequencies);
        }
    }

    public boolean isExists() {
        return this.exists;
    }

    public void setExists(boolean exists) {
        this.exists = exists;
    }

    public void setFields(Fields termVectorsByField, Set<String> selectedFields, EnumSet<TermVectorRequest.Flag> flags, Fields topLevelFields) throws IOException {
        TermVectorWriter tvw = new TermVectorWriter(this);
        if (termVectorsByField != null) {
            tvw.setFields(termVectorsByField, selectedFields, flags, topLevelFields);
        }
    }

    public void setTermVectorField(BytesStreamOutput output) {
        this.termVectors = output.bytes();
    }

    public void setHeader(BytesReference header) {
        this.headerRef = header;
    }

    public void setDocVersion(long version) {
        this.docVersion = version;
    }

    public String getIndex() {
        return this.index;
    }

    public String getType() {
        return this.type;
    }

    public String getId() {
        return this.id;
    }

    public boolean isArtificial() {
        return this.artificial;
    }

    public void setArtificial(boolean artificial) {
        this.artificial = artificial;
    }

    private static class FieldStrings {
        public static final XContentBuilderString TTF = new XContentBuilderString("ttf");
        public static final XContentBuilderString DOC_FREQ = new XContentBuilderString("doc_freq");
        public static final XContentBuilderString TERM_FREQ = new XContentBuilderString("term_freq");
        public static final XContentBuilderString FIELD_STATISTICS = new XContentBuilderString("field_statistics");
        public static final XContentBuilderString DOC_COUNT = new XContentBuilderString("doc_count");
        public static final XContentBuilderString SUM_DOC_FREQ = new XContentBuilderString("sum_doc_freq");
        public static final XContentBuilderString SUM_TTF = new XContentBuilderString("sum_ttf");
        public static final XContentBuilderString TOKENS = new XContentBuilderString("tokens");
        public static final XContentBuilderString POS = new XContentBuilderString("position");
        public static final XContentBuilderString START_OFFSET = new XContentBuilderString("start_offset");
        public static final XContentBuilderString END_OFFSET = new XContentBuilderString("end_offset");
        public static final XContentBuilderString PAYLOAD = new XContentBuilderString("payload");
        public static final XContentBuilderString _INDEX = new XContentBuilderString("_index");
        public static final XContentBuilderString _TYPE = new XContentBuilderString("_type");
        public static final XContentBuilderString _ID = new XContentBuilderString("_id");
        public static final XContentBuilderString _VERSION = new XContentBuilderString("_version");
        public static final XContentBuilderString FOUND = new XContentBuilderString("found");
        public static final XContentBuilderString TERMS = new XContentBuilderString("terms");
        public static final XContentBuilderString TERM_VECTORS = new XContentBuilderString("term_vectors");

        private FieldStrings() {
        }
    }
}

