/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.warmer.delete;

import java.io.IOException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.CollectionUtils;

public class DeleteWarmerRequest
extends AcknowledgedRequest<DeleteWarmerRequest>
implements IndicesRequest.Replaceable {
    private String[] names = Strings.EMPTY_ARRAY;
    private IndicesOptions indicesOptions = IndicesOptions.fromOptions(false, false, true, false);
    private String[] indices = Strings.EMPTY_ARRAY;

    DeleteWarmerRequest() {
    }

    public DeleteWarmerRequest(String ... names) {
        this.names(names);
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        validationException = CollectionUtils.isEmpty(this.names) ? ValidateActions.addValidationError("warmer names are missing", validationException) : this.checkForEmptyString(validationException, this.names);
        validationException = CollectionUtils.isEmpty(this.indices) ? ValidateActions.addValidationError("indices are missing", validationException) : this.checkForEmptyString(validationException, this.indices);
        return validationException;
    }

    private ActionRequestValidationException checkForEmptyString(ActionRequestValidationException validationException, String[] strings) {
        boolean containsEmptyString = false;
        for (String string : strings) {
            if (Strings.hasText(string)) continue;
            containsEmptyString = true;
        }
        if (containsEmptyString) {
            validationException = ValidateActions.addValidationError("types must not contain empty strings", validationException);
        }
        return validationException;
    }

    @Nullable
    String[] names() {
        return this.names;
    }

    public DeleteWarmerRequest names(String ... names) {
        this.names = names;
        return this;
    }

    @Override
    public DeleteWarmerRequest indices(String ... indices) {
        this.indices = indices;
        return this;
    }

    @Override
    public String[] indices() {
        return this.indices;
    }

    @Override
    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    public DeleteWarmerRequest indicesOptions(IndicesOptions indicesOptions) {
        this.indicesOptions = indicesOptions;
        return this;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.names = in.readStringArray();
        this.indices = in.readStringArray();
        this.indicesOptions = IndicesOptions.readIndicesOptions(in);
        this.readTimeout(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringArrayNullable(this.names);
        out.writeStringArrayNullable(this.indices);
        this.indicesOptions.writeIndicesOptions(out);
        this.writeTimeout(out);
    }
}

