/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.alias;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesClusterStateUpdateRequest;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeOperationAction;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ack.ClusterStateUpdateResponse;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.AliasAction;
import org.elasticsearch.cluster.metadata.MetaDataIndexAliasesService;
import org.elasticsearch.common.collect.Sets;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.action.admin.indices.alias.delete.AliasesMissingException;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportIndicesAliasesAction
extends TransportMasterNodeOperationAction<IndicesAliasesRequest, IndicesAliasesResponse> {
    private final MetaDataIndexAliasesService indexAliasesService;

    @Inject
    public TransportIndicesAliasesAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, MetaDataIndexAliasesService indexAliasesService, ActionFilters actionFilters) {
        super(settings, "indices:admin/aliases", transportService, clusterService, threadPool, actionFilters);
        this.indexAliasesService = indexAliasesService;
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected IndicesAliasesRequest newRequest() {
        return new IndicesAliasesRequest();
    }

    @Override
    protected IndicesAliasesResponse newResponse() {
        return new IndicesAliasesResponse();
    }

    @Override
    protected ClusterBlockException checkBlock(IndicesAliasesRequest request, ClusterState state) {
        HashSet<String> indices = Sets.newHashSet();
        for (IndicesAliasesRequest.AliasActions aliasAction : request.aliasActions()) {
            for (String index : aliasAction.indices()) {
                indices.add(index);
            }
        }
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA, indices.toArray(new String[indices.size()]));
    }

    @Override
    protected void masterOperation(IndicesAliasesRequest request, ClusterState state, final ActionListener<IndicesAliasesResponse> listener) throws ElasticsearchException {
        List<IndicesAliasesRequest.AliasActions> actions = request.aliasActions();
        ArrayList<AliasAction> finalActions = new ArrayList<AliasAction>();
        boolean hasOnlyDeletesButNoneCanBeDone = true;
        HashSet<String> aliases = new HashSet<String>();
        for (IndicesAliasesRequest.AliasActions action : actions) {
            String[] concreteIndices = state.metaData().concreteIndices(request.indicesOptions(), action.indices());
            for (String alias : action.aliases()) {
                aliases.add(alias);
            }
            for (String index : concreteIndices) {
                for (String alias : action.concreteAliases(state.metaData(), index)) {
                    AliasAction finalAction = new AliasAction(action.aliasAction());
                    finalAction.index(index);
                    finalAction.alias(alias);
                    finalActions.add(finalAction);
                    hasOnlyDeletesButNoneCanBeDone = false;
                }
            }
        }
        if (hasOnlyDeletesButNoneCanBeDone && actions.size() != 0) {
            throw new AliasesMissingException(aliases.toArray(new String[aliases.size()]));
        }
        request.aliasActions().clear();
        IndicesAliasesClusterStateUpdateRequest updateRequest = ((IndicesAliasesClusterStateUpdateRequest)((IndicesAliasesClusterStateUpdateRequest)new IndicesAliasesClusterStateUpdateRequest().ackTimeout(request.timeout())).masterNodeTimeout(request.masterNodeTimeout())).actions(finalActions.toArray(new AliasAction[finalActions.size()]));
        this.indexAliasesService.indicesAliases(updateRequest, new ActionListener<ClusterStateUpdateResponse>(){

            @Override
            public void onResponse(ClusterStateUpdateResponse response) {
                listener.onResponse(new IndicesAliasesResponse(response.isAcknowledged()));
            }

            @Override
            public void onFailure(Throwable t) {
                TransportIndicesAliasesAction.this.logger.debug("failed to perform aliases", t, new Object[0]);
                listener.onFailure(t);
            }
        });
    }
}

