/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ScheduledFuture;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.watcher.ResourceWatcher;
import org.elasticsearch.watcher.WatcherHandle;

public class ResourceWatcherService
extends AbstractLifecycleComponent<ResourceWatcherService> {
    private final boolean enabled;
    private final ThreadPool threadPool;
    final ResourceMonitor lowMonitor;
    final ResourceMonitor mediumMonitor;
    final ResourceMonitor highMonitor;
    private volatile ScheduledFuture lowFuture;
    private volatile ScheduledFuture mediumFuture;
    private volatile ScheduledFuture highFuture;

    @Inject
    public ResourceWatcherService(Settings settings, ThreadPool threadPool) {
        super(settings);
        this.enabled = this.componentSettings.getAsBoolean("enabled", (Boolean)true);
        this.threadPool = threadPool;
        TimeValue interval = this.componentSettings.getAsTime("interval.low", Frequency.LOW.interval);
        this.lowMonitor = new ResourceMonitor(interval, Frequency.LOW);
        interval = this.componentSettings.getAsTime("interval.medium", this.componentSettings.getAsTime("interval", Frequency.MEDIUM.interval));
        this.mediumMonitor = new ResourceMonitor(interval, Frequency.MEDIUM);
        interval = this.componentSettings.getAsTime("interval.high", Frequency.HIGH.interval);
        this.highMonitor = new ResourceMonitor(interval, Frequency.HIGH);
    }

    @Override
    protected void doStart() throws ElasticsearchException {
        if (!this.enabled) {
            return;
        }
        this.lowFuture = this.threadPool.scheduleWithFixedDelay(this.lowMonitor, this.lowMonitor.interval);
        this.mediumFuture = this.threadPool.scheduleWithFixedDelay(this.mediumMonitor, this.mediumMonitor.interval);
        this.highFuture = this.threadPool.scheduleWithFixedDelay(this.highMonitor, this.highMonitor.interval);
    }

    @Override
    protected void doStop() throws ElasticsearchException {
        if (!this.enabled) {
            return;
        }
        this.lowFuture.cancel(true);
        this.mediumFuture.cancel(true);
        this.highFuture.cancel(true);
    }

    @Override
    protected void doClose() throws ElasticsearchException {
    }

    public <W extends ResourceWatcher> WatcherHandle<W> add(W watcher) {
        return this.add(watcher, Frequency.MEDIUM);
    }

    public <W extends ResourceWatcher> WatcherHandle<W> add(W watcher, Frequency frequency) {
        watcher.init();
        switch (frequency) {
            case LOW: {
                return this.lowMonitor.add(watcher);
            }
            case MEDIUM: {
                return this.mediumMonitor.add(watcher);
            }
            case HIGH: {
                return this.highMonitor.add(watcher);
            }
        }
        throw new ElasticsearchIllegalArgumentException("Unknown frequency [" + (Object)((Object)frequency) + "]");
    }

    public void notifyNow() {
        this.notifyNow(Frequency.MEDIUM);
    }

    public void notifyNow(Frequency frequency) {
        switch (frequency) {
            case LOW: {
                this.lowMonitor.run();
                break;
            }
            case MEDIUM: {
                this.mediumMonitor.run();
                break;
            }
            case HIGH: {
                this.highMonitor.run();
                break;
            }
            default: {
                throw new ElasticsearchIllegalArgumentException("Unknown frequency [" + (Object)((Object)frequency) + "]");
            }
        }
    }

    static class ResourceMonitor
    implements Runnable {
        final TimeValue interval;
        final Frequency frequency;
        final Set<ResourceWatcher> watchers = new CopyOnWriteArraySet<ResourceWatcher>();

        private ResourceMonitor(TimeValue interval, Frequency frequency) {
            this.interval = interval;
            this.frequency = frequency;
        }

        private <W extends ResourceWatcher> WatcherHandle<W> add(W watcher) {
            this.watchers.add(watcher);
            return new WatcherHandle<W>(this, watcher);
        }

        @Override
        public synchronized void run() {
            for (ResourceWatcher watcher : this.watchers) {
                watcher.checkAndNotify();
            }
        }
    }

    public static enum Frequency {
        HIGH(TimeValue.timeValueSeconds(5L)),
        MEDIUM(TimeValue.timeValueSeconds(25L)),
        LOW(TimeValue.timeValueSeconds(60L));

        final TimeValue interval;

        private Frequency(TimeValue interval) {
            this.interval = interval;
        }
    }
}

