/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics.scripted;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.aggregations.metrics.MetricsAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.scripted.InternalScriptedMetric;
import org.elasticsearch.search.aggregations.metrics.scripted.ScriptedMetricParser;

public class ScriptedMetricBuilder
extends MetricsAggregationBuilder {
    private Map<String, Object> params = null;
    private Map<String, Object> reduceParams = null;
    private String initScript = null;
    private String mapScript = null;
    private String combineScript = null;
    private String reduceScript = null;
    private String initScriptFile = null;
    private String mapScriptFile = null;
    private String combineScriptFile = null;
    private String reduceScriptFile = null;
    private String initScriptId = null;
    private String mapScriptId = null;
    private String combineScriptId = null;
    private String reduceScriptId = null;
    private String lang = null;

    public ScriptedMetricBuilder(String name) {
        super(name, InternalScriptedMetric.TYPE.name());
    }

    public ScriptedMetricBuilder params(Map<String, Object> params) {
        this.params = params;
        return this;
    }

    public ScriptedMetricBuilder reduceParams(Map<String, Object> reduceParams) {
        this.reduceParams = reduceParams;
        return this;
    }

    public ScriptedMetricBuilder initScript(String initScript) {
        this.initScript = initScript;
        return this;
    }

    public ScriptedMetricBuilder mapScript(String mapScript) {
        this.mapScript = mapScript;
        return this;
    }

    public ScriptedMetricBuilder combineScript(String combineScript) {
        this.combineScript = combineScript;
        return this;
    }

    public ScriptedMetricBuilder reduceScript(String reduceScript) {
        this.reduceScript = reduceScript;
        return this;
    }

    public ScriptedMetricBuilder initScriptFile(String initScriptFile) {
        this.initScriptFile = initScriptFile;
        return this;
    }

    public ScriptedMetricBuilder mapScriptFile(String mapScriptFile) {
        this.mapScriptFile = mapScriptFile;
        return this;
    }

    public ScriptedMetricBuilder combineScriptFile(String combineScriptFile) {
        this.combineScriptFile = combineScriptFile;
        return this;
    }

    public ScriptedMetricBuilder reduceScriptFile(String reduceScriptFile) {
        this.reduceScriptFile = reduceScriptFile;
        return this;
    }

    public ScriptedMetricBuilder initScriptId(String initScriptId) {
        this.initScriptId = initScriptId;
        return this;
    }

    public ScriptedMetricBuilder mapScriptId(String mapScriptId) {
        this.mapScriptId = mapScriptId;
        return this;
    }

    public ScriptedMetricBuilder combineScriptId(String combineScriptId) {
        this.combineScriptId = combineScriptId;
        return this;
    }

    public ScriptedMetricBuilder reduceScriptId(String reduceScriptId) {
        this.reduceScriptId = reduceScriptId;
        return this;
    }

    public ScriptedMetricBuilder lang(String lang) {
        this.lang = lang;
        return this;
    }

    @Override
    protected void internalXContent(XContentBuilder builder, ToXContent.Params builderParams) throws IOException {
        if (this.params != null) {
            builder.field(ScriptedMetricParser.PARAMS_FIELD.getPreferredName());
            builder.map(this.params);
        }
        if (this.reduceParams != null) {
            builder.field(ScriptedMetricParser.REDUCE_PARAMS_FIELD.getPreferredName());
            builder.map(this.reduceParams);
        }
        if (this.initScript != null) {
            builder.field(ScriptedMetricParser.INIT_SCRIPT_FIELD.getPreferredName(), this.initScript);
        }
        if (this.mapScript != null) {
            builder.field(ScriptedMetricParser.MAP_SCRIPT_FIELD.getPreferredName(), this.mapScript);
        }
        if (this.combineScript != null) {
            builder.field(ScriptedMetricParser.COMBINE_SCRIPT_FIELD.getPreferredName(), this.combineScript);
        }
        if (this.reduceScript != null) {
            builder.field(ScriptedMetricParser.REDUCE_SCRIPT_FIELD.getPreferredName(), this.reduceScript);
        }
        if (this.initScriptFile != null) {
            builder.field(ScriptedMetricParser.INIT_SCRIPT_FILE_FIELD.getPreferredName(), this.initScriptFile);
        }
        if (this.mapScriptFile != null) {
            builder.field(ScriptedMetricParser.MAP_SCRIPT_FILE_FIELD.getPreferredName(), this.mapScriptFile);
        }
        if (this.combineScriptFile != null) {
            builder.field(ScriptedMetricParser.COMBINE_SCRIPT_FILE_FIELD.getPreferredName(), this.combineScriptFile);
        }
        if (this.reduceScriptFile != null) {
            builder.field(ScriptedMetricParser.REDUCE_SCRIPT_FILE_FIELD.getPreferredName(), this.reduceScriptFile);
        }
        if (this.initScriptId != null) {
            builder.field(ScriptedMetricParser.INIT_SCRIPT_ID_FIELD.getPreferredName(), this.initScriptId);
        }
        if (this.mapScriptId != null) {
            builder.field(ScriptedMetricParser.MAP_SCRIPT_ID_FIELD.getPreferredName(), this.mapScriptId);
        }
        if (this.combineScriptId != null) {
            builder.field(ScriptedMetricParser.COMBINE_SCRIPT_ID_FIELD.getPreferredName(), this.combineScriptId);
        }
        if (this.reduceScriptId != null) {
            builder.field(ScriptedMetricParser.REDUCE_SCRIPT_ID_FIELD.getPreferredName(), this.reduceScriptId);
        }
        if (this.lang != null) {
            builder.field(ScriptedMetricParser.LANG_FIELD.getPreferredName(), this.lang);
        }
    }
}

