/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.nested;

import java.io.IOException;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Filter;
import org.apache.lucene.util.FixedBitSet;
import org.elasticsearch.common.hppc.LongIntOpenHashMap;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.lucene.ReaderContextAware;
import org.elasticsearch.common.lucene.docset.DocIdSets;
import org.elasticsearch.common.recycler.Recycler;
import org.elasticsearch.index.cache.fixedbitset.FixedBitSetFilter;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.object.ObjectMapper;
import org.elasticsearch.index.search.nested.NonNestedDocsFilter;
import org.elasticsearch.search.SearchParseException;
import org.elasticsearch.search.aggregations.AggregationExecutionException;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.bucket.SingleBucketAggregator;
import org.elasticsearch.search.aggregations.bucket.nested.InternalReverseNested;
import org.elasticsearch.search.aggregations.bucket.nested.NestedAggregator;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.internal.SearchContext;

public class ReverseNestedAggregator
extends SingleBucketAggregator
implements ReaderContextAware {
    private final FixedBitSetFilter parentFilter;
    private DocIdSetIterator parentDocs;
    private final Recycler.V<LongIntOpenHashMap> bucketOrdToLastCollectedParentDocRecycler;
    private final LongIntOpenHashMap bucketOrdToLastCollectedParentDoc;

    public ReverseNestedAggregator(String name, AggregatorFactories factories, String nestedPath, AggregationContext aggregationContext, Aggregator parent) {
        super(name, factories, aggregationContext, parent);
        NestedAggregator closestNestedAggregator = ReverseNestedAggregator.findClosestNestedAggregator(parent);
        if (closestNestedAggregator == null) {
            throw new SearchParseException(this.context.searchContext(), "Reverse nested aggregation [" + name + "] can only be used inside a [nested] aggregation");
        }
        if (nestedPath == null) {
            this.parentFilter = SearchContext.current().fixedBitSetFilterCache().getFixedBitSetFilter(NonNestedDocsFilter.INSTANCE);
        } else {
            MapperService.SmartNameObjectMapper mapper = SearchContext.current().smartNameObjectMapper(nestedPath);
            if (mapper == null) {
                throw new AggregationExecutionException("[reverse_nested] nested path [" + nestedPath + "] not found");
            }
            ObjectMapper objectMapper = mapper.mapper();
            if (objectMapper == null) {
                throw new AggregationExecutionException("[reverse_nested] nested path [" + nestedPath + "] not found");
            }
            if (!objectMapper.nested().isNested()) {
                throw new AggregationExecutionException("[reverse_nested] nested path [" + nestedPath + "] is not nested");
            }
            this.parentFilter = SearchContext.current().fixedBitSetFilterCache().getFixedBitSetFilter(objectMapper.nestedTypeFilter());
        }
        this.bucketOrdToLastCollectedParentDocRecycler = aggregationContext.searchContext().cacheRecycler().longIntMap(32);
        this.bucketOrdToLastCollectedParentDoc = this.bucketOrdToLastCollectedParentDocRecycler.v();
        aggregationContext.ensureScoreDocsInOrder();
    }

    @Override
    public void setNextReader(AtomicReaderContext reader) {
        this.bucketOrdToLastCollectedParentDoc.clear();
        try {
            FixedBitSet docIdSet = this.parentFilter.getDocIdSet(reader, null);
            this.parentDocs = DocIdSets.isEmpty((DocIdSet)docIdSet) ? null : docIdSet.iterator();
        }
        catch (IOException ioe) {
            throw new AggregationExecutionException("Failed to aggregate [" + this.name + "]", ioe);
        }
    }

    @Override
    public void collect(int childDoc, long bucketOrd) throws IOException {
        if (this.parentDocs == null) {
            return;
        }
        int parentDoc = this.parentDocs.docID() < childDoc ? this.parentDocs.advance(childDoc) : this.parentDocs.docID();
        assert (childDoc <= parentDoc && parentDoc != Integer.MAX_VALUE);
        if (this.bucketOrdToLastCollectedParentDoc.containsKey(bucketOrd)) {
            int lastCollectedParentDoc = this.bucketOrdToLastCollectedParentDoc.lget();
            if (parentDoc > lastCollectedParentDoc) {
                this.innerCollect(parentDoc, bucketOrd);
                this.bucketOrdToLastCollectedParentDoc.lset(parentDoc);
            }
        } else {
            this.innerCollect(parentDoc, bucketOrd);
            this.bucketOrdToLastCollectedParentDoc.put(bucketOrd, parentDoc);
        }
    }

    private void innerCollect(int parentDoc, long bucketOrd) throws IOException {
        this.collectBucket(parentDoc, bucketOrd);
    }

    private static NestedAggregator findClosestNestedAggregator(Aggregator parent) {
        while (parent != null) {
            if (parent instanceof NestedAggregator) {
                return (NestedAggregator)parent;
            }
            parent = parent.parent();
        }
        return null;
    }

    @Override
    public InternalAggregation buildAggregation(long owningBucketOrdinal) {
        return new InternalReverseNested(this.name, this.bucketDocCount(owningBucketOrdinal), this.bucketAggregations(owningBucketOrdinal));
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return new InternalReverseNested(this.name, 0L, this.buildEmptySubAggregations());
    }

    Filter getParentFilter() {
        return this.parentFilter;
    }

    @Override
    protected void doClose() {
        Releasables.close(this.bucketOrdToLastCollectedParentDocRecycler);
    }

    public static class Factory
    extends AggregatorFactory {
        private final String path;

        public Factory(String name, String path) {
            super(name, InternalReverseNested.TYPE.name());
            this.path = path;
        }

        @Override
        public Aggregator create(AggregationContext context, Aggregator parent, long expectedBucketsCount) {
            return new ReverseNestedAggregator(this.name, this.factories, this.path, context, parent);
        }
    }
}

