/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.hppc.ObjectContainer;
import org.elasticsearch.common.hppc.cursors.ObjectCursor;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.snapshots.IndexShardRepository;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.repositories.VerificationFailure;
import org.elasticsearch.transport.BaseTransportRequestHandler;
import org.elasticsearch.transport.EmptyTransportResponseHandler;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportService;

public class VerifyNodeRepositoryAction
extends AbstractComponent {
    public static final String ACTION_NAME = "internal:admin/repository/verify";
    private final TransportService transportService;
    private final ClusterService clusterService;
    private final RepositoriesService repositoriesService;

    public VerifyNodeRepositoryAction(Settings settings, TransportService transportService, ClusterService clusterService, RepositoriesService repositoriesService) {
        super(settings);
        this.transportService = transportService;
        this.clusterService = clusterService;
        this.repositoriesService = repositoriesService;
        transportService.registerHandler(ACTION_NAME, new VerifyNodeRepositoryRequestHandler());
    }

    public void close() {
        this.transportService.removeHandler(ACTION_NAME);
    }

    public void verify(String repository, String verificationToken, final ActionListener<RepositoriesService.VerifyResponse> listener) {
        DiscoveryNodes discoNodes = this.clusterService.state().nodes();
        DiscoveryNode localNode = discoNodes.localNode();
        ObjectContainer<DiscoveryNode> masterAndDataNodes = discoNodes.masterAndDataNodes().values();
        final ArrayList<DiscoveryNode> nodes = Lists.newArrayList();
        for (ObjectCursor<DiscoveryNode> objectCursor : masterAndDataNodes) {
            DiscoveryNode node = (DiscoveryNode)objectCursor.value;
            Version version = node.getVersion();
            if (version == null || !version.onOrAfter(Version.V_1_4_0)) continue;
            nodes.add(node);
        }
        final CopyOnWriteArrayList<VerificationFailure> errors = new CopyOnWriteArrayList<VerificationFailure>();
        final AtomicInteger atomicInteger = new AtomicInteger(nodes.size());
        for (final DiscoveryNode node : nodes) {
            if (node.equals(localNode)) {
                try {
                    this.doVerify(repository, verificationToken);
                }
                catch (Throwable t) {
                    errors.add(new VerificationFailure(node.id(), ExceptionsHelper.detailedMessage(t)));
                }
                if (atomicInteger.decrementAndGet() != 0) continue;
                this.finishVerification(listener, nodes, errors);
                continue;
            }
            this.transportService.sendRequest(node, ACTION_NAME, new VerifyNodeRepositoryRequest(repository, verificationToken), new EmptyTransportResponseHandler("same"){

                @Override
                public void handleResponse(TransportResponse.Empty response) {
                    if (atomicInteger.decrementAndGet() == 0) {
                        VerifyNodeRepositoryAction.this.finishVerification(listener, nodes, errors);
                    }
                }

                @Override
                public void handleException(TransportException exp) {
                    errors.add(new VerificationFailure(node.id(), ExceptionsHelper.detailedMessage(exp)));
                    if (atomicInteger.decrementAndGet() == 0) {
                        VerifyNodeRepositoryAction.this.finishVerification(listener, nodes, errors);
                    }
                }
            });
        }
    }

    public void finishVerification(ActionListener<RepositoriesService.VerifyResponse> listener, List<DiscoveryNode> nodes, CopyOnWriteArrayList<VerificationFailure> errors) {
        listener.onResponse(new RepositoriesService.VerifyResponse(nodes.toArray(new DiscoveryNode[nodes.size()]), errors.toArray(new VerificationFailure[errors.size()])));
    }

    private void doVerify(String repository, String verificationToken) {
        IndexShardRepository blobStoreIndexShardRepository = this.repositoriesService.indexShardRepository(repository);
        blobStoreIndexShardRepository.verify(verificationToken);
    }

    private class VerifyNodeRepositoryRequestHandler
    extends BaseTransportRequestHandler<VerifyNodeRepositoryRequest> {
        private VerifyNodeRepositoryRequestHandler() {
        }

        @Override
        public VerifyNodeRepositoryRequest newInstance() {
            return new VerifyNodeRepositoryRequest();
        }

        @Override
        public String executor() {
            return "same";
        }

        @Override
        public void messageReceived(VerifyNodeRepositoryRequest request, TransportChannel channel) throws Exception {
            VerifyNodeRepositoryAction.this.doVerify(request.repository, request.verificationToken);
            channel.sendResponse(TransportResponse.Empty.INSTANCE);
        }
    }

    private class VerifyNodeRepositoryRequest
    extends TransportRequest {
        private String repository;
        private String verificationToken;

        private VerifyNodeRepositoryRequest() {
        }

        private VerifyNodeRepositoryRequest(String repository, String verificationToken) {
            this.repository = repository;
            this.verificationToken = verificationToken;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.repository = in.readString();
            this.verificationToken = in.readString();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.repository);
            out.writeString(this.verificationToken);
        }
    }
}

