/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.store;

import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.Adler32;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.IndexNotFoundException;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.BufferedChecksum;
import org.apache.lucene.store.ByteArrayDataInput;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FilterDirectory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.SimpleFSDirectory;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.Version;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.Iterables;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.compress.Compressor;
import org.elasticsearch.common.compress.CompressorFactory;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.lucene.Directories;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.CloseableIndexComponent;
import org.elasticsearch.index.codec.CodecService;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.shard.AbstractIndexShardComponent;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.store.DirectoryService;
import org.elasticsearch.index.store.DistributorDirectory;
import org.elasticsearch.index.store.LegacyVerification;
import org.elasticsearch.index.store.StoreFileMetaData;
import org.elasticsearch.index.store.StoreStats;
import org.elasticsearch.index.store.VerifyingIndexOutput;
import org.elasticsearch.index.store.distributor.Distributor;

public class Store
extends AbstractIndexShardComponent
implements CloseableIndexComponent,
Closeable {
    private static final String CODEC = "store";
    private static final int VERSION_STACK_TRACE = 1;
    private static final int VERSION_START = 0;
    private static final int VERSION = 1;
    private static final String CORRUPTED = "corrupted_";
    private final AtomicBoolean isClosed = new AtomicBoolean(false);
    private final AtomicInteger refCount = new AtomicInteger(1);
    private final CodecService codecService;
    private final DirectoryService directoryService;
    private final StoreDirectory directory;
    private final DistributorDirectory distributorDirectory;
    private static final String CHECKSUMS_PREFIX = "_checksums-";

    @Inject
    public Store(ShardId shardId, @IndexSettings Settings indexSettings, CodecService codecService, DirectoryService directoryService, Distributor distributor) throws IOException {
        super(shardId, indexSettings);
        this.codecService = codecService;
        this.directoryService = directoryService;
        this.distributorDirectory = new DistributorDirectory(distributor);
        this.directory = new StoreDirectory((Directory)this.distributorDirectory);
    }

    public Directory directory() {
        this.ensureOpen();
        return this.directory;
    }

    public SegmentInfos readLastCommittedSegmentsInfo() throws IOException {
        return Store.readSegmentsInfo(null, this.directory());
    }

    private static SegmentInfos readSegmentsInfo(IndexCommit commit, Directory directory) throws IOException {
        try {
            return commit == null ? Lucene.readSegmentInfos(directory) : Lucene.readSegmentInfos(commit, directory);
        }
        catch (EOFException eof) {
            throw new CorruptIndexException("Read past EOF while reading segment infos", (Throwable)eof);
        }
        catch (IOException exception) {
            throw exception;
        }
        catch (Exception ex) {
            throw new CorruptIndexException("Hit unexpected exception while reading segment infos", (Throwable)ex);
        }
    }

    final void ensureOpen() {
        if (this.refCount.get() <= 0) {
            throw new AlreadyClosedException("Store is already closed");
        }
    }

    public MetadataSnapshot getMetadataOrEmpty() throws IOException {
        try {
            return this.getMetadata(null);
        }
        catch (IndexNotFoundException ex) {
        }
        catch (FileNotFoundException | NoSuchFileException ex) {
            this.logger.info("Failed to open / find files while reading metadata snapshot", new Object[0]);
        }
        return MetadataSnapshot.EMPTY;
    }

    public MetadataSnapshot getMetadata() throws IOException {
        return this.getMetadata(null);
    }

    public MetadataSnapshot getMetadata(IndexCommit commit) throws IOException {
        this.ensureOpen();
        this.failIfCorrupted();
        try {
            return new MetadataSnapshot(commit, (Directory)this.distributorDirectory, this.logger);
        }
        catch (CorruptIndexException ex) {
            this.markStoreCorrupted(ex);
            throw ex;
        }
    }

    public void deleteContent() throws IOException {
        this.ensureOpen();
        String[] files = this.distributorDirectory.listAll();
        IOException lastException = null;
        for (String file : files) {
            try {
                this.distributorDirectory.deleteFile(file);
            }
            catch (FileNotFoundException | NoSuchFileException e) {
            }
            catch (IOException e) {
                lastException = e;
            }
        }
        if (lastException != null) {
            throw lastException;
        }
    }

    public StoreStats stats() throws IOException {
        this.ensureOpen();
        return new StoreStats(Directories.estimateSize((Directory)this.directory), this.directoryService.throttleTimeInNanos());
    }

    public void renameFile(String from, String to) throws IOException {
        this.ensureOpen();
        this.distributorDirectory.renameFile(this.directoryService, from, to);
    }

    public boolean suggestUseCompoundFile() {
        return false;
    }

    public final void incRef() {
        if (!this.tryIncRef()) {
            throw new AlreadyClosedException("Store is already closed can't increment refCount current count [" + this.refCount.get() + "]");
        }
    }

    public final boolean tryIncRef() {
        int i;
        while ((i = this.refCount.get()) > 0) {
            if (!this.refCount.compareAndSet(i, i + 1)) continue;
            return true;
        }
        return false;
    }

    public final void decRef() {
        int i = this.refCount.decrementAndGet();
        assert (i >= 0);
        if (i == 0) {
            this.closeInternal();
        }
    }

    @Override
    public void close() {
        if (this.isClosed.compareAndSet(false, true)) {
            this.decRef();
        }
    }

    private void closeInternal() {
        try {
            this.directory.innerClose();
        }
        catch (IOException e) {
            this.logger.debug("failed to close directory", e, new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MetadataSnapshot readMetadataSnapshot(File[] indexLocations, ESLogger logger) throws IOException {
        Directory[] dirs = new Directory[indexLocations.length];
        try {
            for (int i = 0; i < indexLocations.length; ++i) {
                dirs[i] = new SimpleFSDirectory(indexLocations[i]);
            }
            DistributorDirectory dir = new DistributorDirectory(dirs);
            Store.failIfCorrupted((Directory)dir, new ShardId("", 1));
            MetadataSnapshot metadataSnapshot = new MetadataSnapshot(null, (Directory)dir, logger);
            return metadataSnapshot;
        }
        catch (IndexNotFoundException ex) {
        }
        catch (FileNotFoundException | NoSuchFileException ex) {
            logger.info("Failed to open / find files while reading metadata snapshot", new Object[0]);
        }
        finally {
            IOUtils.close((Closeable[])dirs);
        }
        return MetadataSnapshot.EMPTY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IndexOutput createVerifyingOutput(String fileName, StoreFileMetaData metadata, IOContext context) throws IOException {
        IndexOutput output = this.directory().createOutput(fileName, context);
        boolean success = false;
        try {
            if (metadata.hasLegacyChecksum()) {
                this.logger.debug("create legacy adler32 output for {}", fileName);
                return new LegacyVerification.Adler32VerifyingIndexOutput(output, metadata.checksum(), metadata.length());
            }
            if (metadata.checksum() == null) {
                this.logger.debug("create legacy length-only output for {}", fileName);
                return new LegacyVerification.LengthVerifyingIndexOutput(output, metadata.length());
            }
            assert (metadata.writtenBy() != null);
            if ($assertionsDisabled) return new LuceneVerifyingIndexOutput(metadata, output);
            if (metadata.writtenBy().onOrAfter(Version.LUCENE_48)) return new LuceneVerifyingIndexOutput(metadata, output);
            throw new AssertionError();
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{output});
            throw throwable;
        }
    }

    public static void verify(IndexOutput output) throws IOException {
        if (output instanceof VerifyingIndexOutput) {
            ((VerifyingIndexOutput)output).verify();
        }
    }

    public IndexInput openVerifyingInput(String filename, IOContext context, StoreFileMetaData metadata) throws IOException {
        if (metadata.hasLegacyChecksum() || metadata.checksum() == null) {
            this.logger.debug("open legacy input for {}", filename);
            return this.directory().openInput(filename, context);
        }
        assert (metadata.writtenBy() != null);
        assert (metadata.writtenBy().onOrAfter(Version.LUCENE_48));
        return new VerifyingIndexInput(this.directory().openInput(filename, context));
    }

    public static void verify(IndexInput input) throws IOException {
        if (input instanceof VerifyingIndexInput) {
            ((VerifyingIndexInput)input).verify();
        }
    }

    public boolean checkIntegrity(StoreFileMetaData md) {
        return Store.checkIntegrity(md, this.directory());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean checkIntegrity(StoreFileMetaData md, Directory directory) {
        try (IndexInput input = directory.openInput(md.name(), IOContext.READONCE);){
            int bytesToRead;
            if (input.length() != md.length()) {
                boolean bl = false;
                return bl;
            }
            if (md.writtenBy() != null && md.writtenBy().onOrAfter(Version.LUCENE_48)) {
                boolean bl = Store.digestToString(CodecUtil.checksumEntireFile((IndexInput)input)).equals(md.checksum());
                return bl;
            }
            if (!md.hasLegacyChecksum()) return true;
            Adler32 checksum = new Adler32();
            byte[] buffer = new byte[md.length() > 4096L ? 4096 : (int)md.length()];
            long len = input.length();
            for (long read = 0L; len > read; read += (long)bytesToRead) {
                long bytesLeft = len - read;
                bytesToRead = bytesLeft < (long)buffer.length ? (int)bytesLeft : buffer.length;
                input.readBytes(buffer, 0, bytesToRead, false);
                checksum.update(buffer, 0, bytesToRead);
            }
            boolean bl = Store.digestToString(checksum.getValue()).equals(md.checksum());
            return bl;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public boolean isMarkedCorrupted() throws IOException {
        String[] files;
        this.ensureOpen();
        for (String file : files = this.directory().listAll()) {
            if (!file.startsWith(CORRUPTED)) continue;
            return true;
        }
        return false;
    }

    public void failIfCorrupted() throws IOException {
        this.ensureOpen();
        Store.failIfCorrupted((Directory)this.directory, this.shardId);
    }

    private static final void failIfCorrupted(Directory directory, ShardId shardId) throws IOException {
        String[] files = directory.listAll();
        ArrayList<CorruptIndexException> ex = new ArrayList<CorruptIndexException>();
        for (String file : files) {
            if (!file.startsWith(CORRUPTED)) continue;
            try (ChecksumIndexInput input = directory.openChecksumInput(file, IOContext.READONCE);){
                int version = CodecUtil.checkHeader((DataInput)input, (String)CODEC, (int)0, (int)1);
                String msg = input.readString();
                StringBuilder builder = new StringBuilder(shardId.toString());
                builder.append(" Preexisting corrupted index [");
                builder.append(file).append("] caused by: ");
                builder.append(msg);
                if (version == 1) {
                    builder.append(System.lineSeparator());
                    builder.append(input.readString());
                }
                ex.add(new CorruptIndexException(builder.toString()));
                CodecUtil.checkFooter((ChecksumIndexInput)input);
            }
        }
        if (!ex.isEmpty()) {
            ExceptionsHelper.rethrowAndSuppress(ex);
        }
    }

    public void logDeleteFile(String message, String fileName) {
        Store.logDeleteFile(this.directory(), message, fileName);
    }

    public static void logDeleteFile(Directory dir, String message, String fileName) {
        assert (dir instanceof StoreDirectory);
        if (dir instanceof StoreDirectory) {
            ((StoreDirectory)dir).deletesLogger.trace("{}: delete file {}", message, fileName);
        }
    }

    public static final boolean isChecksum(String name) {
        return name.startsWith(CHECKSUMS_PREFIX) || name.endsWith(".cks");
    }

    public static String digestToString(long digest) {
        return Long.toString(digest, 36);
    }

    public void deleteQuiet(String ... files) {
        for (String file : files) {
            try {
                this.directory().deleteFile(file);
            }
            catch (Throwable ex) {
                // empty catch block
            }
        }
    }

    public void markStoreCorrupted(CorruptIndexException exception) throws IOException {
        this.ensureOpen();
        if (!this.isMarkedCorrupted()) {
            String uuid = CORRUPTED + Strings.randomBase64UUID();
            try (IndexOutput output = this.directory().createOutput(uuid, IOContext.DEFAULT);){
                CodecUtil.writeHeader((DataOutput)output, (String)CODEC, (int)1);
                output.writeString(ExceptionsHelper.detailedMessage(exception, true, 0));
                output.writeString(ExceptionsHelper.stackTrace(exception));
                CodecUtil.writeFooter((IndexOutput)output);
            }
            catch (IOException ex) {
                this.logger.warn("Can't mark store as corrupted", ex, new Object[0]);
            }
            this.directory().sync(Collections.singleton(uuid));
        }
    }

    static class VerifyingIndexInput
    extends ChecksumIndexInput {
        private final IndexInput input;
        private final Checksum digest;
        private final long checksumPosition;
        private final byte[] checksum = new byte[8];
        private long verifiedPosition = 0L;

        public VerifyingIndexInput(IndexInput input) {
            this(input, (Checksum)new BufferedChecksum((Checksum)new CRC32()));
        }

        public VerifyingIndexInput(IndexInput input, Checksum digest) {
            super("VerifyingIndexInput(" + input + ")");
            this.input = input;
            this.digest = digest;
            this.checksumPosition = input.length() - 8L;
        }

        public byte readByte() throws IOException {
            long pos = this.input.getFilePointer();
            byte b = this.input.readByte();
            if (++pos > this.verifiedPosition) {
                if (pos <= this.checksumPosition) {
                    this.digest.update(b);
                } else {
                    this.checksum[(int)(pos - this.checksumPosition - 1L)] = b;
                }
                this.verifiedPosition = pos;
            }
            return b;
        }

        public void readBytes(byte[] b, int offset, int len) throws IOException {
            long pos = this.input.getFilePointer();
            this.input.readBytes(b, offset, len);
            if (pos + (long)len > this.verifiedPosition) {
                int alreadyVerified = (int)Math.max(0L, this.verifiedPosition - pos);
                if (pos < this.checksumPosition) {
                    if (pos + (long)len < this.checksumPosition) {
                        this.digest.update(b, offset + alreadyVerified, len - alreadyVerified);
                    } else {
                        int checksumOffset = (int)(this.checksumPosition - pos);
                        if (checksumOffset - alreadyVerified > 0) {
                            this.digest.update(b, offset + alreadyVerified, checksumOffset - alreadyVerified);
                        }
                        System.arraycopy(b, offset + checksumOffset, this.checksum, 0, len - checksumOffset);
                    }
                } else {
                    assert (pos - this.checksumPosition < 8L);
                    System.arraycopy(b, offset, this.checksum, (int)(pos - this.checksumPosition), len);
                }
                this.verifiedPosition = pos + (long)len;
            }
        }

        public long getChecksum() {
            return this.digest.getValue();
        }

        public void seek(long pos) throws IOException {
            if (pos < this.verifiedPosition) {
                this.input.seek(pos);
            } else if (this.verifiedPosition > this.getFilePointer()) {
                this.input.seek(this.verifiedPosition);
                this.skipBytes(pos - this.verifiedPosition);
            } else {
                this.skipBytes(pos - this.getFilePointer());
            }
        }

        public void close() throws IOException {
            this.input.close();
        }

        public long getFilePointer() {
            return this.input.getFilePointer();
        }

        public long length() {
            return this.input.length();
        }

        public IndexInput clone() {
            throw new UnsupportedOperationException();
        }

        public IndexInput slice(String sliceDescription, long offset, long length) throws IOException {
            throw new UnsupportedOperationException();
        }

        public long getStoredChecksum() {
            return new ByteArrayDataInput(this.checksum).readLong();
        }

        public void verify() throws CorruptIndexException {
            long storedChecksum = this.getStoredChecksum();
            if (this.getChecksum() == storedChecksum) {
                return;
            }
            throw new CorruptIndexException("verification failed : calculated=" + Store.digestToString(this.getChecksum()) + " stored=" + Store.digestToString(storedChecksum));
        }
    }

    static class LuceneVerifyingIndexOutput
    extends VerifyingIndexOutput {
        private final StoreFileMetaData metadata;
        private long writtenBytes;
        private final long checksumPosition;
        private String actualChecksum;

        LuceneVerifyingIndexOutput(StoreFileMetaData metadata, IndexOutput out) {
            super(out);
            this.metadata = metadata;
            this.checksumPosition = metadata.length() - 8L;
        }

        @Override
        public void verify() throws IOException {
            if (this.metadata.checksum().equals(this.actualChecksum) && this.writtenBytes == this.metadata.length()) {
                return;
            }
            throw new CorruptIndexException("verification failed (hardware problem?) : expected=" + this.metadata.checksum() + " actual=" + this.actualChecksum + " writtenLength=" + this.writtenBytes + " expectedLength=" + this.metadata.length() + " (resource=" + this.metadata.toString() + ")");
        }

        public void writeByte(byte b) throws IOException {
            if (this.writtenBytes++ == this.checksumPosition) {
                this.readAndCompareChecksum();
            }
            this.out.writeByte(b);
        }

        private void readAndCompareChecksum() throws IOException {
            this.actualChecksum = Store.digestToString(this.getChecksum());
            if (!this.metadata.checksum().equals(this.actualChecksum)) {
                throw new CorruptIndexException("checksum failed (hardware problem?) : expected=" + this.metadata.checksum() + " actual=" + this.actualChecksum + " (resource=" + this.metadata.toString() + ")");
            }
        }

        public void writeBytes(byte[] b, int offset, int length) throws IOException {
            if (this.writtenBytes + (long)length > this.checksumPosition && this.actualChecksum == null) {
                assert (this.writtenBytes <= this.checksumPosition);
                int bytesToWrite = (int)(this.checksumPosition - this.writtenBytes);
                this.out.writeBytes(b, offset, bytesToWrite);
                this.readAndCompareChecksum();
                offset += bytesToWrite;
                length -= bytesToWrite;
                this.writtenBytes += (long)bytesToWrite;
            }
            this.out.writeBytes(b, offset, length);
            this.writtenBytes += (long)length;
        }
    }

    public static final class LegacyChecksums {
        private final Map<String, String> legacyChecksums = new HashMap<String, String>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(StoreFileMetaData metaData) throws IOException {
            if (metaData.hasLegacyChecksum()) {
                LegacyChecksums legacyChecksums = this;
                synchronized (legacyChecksums) {
                    this.legacyChecksums.put(metaData.name(), metaData.checksum());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void write(Store store) throws IOException {
            DistributorDirectory distributorDirectory = store.distributorDirectory;
            synchronized (distributorDirectory) {
                Tuple<Map<String, String>, Long> tuple = MetadataSnapshot.readLegacyChecksums((Directory)store.distributorDirectory);
                tuple.v1().putAll(this.legacyChecksums);
                if (!tuple.v1().isEmpty()) {
                    this.writeChecksums((Directory)store.directory, tuple.v1(), tuple.v2());
                }
            }
        }

        synchronized void writeChecksums(Directory directory, Map<String, String> checksums, long lastVersion) throws IOException {
            long nextVersion = System.currentTimeMillis();
            while (nextVersion <= lastVersion) {
                nextVersion = System.currentTimeMillis();
            }
            String checksumName = Store.CHECKSUMS_PREFIX + nextVersion;
            try (IndexOutput output = directory.createOutput(checksumName, IOContext.DEFAULT);){
                output.writeInt(0);
                output.writeStringStringMap(checksums);
            }
            directory.sync(Collections.singleton(checksumName));
            MetadataSnapshot.cleanLegacyChecksums(directory, nextVersion);
        }

        public void clear() {
            this.legacyChecksums.clear();
        }

        public void remove(String name) {
            this.legacyChecksums.remove(name);
        }
    }

    public static final class RecoveryDiff {
        public final List<StoreFileMetaData> identical;
        public final List<StoreFileMetaData> different;
        public final List<StoreFileMetaData> missing;

        RecoveryDiff(List<StoreFileMetaData> identical, List<StoreFileMetaData> different, List<StoreFileMetaData> missing) {
            this.identical = identical;
            this.different = different;
            this.missing = missing;
        }

        public int size() {
            return this.identical.size() + this.different.size() + this.missing.size();
        }
    }

    public static final class MetadataSnapshot
    implements Iterable<StoreFileMetaData> {
        private static final ESLogger logger = Loggers.getLogger(MetadataSnapshot.class);
        private final Map<String, StoreFileMetaData> metadata;
        public static final MetadataSnapshot EMPTY = new MetadataSnapshot();
        private static final String DEL_FILE_EXTENSION = "del";
        private static final String FIELD_INFOS_FILE_EXTENSION = "fnm";

        public MetadataSnapshot(Map<String, StoreFileMetaData> metadata) {
            this.metadata = metadata;
        }

        MetadataSnapshot() {
            this.metadata = Collections.emptyMap();
        }

        MetadataSnapshot(IndexCommit commit, Directory directory, ESLogger logger) throws IOException {
            this.metadata = this.buildMetadata(commit, directory, logger);
        }

        ImmutableMap<String, StoreFileMetaData> buildMetadata(IndexCommit commit, Directory directory, ESLogger logger) throws IOException {
            ImmutableMap.Builder<String, StoreFileMetaData> builder = ImmutableMap.builder();
            Tuple<Map<String, String>, Long> tuple = MetadataSnapshot.readLegacyChecksums(directory);
            try {
                SegmentInfos segmentCommitInfos = Store.readSegmentsInfo(commit, directory);
                Version maxVersion = Version.LUCENE_3_0;
                for (SegmentCommitInfo info : segmentCommitInfos) {
                    Version version = info.info.getVersion();
                    if (version != null && version.onOrAfter(maxVersion)) {
                        maxVersion = version;
                    }
                    for (String file : info.files()) {
                        String legacyChecksum = tuple.v1().get(file);
                        if (version.onOrAfter(Version.LUCENE_4_8) && legacyChecksum == null) {
                            MetadataSnapshot.checksumFromLuceneFile(directory, file, builder, logger, version, "si".equals(IndexFileNames.getExtension((String)file)));
                            continue;
                        }
                        builder.put(file, new StoreFileMetaData(file, directory.fileLength(file), legacyChecksum, null));
                    }
                }
                String segmentsFile = segmentCommitInfos.getSegmentsFileName();
                String legacyChecksum = tuple.v1().get(segmentsFile);
                if (maxVersion.onOrAfter(Version.LUCENE_4_8) && legacyChecksum == null) {
                    MetadataSnapshot.checksumFromLuceneFile(directory, segmentsFile, builder, logger, maxVersion, true);
                } else {
                    builder.put(segmentsFile, new StoreFileMetaData(segmentsFile, directory.fileLength(segmentsFile), legacyChecksum, null));
                }
            }
            catch (CorruptIndexException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                try {
                    Lucene.checkSegmentInfoIntegrity(directory);
                }
                catch (CorruptIndexException cex) {
                    cex.addSuppressed(ex);
                    throw cex;
                }
                catch (Throwable e) {
                    // empty catch block
                }
                throw ex;
            }
            return builder.build();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        static Tuple<Map<String, String>, Long> readLegacyChecksums(Directory directory) throws IOException {
            Directory directory2 = directory;
            synchronized (directory2) {
                long lastFound = -1L;
                for (String name : directory.listAll()) {
                    long current;
                    if (!Store.isChecksum(name) || (current = Long.parseLong(name.substring(Store.CHECKSUMS_PREFIX.length()))) <= lastFound) continue;
                    lastFound = current;
                }
                if (lastFound <= -1L) {
                    return new Tuple<Map<String, String>, Long>(new HashMap(), -1L);
                }
                try (IndexInput indexInput = directory.openInput(Store.CHECKSUMS_PREFIX + lastFound, IOContext.READONCE);){
                    indexInput.readInt();
                    Tuple<Map<String, String>, Long> tuple = new Tuple<Map<String, String>, Long>(indexInput.readStringStringMap(), lastFound);
                    return tuple;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void cleanLegacyChecksums(Directory directory, long newVersion) throws IOException {
            Directory directory2 = directory;
            synchronized (directory2) {
                for (String name : directory.listAll()) {
                    long current;
                    if (!Store.isChecksum(name) || (current = Long.parseLong(name.substring(Store.CHECKSUMS_PREFIX.length()))) >= newVersion) continue;
                    try {
                        directory.deleteFile(name);
                    }
                    catch (IOException ex) {
                        logger.debug("can't delete old checksum file [{}]", ex, name);
                    }
                }
            }
        }

        private static void checksumFromLuceneFile(Directory directory, String file, ImmutableMap.Builder<String, StoreFileMetaData> builder, ESLogger logger, Version version, boolean readFileAsHash) throws IOException {
            BytesRef fileHash = new BytesRef();
            try (IndexInput in = directory.openInput(file, IOContext.READONCE);){
                String checksum;
                try {
                    if (in.length() < (long)CodecUtil.footerLength()) {
                        throw new CorruptIndexException("Can't retrieve checksum from file: " + file + " file length must be >= " + CodecUtil.footerLength() + " but was: " + in.length());
                    }
                    if (readFileAsHash) {
                        MetadataSnapshot.hashFile(fileHash, in);
                    }
                    checksum = Store.digestToString(CodecUtil.retrieveChecksum((IndexInput)in));
                }
                catch (Throwable ex) {
                    logger.debug("Can retrieve checksum from file [{}]", ex, file);
                    throw ex;
                }
                builder.put(file, new StoreFileMetaData(file, directory.fileLength(file), checksum, version, fileHash));
            }
        }

        public static void hashFile(BytesRef fileHash, IndexInput in) throws IOException {
            int len = (int)Math.min(0x100000L, in.length());
            fileHash.offset = 0;
            fileHash.grow(len);
            fileHash.length = len;
            in.readBytes(fileHash.bytes, 0, len);
        }

        public static void hashFile(BytesRef fileHash, BytesRef source) throws IOException {
            int len = Math.min(0x100000, source.length);
            fileHash.offset = 0;
            fileHash.grow(len);
            fileHash.length = len;
            System.arraycopy(source.bytes, source.offset, fileHash.bytes, 0, len);
        }

        @Override
        public Iterator<StoreFileMetaData> iterator() {
            return this.metadata.values().iterator();
        }

        public StoreFileMetaData get(String name) {
            return this.metadata.get(name);
        }

        public Map<String, StoreFileMetaData> asMap() {
            return this.metadata;
        }

        public RecoveryDiff recoveryDiff(MetadataSnapshot recoveryTargetSnapshot) {
            ImmutableList.Builder identical = ImmutableList.builder();
            ImmutableList.Builder different = ImmutableList.builder();
            ImmutableList.Builder missing = ImmutableList.builder();
            HashMap<String, ArrayList<StoreFileMetaData>> perSegment = new HashMap<String, ArrayList<StoreFileMetaData>>();
            ArrayList<StoreFileMetaData> perCommitStoreFiles = new ArrayList<StoreFileMetaData>();
            for (StoreFileMetaData meta : this) {
                if ("segments.gen".equals(meta.name())) continue;
                String string = IndexFileNames.parseSegmentName((String)meta.name());
                String extension = IndexFileNames.getExtension((String)meta.name());
                assert (!FIELD_INFOS_FILE_EXTENSION.equals(extension) || IndexFileNames.stripExtension((String)IndexFileNames.stripSegmentName((String)meta.name())).isEmpty()) : "FieldInfos are generational but updateable DV are not supported in elasticsearch";
                if ("segments".equals(string) || DEL_FILE_EXTENSION.equals(extension)) {
                    perCommitStoreFiles.add(meta);
                    continue;
                }
                ArrayList<StoreFileMetaData> perSegStoreFiles = (ArrayList<StoreFileMetaData>)perSegment.get(string);
                if (perSegStoreFiles == null) {
                    perSegStoreFiles = new ArrayList<StoreFileMetaData>();
                    perSegment.put(string, perSegStoreFiles);
                }
                perSegStoreFiles.add(meta);
            }
            ArrayList<StoreFileMetaData> identicalFiles = new ArrayList<StoreFileMetaData>();
            for (List list : Iterables.concat(perSegment.values(), Collections.singleton(perCommitStoreFiles))) {
                identicalFiles.clear();
                boolean consistent = true;
                for (StoreFileMetaData meta : list) {
                    StoreFileMetaData storeFileMetaData = recoveryTargetSnapshot.get(meta.name());
                    if (storeFileMetaData == null) {
                        consistent = false;
                        missing.add(meta);
                        continue;
                    }
                    if (!storeFileMetaData.isSame(meta)) {
                        consistent = false;
                        different.add(meta);
                        continue;
                    }
                    identicalFiles.add(meta);
                }
                if (consistent) {
                    identical.addAll(identicalFiles);
                    continue;
                }
                different.addAll(identicalFiles);
            }
            RecoveryDiff recoveryDiff = new RecoveryDiff((List<StoreFileMetaData>)((Object)identical.build()), (List<StoreFileMetaData>)((Object)different.build()), (List<StoreFileMetaData>)((Object)missing.build()));
            assert (recoveryDiff.size() == this.metadata.size() - (this.metadata.containsKey("segments.gen") ? 1 : 0)) : "some files are missing recoveryDiff size: [" + recoveryDiff.size() + "] metadata size: [" + this.metadata.size() + "] contains  segments.gen: [" + this.metadata.containsKey("segments.gen") + "]";
            return recoveryDiff;
        }

        public int size() {
            return this.metadata.size();
        }
    }

    public class StoreDirectory
    extends FilterDirectory {
        public final ESLogger deletesLogger;

        StoreDirectory(Directory delegateDirectory) throws IOException {
            super(delegateDirectory);
            this.deletesLogger = Loggers.getLogger("index.store.deletes", Store.this.indexSettings, Store.this.shardId, new String[0]);
        }

        public ShardId shardId() {
            this.ensureOpen();
            return Store.this.shardId();
        }

        @Nullable
        public CodecService codecService() {
            this.ensureOpen();
            return Store.this.codecService;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public IndexInput openInput(String name, IOContext context) throws IOException {
            IndexInput in = super.openInput(name, context);
            boolean success = false;
            try {
                Compressor compressor;
                if ((name.endsWith(".fdt") || name.endsWith(".tvf")) && (compressor = CompressorFactory.compressor(in)) != null) {
                    return compressor.indexInput(in);
                }
                success = true;
                if (success) return in;
            }
            catch (Throwable throwable) {
                if (success) throw throwable;
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{in});
                throw throwable;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{in});
            return in;
        }

        public void close() throws IOException {
            assert (false) : "Nobody should close this directory except of the Store itself";
        }

        public void deleteFile(String name) throws IOException {
            Store.this.logDeleteFile("StoreDirectory.deleteFile", name);
            super.deleteFile(name);
        }

        private void innerClose() throws IOException {
            super.close();
        }

        public String toString() {
            return "store(" + this.in.toString() + ")";
        }
    }
}

