/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.util.Locale;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;

public class SimpleQueryParser
extends org.apache.lucene.queryparser.simple.SimpleQueryParser {
    private final Settings settings;

    public SimpleQueryParser(Analyzer analyzer, Map<String, Float> weights, int flags, Settings settings) {
        super(analyzer, weights, flags);
        this.settings = settings;
    }

    private Query rethrowUnlessLenient(RuntimeException e) {
        if (this.settings.lenient()) {
            return null;
        }
        throw e;
    }

    public Query newDefaultQuery(String text) {
        BooleanQuery bq = new BooleanQuery(true);
        for (Map.Entry entry : this.weights.entrySet()) {
            try {
                Query q = this.createBooleanQuery((String)entry.getKey(), text, super.getDefaultOperator());
                if (q == null) continue;
                q.setBoost(((Float)entry.getValue()).floatValue());
                bq.add(q, BooleanClause.Occur.SHOULD);
            }
            catch (RuntimeException e) {
                this.rethrowUnlessLenient(e);
            }
        }
        return super.simplify(bq);
    }

    public Query newFuzzyQuery(String text, int fuzziness) {
        if (this.settings.lowercaseExpandedTerms()) {
            text = text.toLowerCase(this.settings.locale());
        }
        BooleanQuery bq = new BooleanQuery(true);
        for (Map.Entry entry : this.weights.entrySet()) {
            try {
                FuzzyQuery q = new FuzzyQuery(new Term((String)entry.getKey(), text), fuzziness);
                if (q == null) continue;
                q.setBoost(((Float)entry.getValue()).floatValue());
                bq.add((Query)q, BooleanClause.Occur.SHOULD);
            }
            catch (RuntimeException e) {
                this.rethrowUnlessLenient(e);
            }
        }
        return super.simplify(bq);
    }

    public Query newPhraseQuery(String text, int slop) {
        BooleanQuery bq = new BooleanQuery(true);
        for (Map.Entry entry : this.weights.entrySet()) {
            try {
                Query q = this.createPhraseQuery((String)entry.getKey(), text, slop);
                if (q == null) continue;
                q.setBoost(((Float)entry.getValue()).floatValue());
                bq.add(q, BooleanClause.Occur.SHOULD);
            }
            catch (RuntimeException e) {
                this.rethrowUnlessLenient(e);
            }
        }
        return super.simplify(bq);
    }

    public Query newPrefixQuery(String text) {
        if (this.settings.lowercaseExpandedTerms()) {
            text = text.toLowerCase(this.settings.locale());
        }
        BooleanQuery bq = new BooleanQuery(true);
        for (Map.Entry entry : this.weights.entrySet()) {
            try {
                PrefixQuery prefix = new PrefixQuery(new Term((String)entry.getKey(), text));
                prefix.setBoost(((Float)entry.getValue()).floatValue());
                bq.add((Query)prefix, BooleanClause.Occur.SHOULD);
            }
            catch (RuntimeException e) {
                return this.rethrowUnlessLenient(e);
            }
        }
        return super.simplify(bq);
    }

    public static class Settings {
        private Locale locale = Locale.ROOT;
        private boolean lowercaseExpandedTerms = true;
        private boolean lenient = false;

        public void locale(Locale locale) {
            this.locale = locale;
        }

        public Locale locale() {
            return this.locale;
        }

        public void lowercaseExpandedTerms(boolean lowercaseExpandedTerms) {
            this.lowercaseExpandedTerms = lowercaseExpandedTerms;
        }

        public boolean lowercaseExpandedTerms() {
            return this.lowercaseExpandedTerms;
        }

        public void lenient(boolean lenient) {
            this.lenient = lenient;
        }

        public boolean lenient() {
            return this.lenient;
        }
    }
}

