/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.merge.policy;

import org.apache.lucene.index.LogByteSizeMergePolicy;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.Preconditions;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.index.merge.policy.AbstractMergePolicyProvider;
import org.elasticsearch.index.settings.IndexSettingsService;
import org.elasticsearch.index.store.Store;

public class LogByteSizeMergePolicyProvider
extends AbstractMergePolicyProvider<LogByteSizeMergePolicy> {
    private final IndexSettingsService indexSettingsService;
    private final ApplySettings applySettings = new ApplySettings();
    private final LogByteSizeMergePolicy mergePolicy = new LogByteSizeMergePolicy();
    private static final ByteSizeValue DEFAULT_MIN_MERGE_SIZE = new ByteSizeValue(0x199999L, ByteSizeUnit.BYTES);
    private static final ByteSizeValue DEFAULT_MAX_MERGE_SIZE = new ByteSizeValue(2048L, ByteSizeUnit.MB);
    public static final String INDEX_MERGE_POLICY_MIN_MERGE_SIZE = "index.merge.policy.min_merge_size";
    public static final String INDEX_MERGE_POLICY_MAX_MERGE_SIZE = "index.merge.policy.max_merge_size";
    public static final String INDEX_MERGE_POLICY_MAX_MERGE_DOCS = "index.merge.policy.max_merge_docs";
    public static final String INDEX_MERGE_POLICY_MERGE_FACTOR = "index.merge.policy.merge_factor";
    public static final String INDEX_MERGE_POLICY_CALIBRATE_SIZE_BY_DELETES = "index.merge.policy.calibrate_size_by_deletes";

    @Inject
    public LogByteSizeMergePolicyProvider(Store store, IndexSettingsService indexSettingsService) {
        super(store);
        Preconditions.checkNotNull(store, "Store must be provided to merge policy");
        this.indexSettingsService = indexSettingsService;
        ByteSizeValue minMergeSize = this.componentSettings.getAsBytesSize("min_merge_size", DEFAULT_MIN_MERGE_SIZE);
        ByteSizeValue maxMergeSize = this.componentSettings.getAsBytesSize("max_merge_size", DEFAULT_MAX_MERGE_SIZE);
        int mergeFactor = this.componentSettings.getAsInt("merge_factor", (Integer)10);
        int maxMergeDocs = this.componentSettings.getAsInt("max_merge_docs", (Integer)Integer.MAX_VALUE);
        boolean calibrateSizeByDeletes = this.componentSettings.getAsBoolean("calibrate_size_by_deletes", (Boolean)true);
        this.mergePolicy.setMinMergeMB(minMergeSize.mbFrac());
        this.mergePolicy.setMaxMergeMB(maxMergeSize.mbFrac());
        this.mergePolicy.setMergeFactor(mergeFactor);
        this.mergePolicy.setMaxMergeDocs(maxMergeDocs);
        this.mergePolicy.setCalibrateSizeByDeletes(calibrateSizeByDeletes);
        this.mergePolicy.setNoCFSRatio(this.noCFSRatio);
        this.logger.debug("using [log_bytes_size] merge policy with merge_factor[{}], min_merge_size[{}], max_merge_size[{}], max_merge_docs[{}], calibrate_size_by_deletes[{}]", mergeFactor, minMergeSize, maxMergeSize, maxMergeDocs, calibrateSizeByDeletes);
        indexSettingsService.addListener(this.applySettings);
    }

    @Override
    public LogByteSizeMergePolicy getMergePolicy() {
        return this.mergePolicy;
    }

    @Override
    public void close() throws ElasticsearchException {
        this.indexSettingsService.removeListener(this.applySettings);
    }

    class ApplySettings
    implements IndexSettingsService.Listener {
        ApplySettings() {
        }

        @Override
        public void onRefreshSettings(Settings settings) {
            double noCFSRatio;
            double oldMinMergeSizeMB = LogByteSizeMergePolicyProvider.this.mergePolicy.getMinMergeMB();
            ByteSizeValue minMergeSize = settings.getAsBytesSize(LogByteSizeMergePolicyProvider.INDEX_MERGE_POLICY_MIN_MERGE_SIZE, DEFAULT_MIN_MERGE_SIZE);
            if (minMergeSize.mbFrac() != oldMinMergeSizeMB) {
                LogByteSizeMergePolicyProvider.this.logger.info("updating min_merge_size from [{}mb] to [{}]", oldMinMergeSizeMB, minMergeSize);
                LogByteSizeMergePolicyProvider.this.mergePolicy.setMinMergeMB(minMergeSize.mbFrac());
            }
            double oldMaxMergeSizeMB = LogByteSizeMergePolicyProvider.this.mergePolicy.getMaxMergeMB();
            ByteSizeValue maxMergeSize = settings.getAsBytesSize(LogByteSizeMergePolicyProvider.INDEX_MERGE_POLICY_MAX_MERGE_SIZE, DEFAULT_MAX_MERGE_SIZE);
            if (maxMergeSize.mbFrac() != oldMaxMergeSizeMB) {
                LogByteSizeMergePolicyProvider.this.logger.info("updating max_merge_size from [{}mb] to [{}]", oldMaxMergeSizeMB, maxMergeSize);
                LogByteSizeMergePolicyProvider.this.mergePolicy.setMaxMergeMB(maxMergeSize.mbFrac());
            }
            int oldMaxMergeDocs = LogByteSizeMergePolicyProvider.this.mergePolicy.getMaxMergeDocs();
            int maxMergeDocs = settings.getAsInt(LogByteSizeMergePolicyProvider.INDEX_MERGE_POLICY_MAX_MERGE_DOCS, (Integer)Integer.MAX_VALUE);
            if (maxMergeDocs != oldMaxMergeDocs) {
                LogByteSizeMergePolicyProvider.this.logger.info("updating max_merge_docs from [{}] to [{}]", oldMaxMergeDocs, maxMergeDocs);
                LogByteSizeMergePolicyProvider.this.mergePolicy.setMaxMergeDocs(maxMergeDocs);
            }
            int oldMergeFactor = LogByteSizeMergePolicyProvider.this.mergePolicy.getMergeFactor();
            int mergeFactor = settings.getAsInt(LogByteSizeMergePolicyProvider.INDEX_MERGE_POLICY_MERGE_FACTOR, (Integer)10);
            if (mergeFactor != oldMergeFactor) {
                LogByteSizeMergePolicyProvider.this.logger.info("updating merge_factor from [{}] to [{}]", oldMergeFactor, mergeFactor);
                LogByteSizeMergePolicyProvider.this.mergePolicy.setMergeFactor(mergeFactor);
            }
            boolean oldCalibrateSizeByDeletes = LogByteSizeMergePolicyProvider.this.mergePolicy.getCalibrateSizeByDeletes();
            boolean calibrateSizeByDeletes = settings.getAsBoolean(LogByteSizeMergePolicyProvider.INDEX_MERGE_POLICY_CALIBRATE_SIZE_BY_DELETES, (Boolean)true);
            if (calibrateSizeByDeletes != oldCalibrateSizeByDeletes) {
                LogByteSizeMergePolicyProvider.this.logger.info("updating calibrate_size_by_deletes from [{}] to [{}]", oldCalibrateSizeByDeletes, calibrateSizeByDeletes);
                LogByteSizeMergePolicyProvider.this.mergePolicy.setCalibrateSizeByDeletes(calibrateSizeByDeletes);
            }
            if ((noCFSRatio = AbstractMergePolicyProvider.parseNoCFSRatio(settings.get("index.compound_format", Double.toString(LogByteSizeMergePolicyProvider.this.noCFSRatio)))) != LogByteSizeMergePolicyProvider.this.noCFSRatio) {
                LogByteSizeMergePolicyProvider.this.logger.info("updating index.compound_format from [{}] to [{}]", AbstractMergePolicyProvider.formatNoCFSRatio(LogByteSizeMergePolicyProvider.this.noCFSRatio), AbstractMergePolicyProvider.formatNoCFSRatio(noCFSRatio));
                LogByteSizeMergePolicyProvider.this.noCFSRatio = noCFSRatio;
                LogByteSizeMergePolicyProvider.this.mergePolicy.setNoCFSRatio(noCFSRatio);
            }
        }
    }
}

