/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gateway.local;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.MutableShardRouting;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.RoutingNodes;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.FailedRerouteAllocation;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.StartedRerouteAllocation;
import org.elasticsearch.cluster.routing.allocation.allocator.GatewayAllocator;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.collect.Sets;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.hppc.ObjectLongOpenHashMap;
import org.elasticsearch.common.hppc.ObjectOpenHashSet;
import org.elasticsearch.common.hppc.cursors.ObjectCursor;
import org.elasticsearch.common.hppc.predicates.ObjectPredicate;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.gateway.local.state.shards.TransportNodesListGatewayStartedShards;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.store.StoreFileMetaData;
import org.elasticsearch.indices.store.TransportNodesListShardStoreMetaData;
import org.elasticsearch.transport.ConnectTransportException;

public class LocalGatewayAllocator
extends AbstractComponent
implements GatewayAllocator {
    public static final String INDEX_RECOVERY_INITIAL_SHARDS = "index.recovery.initial_shards";
    private final TransportNodesListGatewayStartedShards listGatewayStartedShards;
    private final TransportNodesListShardStoreMetaData listShardStoreMetaData;
    private final ConcurrentMap<ShardId, Map<DiscoveryNode, TransportNodesListShardStoreMetaData.StoreFilesMetaData>> cachedStores = ConcurrentCollections.newConcurrentMap();
    private final ConcurrentMap<ShardId, ObjectLongOpenHashMap<DiscoveryNode>> cachedShardsState = ConcurrentCollections.newConcurrentMap();
    private final TimeValue listTimeout;
    private final String initialShards;

    @Inject
    public LocalGatewayAllocator(Settings settings, TransportNodesListGatewayStartedShards listGatewayStartedShards, TransportNodesListShardStoreMetaData listShardStoreMetaData) {
        super(settings);
        this.listGatewayStartedShards = listGatewayStartedShards;
        this.listShardStoreMetaData = listShardStoreMetaData;
        this.listTimeout = this.componentSettings.getAsTime("list_timeout", TimeValue.timeValueSeconds(30L));
        this.initialShards = this.componentSettings.get("initial_shards", "quorum");
        this.logger.debug("using initial_shards [{}], list_timeout [{}]", this.initialShards, this.listTimeout);
    }

    @Override
    public void applyStartedShards(StartedRerouteAllocation allocation) {
        for (ShardRouting shardRouting : allocation.startedShards()) {
            this.cachedStores.remove(shardRouting.shardId());
            this.cachedShardsState.remove(shardRouting.shardId());
        }
    }

    @Override
    public void applyFailedShards(FailedRerouteAllocation allocation) {
        for (ShardRouting failedShard : allocation.failedShards()) {
            this.cachedStores.remove(failedShard.shardId());
            this.cachedShardsState.remove(failedShard.shardId());
        }
    }

    @Override
    public boolean allocateUnassigned(RoutingAllocation allocation) {
        MutableShardRouting shard;
        boolean changed = false;
        DiscoveryNodes nodes = allocation.nodes();
        RoutingNodes routingNodes = allocation.routingNodes();
        Iterator<MutableShardRouting> unassignedIterator = routingNodes.unassigned().iterator();
        while (unassignedIterator.hasNext()) {
            shard = unassignedIterator.next();
            if (!shard.primary() || !routingNodes.routingTable().index(shard.index()).shard(shard.id()).primaryAllocatedPostApi()) continue;
            ObjectLongOpenHashMap<DiscoveryNode> nodesState = this.buildShardStates(nodes, shard);
            int numberOfAllocationsFound = 0;
            long highestVersion = -1L;
            HashSet<DiscoveryNode> nodesWithHighestVersion = Sets.newHashSet();
            boolean[] states = nodesState.allocated;
            KType[] keys = nodesState.keys;
            long[] values = nodesState.values;
            for (int i = 0; i < states.length; ++i) {
                if (!states[i]) continue;
                DiscoveryNode node = (DiscoveryNode)keys[i];
                long version = values[i];
                if (allocation.shouldIgnoreShardForNode(shard.shardId(), node.id()) || version == -1L) continue;
                ++numberOfAllocationsFound;
                if (highestVersion == -1L) {
                    nodesWithHighestVersion.add(node);
                    highestVersion = version;
                    continue;
                }
                if (version > highestVersion) {
                    nodesWithHighestVersion.clear();
                    nodesWithHighestVersion.add(node);
                    highestVersion = version;
                    continue;
                }
                if (version != highestVersion) continue;
                nodesWithHighestVersion.add(node);
            }
            int requiredAllocation = 1;
            if (shard.restoreSource() == null) {
                try {
                    IndexMetaData indexMetaData = routingNodes.metaData().index(shard.index());
                    String initialShards = indexMetaData.settings().get(INDEX_RECOVERY_INITIAL_SHARDS, this.settings.get(INDEX_RECOVERY_INITIAL_SHARDS, this.initialShards));
                    if ("quorum".equals(initialShards)) {
                        if (indexMetaData.numberOfReplicas() > 1) {
                            requiredAllocation = (1 + indexMetaData.numberOfReplicas()) / 2 + 1;
                        }
                    } else if ("quorum-1".equals(initialShards) || "half".equals(initialShards)) {
                        if (indexMetaData.numberOfReplicas() > 2) {
                            requiredAllocation = (1 + indexMetaData.numberOfReplicas()) / 2;
                        }
                    } else if ("one".equals(initialShards)) {
                        requiredAllocation = 1;
                    } else if ("full".equals(initialShards) || "all".equals(initialShards)) {
                        requiredAllocation = indexMetaData.numberOfReplicas() + 1;
                    } else if ("full-1".equals(initialShards) || "all-1".equals(initialShards)) {
                        if (indexMetaData.numberOfReplicas() > 1) {
                            requiredAllocation = indexMetaData.numberOfReplicas();
                        }
                    } else {
                        requiredAllocation = Integer.parseInt(initialShards);
                    }
                }
                catch (Exception e) {
                    this.logger.warn("[{}][{}] failed to derived initial_shards from value {}, ignore allocation for {}", shard.index(), shard.id(), this.initialShards, shard);
                }
            }
            if (numberOfAllocationsFound < requiredAllocation) {
                if (shard.restoreSource() == null) {
                    unassignedIterator.remove();
                    routingNodes.ignoredUnassigned().add(shard);
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug("[{}][{}]: not allocating, number_of_allocated_shards_found [{}], required_number [{}]", shard.index(), shard.id(), numberOfAllocationsFound, requiredAllocation);
                    continue;
                }
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("[{}][{}]: missing local data, will restore from [{}]", shard.index(), shard.id(), shard.restoreSource());
                continue;
            }
            HashSet<DiscoveryNode> throttledNodes = Sets.newHashSet();
            HashSet<DiscoveryNode> noNodes = Sets.newHashSet();
            for (DiscoveryNode discoNode : nodesWithHighestVersion) {
                RoutingNode node = routingNodes.node(discoNode.id());
                if (node == null) continue;
                Decision decision = allocation.deciders().canAllocate(shard, node, allocation);
                if (decision.type() == Decision.Type.THROTTLE) {
                    throttledNodes.add(discoNode);
                    continue;
                }
                if (decision.type() == Decision.Type.NO) {
                    noNodes.add(discoNode);
                    continue;
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("[{}][{}]: allocating [{}] to [{}] on primary allocation", shard.index(), shard.id(), shard, discoNode);
                }
                changed = true;
                allocation.routingNodes().assign(new MutableShardRouting(shard, highestVersion), node.nodeId());
                unassignedIterator.remove();
                throttledNodes.clear();
                noNodes.clear();
                break;
            }
            if (throttledNodes.isEmpty()) {
                if (noNodes.isEmpty()) continue;
                DiscoveryNode discoNode = (DiscoveryNode)noNodes.iterator().next();
                RoutingNode node = routingNodes.node(discoNode.id());
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("[{}][{}]: forcing allocating [{}] to [{}] on primary allocation", shard.index(), shard.id(), shard, discoNode);
                }
                changed = true;
                allocation.routingNodes().assign(new MutableShardRouting(shard, highestVersion), node.nodeId());
                unassignedIterator.remove();
                continue;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("[{}][{}]: throttling allocation [{}] to [{}] on primary allocation", shard.index(), shard.id(), shard, throttledNodes);
            }
            unassignedIterator.remove();
            routingNodes.ignoredUnassigned().add(shard);
        }
        if (!routingNodes.hasUnassigned()) {
            return changed;
        }
        unassignedIterator = routingNodes.unassigned().iterator();
        while (unassignedIterator.hasNext()) {
            shard = unassignedIterator.next();
            boolean canBeAllocatedToAtLeastOneNode = false;
            for (ObjectCursor<DiscoveryNode> objectCursor : nodes.dataNodes().values()) {
                Decision decision;
                RoutingNode node = routingNodes.node(((DiscoveryNode)objectCursor.value).id());
                if (node == null || (decision = allocation.deciders().canAllocate(shard, node, allocation)).type() != Decision.Type.YES) continue;
                canBeAllocatedToAtLeastOneNode = true;
                break;
            }
            if (!canBeAllocatedToAtLeastOneNode) continue;
            Map<DiscoveryNode, TransportNodesListShardStoreMetaData.StoreFilesMetaData> shardStores = this.buildShardStores(nodes, shard);
            long lastSizeMatched = 0L;
            DiscoveryNode lastDiscoNodeMatched = null;
            RoutingNode lastNodeMatched = null;
            for (Map.Entry<DiscoveryNode, TransportNodesListShardStoreMetaData.StoreFilesMetaData> nodeStoreEntry : shardStores.entrySet()) {
                TransportNodesListShardStoreMetaData.StoreFilesMetaData primaryNodeStore;
                MutableShardRouting primaryShard;
                Decision decision;
                RoutingNode node;
                DiscoveryNode discoNode = nodeStoreEntry.getKey();
                TransportNodesListShardStoreMetaData.StoreFilesMetaData storeFilesMetaData = nodeStoreEntry.getValue();
                this.logger.trace("{}: checking node [{}]", shard, discoNode);
                if (storeFilesMetaData == null || (node = routingNodes.node(discoNode.id())) == null || (decision = allocation.deciders().canAllocate(shard, node, allocation)).type() == Decision.Type.NO || storeFilesMetaData.allocated() || shard.primary() || (primaryShard = routingNodes.activePrimary(shard)) == null) continue;
                assert (primaryShard.active());
                DiscoveryNode primaryNode = nodes.get(primaryShard.currentNodeId());
                if (primaryNode == null || (primaryNodeStore = shardStores.get(primaryNode)) == null || !primaryNodeStore.allocated()) continue;
                long sizeMatched = 0L;
                for (StoreFileMetaData storeFileMetaData : storeFilesMetaData) {
                    if (!primaryNodeStore.fileExists(storeFileMetaData.name()) || !primaryNodeStore.file(storeFileMetaData.name()).isSame(storeFileMetaData)) continue;
                    sizeMatched += storeFileMetaData.length();
                }
                if (sizeMatched <= lastSizeMatched) continue;
                lastSizeMatched = sizeMatched;
                lastDiscoNodeMatched = discoNode;
                lastNodeMatched = node;
            }
            if (lastNodeMatched == null) continue;
            Decision decision = allocation.deciders().canAllocate(shard, lastNodeMatched, allocation);
            if (decision.type() == Decision.Type.THROTTLE) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.debug("[{}][{}]: throttling allocation [{}] to [{}] in order to reuse its unallocated persistent store with total_size [{}]", shard.index(), shard.id(), shard, lastDiscoNodeMatched, new ByteSizeValue(lastSizeMatched));
                }
                unassignedIterator.remove();
                routingNodes.ignoredUnassigned().add(shard);
                continue;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("[{}][{}]: allocating [{}] to [{}] in order to reuse its unallocated persistent store with total_size [{}]", shard.index(), shard.id(), shard, lastDiscoNodeMatched, new ByteSizeValue(lastSizeMatched));
            }
            changed = true;
            allocation.routingNodes().assign(shard, lastNodeMatched.nodeId());
            unassignedIterator.remove();
        }
        return changed;
    }

    private ObjectLongOpenHashMap<DiscoveryNode> buildShardStates(final DiscoveryNodes nodes, MutableShardRouting shard) {
        ObjectOpenHashSet<Object> nodeIds;
        ObjectLongOpenHashMap<DiscoveryNode> shardStates = (ObjectLongOpenHashMap<DiscoveryNode>)this.cachedShardsState.get(shard.shardId());
        if (shardStates == null) {
            shardStates = new ObjectLongOpenHashMap<DiscoveryNode>();
            this.cachedShardsState.put(shard.shardId(), shardStates);
            nodeIds = ObjectOpenHashSet.from(nodes.dataNodes().keys());
        } else {
            shardStates.keys().removeAll(new ObjectPredicate<DiscoveryNode>(){

                @Override
                public boolean apply(DiscoveryNode node) {
                    return !nodes.nodeExists(node.id());
                }
            });
            nodeIds = ObjectOpenHashSet.newInstance();
            for (ObjectCursor<DiscoveryNode> objectCursor : nodes.dataNodes().values()) {
                DiscoveryNode node = (DiscoveryNode)objectCursor.value;
                if (shardStates.containsKey(node)) continue;
                nodeIds.add(node.id());
            }
        }
        if (nodeIds.isEmpty()) {
            return shardStates;
        }
        String[] nodesIdsArray = (String[])nodeIds.toArray(String.class);
        TransportNodesListGatewayStartedShards.NodesLocalGatewayStartedShards nodesLocalGatewayStartedShards = this.listGatewayStartedShards.list(shard.shardId(), nodesIdsArray, this.listTimeout).actionGet();
        if (this.logger.isDebugEnabled() && nodesLocalGatewayStartedShards.failures().length > 0) {
            StringBuilder sb = new StringBuilder(shard + ": failures when trying to list shards on nodes:");
            for (int i = 0; i < nodesLocalGatewayStartedShards.failures().length; ++i) {
                Throwable cause = ExceptionsHelper.unwrapCause(nodesLocalGatewayStartedShards.failures()[i]);
                if (cause instanceof ConnectTransportException) continue;
                sb.append("\n    -> ").append(nodesLocalGatewayStartedShards.failures()[i].getDetailedMessage());
            }
            this.logger.debug(sb.toString(), new Object[0]);
        }
        for (TransportNodesListGatewayStartedShards.NodeLocalGatewayStartedShards nodeShardState : nodesLocalGatewayStartedShards) {
            shardStates.put(nodeShardState.getNode(), nodeShardState.version());
        }
        return shardStates;
    }

    private Map<DiscoveryNode, TransportNodesListShardStoreMetaData.StoreFilesMetaData> buildShardStores(DiscoveryNodes nodes, MutableShardRouting shard) {
        ObjectOpenHashSet<Object> nodesIds;
        HashMap<DiscoveryNode, TransportNodesListShardStoreMetaData.StoreFilesMetaData> shardStores = (HashMap<DiscoveryNode, TransportNodesListShardStoreMetaData.StoreFilesMetaData>)this.cachedStores.get(shard.shardId());
        if (shardStores == null) {
            shardStores = Maps.newHashMap();
            this.cachedStores.put(shard.shardId(), shardStores);
            nodesIds = ObjectOpenHashSet.from(nodes.dataNodes().keys());
        } else {
            nodesIds = ObjectOpenHashSet.newInstance();
            Iterator it = shardStores.keySet().iterator();
            while (it.hasNext()) {
                DiscoveryNode discoveryNode = (DiscoveryNode)it.next();
                if (nodes.nodeExists(discoveryNode.id())) continue;
                it.remove();
            }
            for (ObjectCursor<DiscoveryNode> objectCursor : nodes.dataNodes().values()) {
                DiscoveryNode node = (DiscoveryNode)objectCursor.value;
                if (shardStores.containsKey(node)) continue;
                nodesIds.add(node.id());
            }
        }
        if (!nodesIds.isEmpty()) {
            String[] nodesIdsArray = (String[])nodesIds.toArray(String.class);
            TransportNodesListShardStoreMetaData.NodesStoreFilesMetaData nodesStoreFilesMetaData = this.listShardStoreMetaData.list(shard.shardId(), false, nodesIdsArray, this.listTimeout).actionGet();
            if (this.logger.isTraceEnabled() && nodesStoreFilesMetaData.failures().length > 0) {
                StringBuilder sb = new StringBuilder(shard + ": failures when trying to list stores on nodes:");
                for (int i = 0; i < nodesStoreFilesMetaData.failures().length; ++i) {
                    Throwable cause = ExceptionsHelper.unwrapCause(nodesStoreFilesMetaData.failures()[i]);
                    if (cause instanceof ConnectTransportException) continue;
                    sb.append("\n    -> ").append(nodesStoreFilesMetaData.failures()[i].getDetailedMessage());
                }
                this.logger.trace(sb.toString(), new Object[0]);
            }
            for (TransportNodesListShardStoreMetaData.NodeStoreFilesMetaData nodeStoreFilesMetaData : nodesStoreFilesMetaData) {
                if (nodeStoreFilesMetaData.storeFilesMetaData() == null) continue;
                shardStores.put(nodeStoreFilesMetaData.getNode(), nodeStoreFilesMetaData.storeFilesMetaData());
            }
        }
        return shardStores;
    }
}

